/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.service;

import com.intellij.CodeStyleBundle;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.service.AbstractDocumentFormattingService;
import com.intellij.formatting.service.AsyncFormattingRequest;
import com.intellij.formatting.service.DocumentMerger;
import com.intellij.formatting.service.FormattingNotificationService;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncDocumentFormattingService
extends AbstractDocumentFormattingService {
    public static final Key<Boolean> FORMAT_DOCUMENT_SYNCHRONOUSLY = Key.create((String)"com.intellij.formatting.service.AsyncDocumentFormattingService.FORMAT_DOCUMENT_SYNCHRONOUSLY");
    private static final Logger LOG = Logger.getInstance(AsyncDocumentFormattingService.class);
    private final List<AsyncFormattingRequest> myPendingRequests = Collections.synchronizedList(new ArrayList());
    protected static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30L);
    private static final int RETRY_PERIOD = 1000;

    @Override
    public final synchronized void formatDocument(@NotNull Document document, @NotNull List<TextRange> formattingRanges, @NotNull FormattingContext formattingContext, boolean canChangeWhiteSpaceOnly, boolean quickFormat) {
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(0);
        }
        if (formattingRanges == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(1);
        }
        if (formattingContext == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(2);
        }
        AsyncFormattingRequest currRequest = this.findPendingRequest(document);
        boolean forceSync = Boolean.TRUE.equals(document.getUserData(FORMAT_DOCUMENT_SYNCHRONOUSLY));
        if (currRequest != null && !((FormattingRequestImpl)currRequest).cancel()) {
            LOG.warn("Pending request can't be cancelled");
            return;
        }
        this.prepareForFormatting(document, formattingContext);
        FormattingRequestImpl formattingRequest = new FormattingRequestImpl(formattingContext, document, formattingRanges, canChangeWhiteSpaceOnly, quickFormat);
        FormattingTask formattingTask = this.createFormattingTask(formattingRequest);
        if (formattingTask != null) {
            formattingRequest.setTask(formattingTask);
            this.myPendingRequests.add(formattingRequest);
            if (forceSync || ApplicationManager.getApplication().isHeadlessEnvironment()) {
                this.runAsyncFormat(formattingRequest, null);
            } else if (formattingTask.isRunUnderProgress()) {
                new FormattingProgressTask(formattingRequest).setCancelText(CodeStyleBundle.message("async.formatting.service.cancel", this.getName())).queue();
            } else {
                ApplicationManager.getApplication().executeOnPooledThread(() -> this.runAsyncFormat(formattingRequest, null));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private AsyncFormattingRequest findPendingRequest(@NotNull Document document) {
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(3);
        }
        List<AsyncFormattingRequest> list = this.myPendingRequests;
        synchronized (list) {
            return (AsyncFormattingRequest)ContainerUtil.find(this.myPendingRequests, request -> ((FormattingRequestImpl)request).getDocument() == document);
        }
    }

    private void runAsyncFormat(@NotNull FormattingRequestImpl formattingRequest, @Nullable ProgressIndicator indicator) {
        if (formattingRequest == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(4);
        }
        try {
            formattingRequest.runTask(indicator);
        }
        finally {
            this.myPendingRequests.remove(formattingRequest);
        }
    }

    @Nullable
    protected abstract FormattingTask createFormattingTask(@NotNull AsyncFormattingRequest var1);

    @NotNull
    protected abstract String getNotificationGroupId();

    @Nullable
    protected String getTimeoutNotificationDisplayId() {
        return null;
    }

    protected boolean needToUpdate() {
        return true;
    }

    @NotNull
    @NlsSafe
    protected abstract String getName();

    protected void prepareForFormatting(@NotNull Document document, @NotNull FormattingContext formattingContext) {
        if (document == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(5);
        }
        if (formattingContext == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(6);
        }
        FileDocumentManager.getInstance().saveDocument(document);
    }

    protected Duration getTimeout() {
        return DEFAULT_TIMEOUT;
    }

    protected AnAction[] getTimeoutActions(@NotNull FormattingContext context) {
        if (context == null) {
            AsyncDocumentFormattingService.$$$reportNull$$$0(7);
        }
        return AnAction.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRanges";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formattingRequest";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/formatting/service/AsyncDocumentFormattingService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "formatDocument";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findPendingRequest";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "runAsyncFormat";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareForFormatting";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getTimeoutActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class FormattingRequestImpl
    implements AsyncFormattingRequest {
        private static final String TEMP_FILE_PREFIX = "ij-format-temp";
        private final Document myDocument;
        private final List<TextRange> myRanges;
        private final long myInitialModificationStamp;
        private final FormattingContext myContext;
        private final boolean myCanChangeWhitespaceOnly;
        private final boolean myQuickFormat;
        private final Semaphore myTaskSemaphore;
        @Nullable
        private volatile FormattingTask myTask;
        @Nullable
        private String myResult;
        private final AtomicReference<FormattingRequestState> myStateRef;

        private FormattingRequestImpl(@NotNull FormattingContext formattingContext, @NotNull Document document, List<TextRange> ranges, boolean canChangeWhitespaceOnly, boolean quickFormat) {
            if (formattingContext == null) {
                FormattingRequestImpl.$$$reportNull$$$0(0);
            }
            if (document == null) {
                FormattingRequestImpl.$$$reportNull$$$0(1);
            }
            if (ranges == null) {
                FormattingRequestImpl.$$$reportNull$$$0(2);
            }
            this.myTaskSemaphore = new Semaphore(1);
            this.myStateRef = new AtomicReference<FormattingRequestState>(FormattingRequestState.NOT_STARTED);
            this.myContext = formattingContext;
            this.myDocument = document;
            this.myRanges = ranges;
            this.myCanChangeWhitespaceOnly = canChangeWhitespaceOnly;
            this.myQuickFormat = quickFormat;
            this.myInitialModificationStamp = document.getModificationStamp();
        }

        @Override
        @Nullable
        public File getIOFile() {
            Charset charset;
            String ext;
            VirtualFile originalFile = this.myContext.getVirtualFile();
            if (originalFile != null) {
                Path localPath;
                if (originalFile.isInLocalFileSystem() && (localPath = originalFile.getFileSystem().getNioPath(originalFile)) != null) {
                    return localPath.toFile();
                }
                ext = originalFile.getExtension();
                charset = originalFile.getCharset();
            } else {
                ext = this.myContext.getContainingFile().getFileType().getDefaultExtension();
                charset = EncodingManager.getInstance().getDefaultCharset();
            }
            try {
                File tempFile = FileUtilRt.createTempFile((String)TEMP_FILE_PREFIX, (String)("." + ext), (boolean)true);
                try (FileWriter writer = new FileWriter(tempFile, charset);){
                    writer.write(this.getDocumentText());
                }
                return tempFile;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                return null;
            }
        }

        @Override
        @NotNull
        public String getDocumentText() {
            String string = this.myDocument.getText();
            if (string == null) {
                FormattingRequestImpl.$$$reportNull$$$0(3);
            }
            return string;
        }

        private boolean cancel() {
            FormattingTask formattingTask = this.myTask;
            if (formattingTask != null && this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.CANCELLING) && formattingTask.cancel()) {
                this.myStateRef.set(FormattingRequestState.CANCELLED);
                this.myTaskSemaphore.release();
                return true;
            }
            return false;
        }

        private Document getDocument() {
            return this.myDocument;
        }

        @Override
        @NotNull
        public List<TextRange> getFormattingRanges() {
            List<TextRange> list = this.myRanges;
            if (list == null) {
                FormattingRequestImpl.$$$reportNull$$$0(4);
            }
            return list;
        }

        @Override
        public boolean canChangeWhitespaceOnly() {
            return this.myCanChangeWhitespaceOnly;
        }

        @Override
        @NotNull
        public FormattingContext getContext() {
            FormattingContext formattingContext = this.myContext;
            if (formattingContext == null) {
                FormattingRequestImpl.$$$reportNull$$$0(5);
            }
            return formattingContext;
        }

        private void setTask(@Nullable FormattingTask formattingTask) {
            this.myTask = formattingTask;
        }

        private void runTask(@Nullable ProgressIndicator indicator) {
            FormattingTask task = this.myTask;
            if (task != null && this.myStateRef.compareAndSet(FormattingRequestState.NOT_STARTED, FormattingRequestState.RUNNING)) {
                try {
                    this.myTaskSemaphore.acquire();
                    task.run();
                    for (long waitTime = 0L; waitTime < AsyncDocumentFormattingService.this.getTimeout().getSeconds() * 1000L; waitTime += 1000L) {
                        if (this.myTaskSemaphore.tryAcquire(1000L, TimeUnit.MILLISECONDS)) {
                            this.myTaskSemaphore.release();
                            break;
                        }
                        if (indicator == null) continue;
                        indicator.checkCanceled();
                    }
                    if (this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.EXPIRED)) {
                        FormattingNotificationService.getInstance(this.myContext.getProject()).reportError(AsyncDocumentFormattingService.this.getNotificationGroupId(), AsyncDocumentFormattingService.this.getTimeoutNotificationDisplayId(), AsyncDocumentFormattingService.this.getName(), CodeStyleBundle.message("async.formatting.service.timeout", AsyncDocumentFormattingService.this.getName(), Long.toString(AsyncDocumentFormattingService.this.getTimeout().getSeconds())), AsyncDocumentFormattingService.this.getTimeoutActions(this.myContext));
                    } else if (this.myResult != null) {
                        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
                            this.updateDocument(this.myResult);
                        } else {
                            ApplicationManager.getApplication().invokeLater(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                                try {
                                    WriteAction.run(() -> this.updateDocument(this.myResult));
                                }
                                catch (Throwable throwable) {
                                    LOG.error(throwable);
                                }
                            }));
                        }
                    }
                }
                catch (InterruptedException ie) {
                    LOG.warn("Interrupted formatting thread.");
                }
            }
        }

        private void updateDocument(@NotNull String newText) {
            if (newText == null) {
                FormattingRequestImpl.$$$reportNull$$$0(6);
            }
            if (!AsyncDocumentFormattingService.this.needToUpdate()) {
                return;
            }
            if (this.myDocument.getModificationStamp() > this.myInitialModificationStamp) {
                DocumentMerger merger;
                Iterator iterator = DocumentMerger.EP_NAME.getExtensionList().iterator();
                while (iterator.hasNext() && !(merger = (DocumentMerger)iterator.next()).updateDocument(this.myDocument, newText)) {
                }
            } else {
                this.myDocument.setText((CharSequence)newText);
            }
        }

        @Override
        public boolean isQuickFormat() {
            return this.myQuickFormat;
        }

        @Override
        public void onTextReady(@Nullable String updatedText) {
            if (this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.COMPLETED)) {
                this.myResult = updatedText;
                this.myTaskSemaphore.release();
            }
        }

        @Override
        public void onError(@NotNull String title, @NotNull String message) {
            if (title == null) {
                FormattingRequestImpl.$$$reportNull$$$0(7);
            }
            if (message == null) {
                FormattingRequestImpl.$$$reportNull$$$0(8);
            }
            this.onError(title, message, null);
        }

        @Override
        public void onError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @Nullable String displayId) {
            if (title == null) {
                FormattingRequestImpl.$$$reportNull$$$0(9);
            }
            if (message == null) {
                FormattingRequestImpl.$$$reportNull$$$0(10);
            }
            if (this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.COMPLETED)) {
                this.myTaskSemaphore.release();
                FormattingNotificationService.getInstance(this.myContext.getProject()).reportError(AsyncDocumentFormattingService.this.getNotificationGroupId(), displayId, title, message);
            }
        }

        @Override
        public void onError(@NotNull String title, @NotNull String message, int offset) {
            if (title == null) {
                FormattingRequestImpl.$$$reportNull$$$0(11);
            }
            if (message == null) {
                FormattingRequestImpl.$$$reportNull$$$0(12);
            }
            this.onError(title, message, null, offset);
        }

        @Override
        public void onError(@NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @Nullable String displayId, int offset) {
            if (title == null) {
                FormattingRequestImpl.$$$reportNull$$$0(13);
            }
            if (message == null) {
                FormattingRequestImpl.$$$reportNull$$$0(14);
            }
            if (this.myStateRef.compareAndSet(FormattingRequestState.RUNNING, FormattingRequestState.COMPLETED)) {
                this.myTaskSemaphore.release();
                FormattingNotificationService.getInstance(this.myContext.getProject()).reportErrorAndNavigate(AsyncDocumentFormattingService.this.getNotificationGroupId(), displayId, title, message, this.myContext, offset);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "formattingContext";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ranges";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/formatting/service/AsyncDocumentFormattingService$FormattingRequestImpl";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newText";
                    break;
                }
                case 7: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 8: 
                case 10: 
                case 12: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/formatting/service/AsyncDocumentFormattingService$FormattingRequestImpl";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDocumentText";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFormattingRanges";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "updateDocument";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "onError";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    protected static interface FormattingTask
    extends Runnable {
        public boolean cancel();

        default public boolean isRunUnderProgress() {
            return false;
        }
    }

    private class FormattingProgressTask
    extends Task.Backgroundable {
        private final FormattingRequestImpl myRequest;

        private FormattingProgressTask(FormattingRequestImpl request) {
            if (request == null) {
                FormattingProgressTask.$$$reportNull$$$0(0);
            }
            super(request.getContext().getProject(), CodeStyleBundle.message("async.formatting.service.running", AsyncDocumentFormattingService.this.getName()), true);
            this.myRequest = request;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                FormattingProgressTask.$$$reportNull$$$0(1);
            }
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            AsyncDocumentFormattingService.this.runAsyncFormat(this.myRequest, indicator);
            indicator.setFraction(1.0);
        }

        public void onCancel() {
            this.myRequest.cancel();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/formatting/service/AsyncDocumentFormattingService$FormattingProgressTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum FormattingRequestState {
        NOT_STARTED,
        RUNNING,
        CANCELLING,
        CANCELLED,
        COMPLETED,
        EXPIRED;

    }
}

