/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsService;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettingsFactory;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

class CustomCodeStyleSettingsManager {
    private final Map<String, CustomCodeStyleSettings> myCustomSettings;
    @NotNull
    private final CodeStyleSettings myRootSettings;
    private final Map<String, Element> myUnknownCustomElements;

    CustomCodeStyleSettingsManager(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        this.myCustomSettings = new HashMap<String, CustomCodeStyleSettings>();
        this.myUnknownCustomElements = new HashMap<String, Element>();
        this.myRootSettings = settings;
    }

    void initCustomSettings() {
        for (CustomCodeStyleSettingsFactory customCodeStyleSettingsFactory : CodeStyleSettingsService.getInstance().getCustomCodeStyleSettingsFactories()) {
            this.addCustomSettings(this.myRootSettings, customCodeStyleSettingsFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addCustomSettings(@NotNull CodeStyleSettings rootSettings, @NotNull CustomCodeStyleSettingsFactory factory) {
        CustomCodeStyleSettings customSettings;
        if (rootSettings == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        if (factory == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        if ((customSettings = factory.createCustomSettings(rootSettings)) != null) {
            Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
            synchronized (map) {
                this.myCustomSettings.put(customSettings.getClass().getName(), customSettings);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    <T extends CustomCodeStyleSettings> T getCustomSettings(@NotNull Class<T> aClass) {
        CustomCodeStyleSettings result;
        if (aClass == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(3);
        }
        String className = aClass.getName();
        Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
        synchronized (map) {
            result = this.myCustomSettings.get(className);
        }
        if (result == null) {
            result = this.createCustomSettings(className);
            if (result != null) {
                this.registerCustomSettings(result);
            } else {
                throw new RuntimeException("Unable to get or create settings of #" + aClass.getSimpleName() + " (" + className + ")");
            }
        }
        CustomCodeStyleSettings customCodeStyleSettings = result;
        if (customCodeStyleSettings == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        return (T)customCodeStyleSettings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    <T extends CustomCodeStyleSettings> T getCustomSettingsIfCreated(@NotNull Class<T> aClass) {
        if (aClass == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
        synchronized (map) {
            return (T)this.myCustomSettings.get(aClass.getName());
        }
    }

    @Nullable
    private CustomCodeStyleSettings createCustomSettings(@NotNull String customSettingsClassName) {
        if (customSettingsClassName == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        for (CustomCodeStyleSettingsFactory customCodeStyleSettingsFactory : CodeStyleSettingsService.getInstance().getCustomCodeStyleSettingsFactories()) {
            CustomCodeStyleSettings customSettings = customCodeStyleSettingsFactory.createCustomSettings(this.myRootSettings);
            if (customSettings == null || !customSettingsClassName.equals(customSettings.getClass().getName())) continue;
            return customSettings;
        }
        return null;
    }

    void registerCustomSettings(@NotNull CodeStyleSettings rootSettings, @NotNull CustomCodeStyleSettingsFactory factory) {
        CustomCodeStyleSettings customSettings;
        if (rootSettings == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        if (factory == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(8);
        }
        if ((customSettings = factory.createCustomSettings(rootSettings)) != null) {
            this.registerCustomSettings(customSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerCustomSettings(@NotNull CustomCodeStyleSettings customSettings) {
        if (customSettings == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(9);
        }
        for (String tagName : customSettings.getKnownTagNames()) {
            if (!this.myUnknownCustomElements.containsKey(tagName)) continue;
            this.restoreCustomSettings(customSettings);
            return;
        }
        Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
        synchronized (map) {
            this.myCustomSettings.put(customSettings.getClass().getName(), customSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreCustomSettings(@NotNull CustomCodeStyleSettings customSettings) {
        if (customSettings == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(10);
        }
        Element tempElement = new Element("temp");
        for (String tagName : customSettings.getKnownTagNames()) {
            Element unknown = this.myUnknownCustomElements.get(tagName);
            if (unknown == null) continue;
            tempElement.addContent(unknown.clone());
        }
        customSettings.readExternal(tempElement);
        Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
        synchronized (map) {
            this.myCustomSettings.put(customSettings.getClass().getName(), customSettings);
            customSettings.getKnownTagNames().forEach(this.myUnknownCustomElements::remove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCustomSettings(@NotNull CustomCodeStyleSettingsFactory factory) {
        CustomCodeStyleSettings defaultSettings;
        if (factory == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(11);
        }
        if ((defaultSettings = factory.createCustomSettings(CodeStyleSettings.getDefaults())) != null) {
            Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
            synchronized (map) {
                CustomCodeStyleSettings customSettings = this.myCustomSettings.get(defaultSettings.getClass().getName());
                if (customSettings != null) {
                    Element tempElement = new Element("temp");
                    customSettings.writeExternal(tempElement, defaultSettings);
                    for (Element child : tempElement.getChildren()) {
                        this.myUnknownCustomElements.put(child.getName(), JDOMUtil.internElement((Element)child));
                    }
                    this.myCustomSettings.remove(customSettings.getClass().getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyFrom(@NotNull CodeStyleSettings source) {
        if (source == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(12);
        }
        Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
        synchronized (map) {
            Pair<Collection<CustomCodeStyleSettings>, Map<String, Element>> maps = source.getCustomCodeStyleSettingsManager().getMaps();
            this.myCustomSettings.clear();
            for (CustomCodeStyleSettings customSettings : (Collection)maps.first) {
                this.myCustomSettings.put(customSettings.getClass().getName(), customSettings.copyWith(this.myRootSettings));
            }
            for (String tagName : ((Map)maps.second).keySet()) {
                this.myUnknownCustomElements.put(tagName, JDOMUtil.internElement((Element)((Element)((Map)maps.second).get(tagName)).clone()));
            }
        }
    }

    void notifySettingsBeforeLoading() {
        JBIterable.from(this.myCustomSettings.values()).forEach(CustomCodeStyleSettings::beforeLoading);
    }

    void notifySettingsLoaded() {
        JBIterable.from(this.myCustomSettings.values()).forEach(CustomCodeStyleSettings::afterLoaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Unmodifiable Collection<CustomCodeStyleSettings> getAllSettings() {
        Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
        synchronized (map) {
            return Collections.unmodifiableCollection(this.myCustomSettings.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private Pair<Collection<CustomCodeStyleSettings>, Map<String, Element>> getMaps() {
        Map<String, CustomCodeStyleSettings> map = this.myCustomSettings;
        // MONITORENTER : map
        Pair pair = Pair.create(new ArrayList<CustomCodeStyleSettings>(this.myCustomSettings.values()), new HashMap<String, Element>(this.myUnknownCustomElements));
        // MONITOREXIT : map
        if (pair != null) return pair;
        CustomCodeStyleSettingsManager.$$$reportNull$$$0(13);
        return pair;
    }

    void readExternal(@NotNull Element element) {
        if (element == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(14);
        }
        HashSet<String> knownTags = new HashSet<String>();
        knownTags.add("codeStyleSettings");
        knownTags.add("ADDITIONAL_INDENT_OPTIONS");
        knownTags.add("option");
        for (CustomCodeStyleSettings settings : this.getAllSettings()) {
            knownTags.addAll(settings.getKnownTagNames());
            settings.readExternal(element);
        }
        for (Element child : element.getChildren()) {
            String tag = child.getName();
            if (knownTags.contains(tag)) continue;
            this.myUnknownCustomElements.put(tag, JDOMUtil.internElement((Element)child));
        }
    }

    void writeExternal(@NotNull Element element, @NotNull CodeStyleSettings defaultSettings) {
        if (element == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(15);
        }
        if (defaultSettings == null) {
            CustomCodeStyleSettingsManager.$$$reportNull$$$0(16);
        }
        ArrayList<String> tags = new ArrayList<String>();
        Element tempRoot = new Element("temp");
        Collection<CustomCodeStyleSettings> allSettings = this.getAllSettings();
        for (CustomCodeStyleSettings settings : allSettings) {
            tags.addAll(settings.getKnownTagNames());
            settings.writeExternal(tempRoot, (CustomCodeStyleSettings)defaultSettings.getCustomSettings(settings.getClass()));
        }
        tags.addAll(this.myUnknownCustomElements.keySet());
        Collections.sort(tags);
        for (String tag : tags) {
            Element child = tempRoot.getChild(tag);
            if (child != null) {
                element.addContent(child.clone());
                continue;
            }
            if (!this.myUnknownCustomElements.containsKey(tag)) continue;
            element.addContent(this.myUnknownCustomElements.get(tag).clone());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootSettings";
                break;
            }
            case 2: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/CustomCodeStyleSettingsManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSettingsClassName";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "customSettings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/CustomCodeStyleSettingsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getMaps";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addCustomSettings";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettings";
                break;
            }
            case 4: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomSettingsIfCreated";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createCustomSettings";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerCustomSettings";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "restoreCustomSettings";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "unregisterCustomSettings";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyFrom";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 13 -> new IllegalStateException(string);
        };
    }
}

