/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.MainConfigurationStateSplitter;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LegacyCodeStyleSettingsManager;
import com.intellij.util.messages.MessageBus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

@State(name="ProjectCodeStyleConfiguration", storages={@Storage(value="codeStyles", stateSplitter=StateSplitter.class)})
@ApiStatus.Internal
public final class ProjectCodeStyleSettingsManager
extends CodeStyleSettingsManager {
    private static final Logger LOG = Logger.getInstance(ProjectCodeStyleSettingsManager.class);
    private static final String MAIN_PROJECT_CODE_STYLE_NAME = "Project";
    private static final String PROJECT_CODE_STYLE_CONFIG_FILE_NAME = "codeStyleConfig";
    private final Project myProject;
    private volatile boolean myIsLoaded;
    private final Map<String, CodeStyleSettings> mySettingsMap;
    private final Object myStateLock;

    public ProjectCodeStyleSettingsManager(@NotNull Project project) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(0);
        }
        this(project, true);
    }

    public ProjectCodeStyleSettingsManager(@NotNull Project project, boolean loadExtensions) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(1);
        }
        this.mySettingsMap = new HashMap<String, CodeStyleSettings>();
        this.myStateLock = new Object();
        this.myProject = project;
        this.mySettingsMap.put(MAIN_PROJECT_CODE_STYLE_NAME, this.createSettings(loadExtensions));
        this.registerExtensionPointListeners((Disposable)project);
    }

    public void initializeComponent() {
        this.initProjectSettings(this.myProject);
        this.getCurrentSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProjectSettings(@NotNull Project project) {
        if (project == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(2);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            if (!this.myIsLoaded) {
                LegacyCodeStyleSettingsManager legacySettingsManager = (LegacyCodeStyleSettingsManager)project.getService(LegacyCodeStyleSettingsManager.class);
                if (legacySettingsManager != null && legacySettingsManager.getState() != null) {
                    this.loadState(legacySettingsManager.getState());
                    if (!(project.isDefault() || ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment())) {
                        this.getMainProjectCodeStyle().getModificationTracker().incModificationCount();
                        project.scheduleSave();
                    }
                    LOG.info("Imported old project code style settings.");
                } else {
                    this.initDefaults();
                    LOG.info("Initialized from default code style settings.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMainProjectCodeStyle(@Nullable CodeStyleSettings settings) {
        Object object = this.myStateLock;
        synchronized (object) {
            this.mySettingsMap.put(MAIN_PROJECT_CODE_STYLE_NAME, settings != null ? settings : this.createSettings());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public CodeStyleSettings getMainProjectCodeStyle() {
        Object object = this.myStateLock;
        // MONITORENTER : object
        CodeStyleSettings codeStyleSettings = this.mySettingsMap.get(MAIN_PROJECT_CODE_STYLE_NAME);
        // MONITOREXIT : object
        if (codeStyleSettings != null) return codeStyleSettings;
        ProjectCodeStyleSettingsManager.$$$reportNull$$$0(3);
        return codeStyleSettings;
    }

    @Override
    @NotNull
    protected MessageBus getMessageBus() {
        MessageBus messageBus = this.myProject.getMessageBus();
        if (messageBus == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(4);
        }
        return messageBus;
    }

    private void initDefaults() {
        CodeStyleSettingsManager appCodeStyleSettingsManager = CodeStyleSettingsManager.getInstance();
        if (appCodeStyleSettingsManager != null) {
            CodeStyleSettings defaultProjectSettings = appCodeStyleSettingsManager.getMainProjectCodeStyle();
            this.setMainProjectCodeStyle(defaultProjectSettings != null ? this.cloneSettings(defaultProjectSettings) : null);
            this.USE_PER_PROJECT_SETTINGS = appCodeStyleSettingsManager.USE_PER_PROJECT_SETTINGS;
            this.PREFERRED_PROJECT_CODE_STYLE = appCodeStyleSettingsManager.PREFERRED_PROJECT_CODE_STYLE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadState(@NotNull Element state) {
        if (state == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(5);
        }
        Object object = this.myStateLock;
        synchronized (object) {
            LOG.info("Loading Project code style");
            super.loadState(state);
            this.updateFromOldProjectSettings();
            for (Element subStyle : state.getChildren("code_scheme")) {
                String name = subStyle.getAttributeValue("name");
                CodeStyleSettings settings = this.createSettings();
                settings.readExternal(subStyle);
                if (MAIN_PROJECT_CODE_STYLE_NAME.equals(name)) {
                    this.setMainProjectCodeStyle(settings);
                } else {
                    this.mySettingsMap.put(name, settings);
                }
                LOG.info(name + " code style loaded");
            }
            this.myIsLoaded = true;
        }
    }

    private void updateFromOldProjectSettings() {
        CodeStyleSettings oldProjectSettings = this.PER_PROJECT_SETTINGS;
        if (oldProjectSettings != null) {
            oldProjectSettings.resetDeprecatedFields();
        }
        this.setMainProjectCodeStyle(oldProjectSettings);
        this.PER_PROJECT_SETTINGS = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element getState() {
        Object object = this.myStateLock;
        synchronized (object) {
            Element e = super.getState();
            if (e != null) {
                LOG.info("Saving Project code style");
                for (String name : this.mySettingsMap.keySet()) {
                    CodeStyleSettings settings = this.mySettingsMap.get(name);
                    Element codeStyle = new Element("code_scheme");
                    codeStyle.setAttribute("name", name);
                    settings.writeExternal(codeStyle);
                    if (codeStyle.getContent().isEmpty()) continue;
                    e.addContent(codeStyle);
                    LOG.info(name + " code style saved");
                }
            }
            return e;
        }
    }

    @Override
    protected boolean isIgnoredOnSave(@NotNull String fieldName) {
        if (fieldName == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(6);
        }
        return "PER_PROJECT_SETTINGS".equals(fieldName);
    }

    @Override
    @NotNull
    protected @Unmodifiable Collection<CodeStyleSettings> enumSettings() {
        Collection<CodeStyleSettings> collection = Collections.unmodifiableCollection(this.mySettingsMap.values());
        if (collection == null) {
            ProjectCodeStyleSettingsManager.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @Override
    @Nullable
    protected Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainProjectCodeStyle";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "enumSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initProjectSettings";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isIgnoredOnSave";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7 -> new IllegalStateException(string);
        };
    }

    static final class StateSplitter
    extends MainConfigurationStateSplitter {
        StateSplitter() {
        }

        @NotNull
        protected String getComponentStateFileName() {
            return ProjectCodeStyleSettingsManager.PROJECT_CODE_STYLE_CONFIG_FILE_NAME;
        }

        @NotNull
        protected String getSubStateTagName() {
            return "code_scheme";
        }

        @NotNull
        protected String getSubStateFileName(@NotNull Element element) {
            if (element == null) {
                StateSplitter.$$$reportNull$$$0(0);
            }
            String string = Objects.requireNonNull(element.getAttributeValue("name"));
            if (string == null) {
                StateSplitter.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$StateSplitter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/ProjectCodeStyleSettingsManager$StateSplitter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubStateFileName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubStateFileName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

