/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.schemeManager;

import com.intellij.configurationStore.StorageManagerFileWriteRequestor;
import com.intellij.configurationStore.StorageUtilKt;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xml.dom.StaxFactory;
import java.io.IOException;
import java.nio.file.Path;
import javax.xml.stream.XMLStreamReader;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.codehaus.stax2.XMLStreamReader2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001ae\u0010\u0000\u001a\u0004\u0018\u0001H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052:\u0010\u0006\u001a6\u0012\u0015\u0012\u0013\u0018\u00010\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u0001H\u00010\u0007H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u000bH\u0002\u001a$\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0005H\u0000\u001a\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0018"}, d2={"lazyPreloadScheme", "T", "bytes", "", "isOldSchemeNaming", "", "consumer", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "Ljavax/xml/stream/XMLStreamReader;", "parser", "([BZLkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "readSchemeNameFromXml", "getOrCreateChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "requestor", "Lcom/intellij/configurationStore/StorageManagerFileWriteRequestor;", "fileName", "directory", "createDir", "ioDir", "Ljava/nio/file/Path;", "intellij.platform.configurationStore.impl"})
public final class SchemeLoaderKt {
    @Nullable
    public static final <T> T lazyPreloadScheme(@NotNull byte[] bytes, boolean isOldSchemeNaming, @NotNull Function2<? super String, ? super XMLStreamReader, ? extends T> consumer) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        boolean $i$f$lazyPreloadScheme = false;
        XMLStreamReader2 reader = StaxFactory.createXmlStreamReader((byte[])bytes);
        return (T)consumer.invoke((Object)SchemeLoaderKt.readSchemeNameFromXml(isOldSchemeNaming, (XMLStreamReader)reader), (Object)reader);
    }

    private static final String readSchemeNameFromXml(boolean isOldSchemeNaming, XMLStreamReader parser) {
        Ref.IntRef eventType = new Ref.IntRef();
        eventType.element = parser.getEventType();
        do {
            if (!(eventType.element != 1 || isOldSchemeNaming && Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"component"))) {
                if (Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"profile") || isOldSchemeNaming && Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"copyright")) {
                    return SchemeLoaderKt.readSchemeNameFromXml$findName(eventType, parser);
                }
                if (Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"inspections")) {
                    String string = parser.getAttributeValue(null, "profile_name");
                    if (string == null) {
                        string = SchemeLoaderKt.readSchemeNameFromXml$findName(eventType, parser);
                    }
                    return string;
                }
                if (Intrinsics.areEqual((Object)parser.getLocalName(), (Object)"configuration")) {
                    return parser.getAttributeValue(null, "name");
                }
                return null;
            }
            eventType.element = parser.next();
        } while (eventType.element != 8);
        return null;
    }

    @NotNull
    public static final VirtualFile getOrCreateChild(@NotNull VirtualFile $this$getOrCreateChild, @NotNull StorageManagerFileWriteRequestor requestor, @NotNull String fileName, boolean directory) {
        Intrinsics.checkNotNullParameter((Object)$this$getOrCreateChild, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        VirtualFile virtualFile = $this$getOrCreateChild.findChild(fileName);
        if (virtualFile == null) {
            Object object = StorageUtilKt.runAsWriteActionIfNeeded(() -> SchemeLoaderKt.getOrCreateChild$lambda$0(directory, $this$getOrCreateChild, requestor, fileName));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runAsWriteActionIfNeeded(...)");
            virtualFile = (VirtualFile)object;
        }
        return virtualFile;
    }

    @NotNull
    public static final VirtualFile createDir(@NotNull Path ioDir, @NotNull StorageManagerFileWriteRequestor requestor) {
        Path parentFile;
        Intrinsics.checkNotNullParameter((Object)ioDir, (String)"ioDir");
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        NioFiles.createDirectories((Path)ioDir);
        Path path = parentFile = ioDir.getParent();
        VirtualFile virtualFile = path == null ? null : VfsUtil.createDirectoryIfMissing((String)PathsKt.getInvariantSeparatorsPathString((Path)path));
        if (virtualFile == null) {
            Object[] objectArray = new Object[]{parentFile};
            throw new IOException(ProjectBundle.message((String)"project.configuration.save.file.not.found", (Object[])objectArray));
        }
        VirtualFile parentVirtualFile = virtualFile;
        return SchemeLoaderKt.getOrCreateChild(parentVirtualFile, requestor, ((Object)ioDir.getFileName()).toString(), true);
    }

    private static final String readSchemeNameFromXml$findName(Ref.IntRef eventType, XMLStreamReader $parser) {
        eventType.element = $parser.next();
        while (eventType.element != 8) {
            if (eventType.element == 1 && Intrinsics.areEqual((Object)$parser.getLocalName(), (Object)"option") && Intrinsics.areEqual((Object)$parser.getAttributeValue(null, "name"), (Object)"myName")) {
                return $parser.getAttributeValue(null, "value");
            }
            eventType.element = $parser.next();
        }
        return null;
    }

    private static final VirtualFile getOrCreateChild$lambda$0(boolean $directory, VirtualFile $this_getOrCreateChild, StorageManagerFileWriteRequestor $requestor, String $fileName) {
        return $directory ? $this_getOrCreateChild.createChildDirectory((Object)$requestor, $fileName) : $this_getOrCreateChild.createChildData((Object)$requestor, $fileName);
    }
}

