/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.ComponentStorageUtil;
import com.intellij.util.LineSeparator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a>\u0010\u0000\u001a&\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00050\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u00a8\u0006\n"}, d2={"loadComponentsAndDetectLineSeparator", "Lkotlin/Pair;", "", "", "Lorg/jdom/Element;", "Lcom/intellij/util/LineSeparator;", "dir", "Ljava/nio/file/Path;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "intellij.platform.configurationStore.impl"})
public final class DirectoryBasedStorageKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<Map<String, Element>, Map<String, LineSeparator>> loadComponentsAndDetectLineSeparator(Path dir, PathMacroSubstitutor pathMacroSubstitutor) {
        try {
            Closeable closeable = Files.newDirectoryStream(dir);
            Throwable throwable = null;
            try {
                DirectoryStream files = (DirectoryStream)closeable;
                boolean bl = false;
                HashMap<String, Element> fileToState = new HashMap<String, Element>();
                HashMap<String, LineSeparator> fileToSeparator = new HashMap<String, LineSeparator>();
                Iterator iterator = files.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                Iterator iterator2 = iterator;
                while (iterator2.hasNext()) {
                    Path file = (Path)iterator2.next();
                    if (!StringsKt.endsWith((String)((Object)file).toString(), (String)".xml", (boolean)true)) continue;
                    try {
                        Element state;
                        Intrinsics.checkNotNull((Object)file);
                        Pair<Element, LineSeparator> pair = FileBasedStorageKt.loadDataAndDetectLineSeparator(file);
                        Element element = (Element)pair.component1();
                        LineSeparator separator = (LineSeparator)pair.component2();
                        if (ComponentStorageUtil.getComponentNameIfValid((Element)element) == null) continue;
                        if (!Intrinsics.areEqual((Object)element.getName(), (Object)"component")) {
                            ComponentStoreImplKt.LOG.error("Incorrect root tag name (" + element.getName() + ") in " + file);
                            continue;
                        }
                        List elementChildren = element.getChildren();
                        if (elementChildren.isEmpty()) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)((Element)elementChildren.get(0)).detach(), (String)"detach(...)");
                        if (state.isEmpty()) continue;
                        if (pathMacroSubstitutor != null) {
                            pathMacroSubstitutor.expandPaths(state);
                            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                                String componentName;
                                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(componentName, (Collection)PathMacrosCollector.Companion.getMacroNames(state));
                            }
                        }
                        String name = ((Object)file.getFileName()).toString();
                        fileToState.put(name, state);
                        if (separator == null || separator == LineSeparator.getSystemLineSeparator()) continue;
                        fileToSeparator.put(name, separator);
                    }
                    catch (Throwable e) {
                        String string = e.getMessage();
                        Intrinsics.checkNotNull((Object)string);
                        if (StringsKt.startsWith$default((String)string, (String)"Unexpected End-of-input in prolog", (boolean)false, (int)2, null)) {
                            ComponentStoreImplKt.LOG.warn("Ignore empty file " + file);
                            continue;
                        }
                        ComponentStoreImplKt.LOG.warn("Unable to load state from " + file, e);
                    }
                }
                Pair pair = new Pair(fileToState, fileToSeparator);
                return pair;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (DirectoryIteratorException e) {
            IOException iOException = e.getCause();
            Intrinsics.checkNotNull((Object)iOException);
            throw iOException;
        }
        catch (NoSuchFileException noSuchFileException) {
            return new Pair(Map.of(), Map.of());
        }
        catch (NotDirectoryException notDirectoryException) {
            return new Pair(Map.of(), Map.of());
        }
    }

    public static final /* synthetic */ Pair access$loadComponentsAndDetectLineSeparator(Path dir, PathMacroSubstitutor pathMacroSubstitutor) {
        return DirectoryBasedStorageKt.loadComponentsAndDetectLineSeparator(dir, pathMacroSubstitutor);
    }
}

