/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.CommonBundle;
import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ConfigBackup;
import com.intellij.openapi.application.CustomConfigMigrationOption;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.platform.backend.workspace.GlobalWorkspaceModelCache;
import java.nio.file.Path;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/configurationStore/RestoreDefaultSettingsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "confirmRestoreSettings", "", "backupPath", "Ljava/nio/file/Path;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.configurationStore.impl"})
final class RestoreDefaultSettingsAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Path path = PathManager.getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        if (!this.confirmRestoreSettings(e, ConfigBackup.Companion.getNextBackupPath$default((ConfigBackup.Companion)ConfigBackup.Companion, (Path)path, null, (int)2, null))) {
            return;
        }
        CustomConfigMigrationOption.writeConfigMarkerFile$default((CustomConfigMigrationOption)((CustomConfigMigrationOption)CustomConfigMigrationOption.StartWithCleanConfig.INSTANCE), null, (int)1, null);
        GlobalWorkspaceModelCache globalWorkspaceModelCache = GlobalWorkspaceModelCache.Companion.getInstance();
        if (globalWorkspaceModelCache != null) {
            globalWorkspaceModelCache.invalidateCaches();
        }
        ActionsKt.invokeLater$default(null, RestoreDefaultSettingsAction::actionPerformed$lambda$0, (int)1, null);
    }

    private final boolean confirmRestoreSettings(AnActionEvent e, Path backupPath) {
        Object[] objectArray = ApplicationManager.getApplication().isRestartCapable() ? ConfigurationStoreBundle.message("restore.default.settings.confirmation.button.restart", new Object[0]) : ConfigurationStoreBundle.message("restore.default.settings.confirmation.button.shutdown", new Object[0]);
        Intrinsics.checkNotNull((Object)objectArray);
        Object[] restartButtonText = objectArray;
        objectArray = new Object[]{backupPath};
        return Messages.showYesNoDialog((Project)e.getProject(), (String)ConfigurationStoreBundle.message("restore.default.settings.confirmation.message", objectArray), (String)ConfigurationStoreBundle.message("restore.default.settings.confirmation.title", new Object[0]), (String)restartButtonText, (String)CommonBundle.getCancelButtonText(), (Icon)Messages.getWarningIcon()) == 0;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final Unit actionPerformed$lambda$0() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.openapi.application.ex.ApplicationEx");
        ((ApplicationEx)application).restart(true);
        return Unit.INSTANCE;
    }
}

