/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.fasterxml.aalto.UncheckedStreamException;
import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataStateChanged;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.configurationStore.SaveSession;
import com.intellij.configurationStore.SaveSessionProducer;
import com.intellij.configurationStore.SaveSessionProducerBase;
import com.intellij.configurationStore.StateGetter;
import com.intellij.configurationStore.StateGetterImpl;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StringDataWriter;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl;
import com.intellij.configurationStore.XmlDataWriter;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.impl.stores.ComponentStorageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.SafeStAXStreamBuilderKt;
import com.intellij.openapi.vfs.LargeFileWriteRequestor;
import com.intellij.openapi.vfs.SafeWriteRequestor;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.settings.SettingsController;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.xml.dom.StaxFactory;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0007\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001LB;\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H$J*\u0010\u0017\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u00022\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u000fJQ\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u001f0\u001e\"\b\b\u0000\u0010\u001f*\u00020\u001a2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\u001f0 2\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001f0$2\u0006\u0010%\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b&J\b\u0010'\u001a\u00020\u0002H\u0004J\n\u0010(\u001a\u0004\u0018\u00010\u0016H\u0002J\u001a\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.H\u0014J\u0010\u0010/\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0016H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00162\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u0004\u0018\u000105J\u0010\u00106\u001a\u0002052\u0006\u00107\u001a\u00020\u0002H$J\u001e\u00108\u001a\u00020*2\u000e\u00109\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u00040:H\u0086@\u00a2\u0006\u0002\u0010;J\u001a\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020\u00022\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u0002J\u0010\u0010?\u001a\u00020*2\u0006\u00100\u001a\u00020\u0016H\u0014J*\u0010@\u001a\u00020*2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020\u00160B2\u0012\u0010C\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040DH\u0014J\u001c\u0010E\u001a\u00020*2\f\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040:2\u0006\u0010G\u001a\u00020\u000fJ\u001e\u0010H\u001a\b\u0012\u0004\u0012\u00020\u00040I2\u0006\u0010J\u001a\u00020\u00022\u0006\u0010K\u001a\u00020\u0002H\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006M"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "fileSpec", "", "rootElementName", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/PathMacroSubstitutor;", "storageRoamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "saveStorageDataOnReload", "", "getSaveStorageDataOnReload", "()Z", "roamingType", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "loadLocalData", "Lorg/jdom/Element;", "getSerializedState", "storageData", "component", "", "componentName", "archive", "createGetSession", "Lcom/intellij/configurationStore/StateGetter;", "S", "Lcom/intellij/openapi/components/PersistentStateComponent;", "pluginId", "Lcom/intellij/openapi/extensions/PluginId;", "stateClass", "Ljava/lang/Class;", "reload", "createGetSession$intellij_platform_configurationStore_impl", "loadData", "loadElement", "providerDataStateChanged", "", "writer", "Lcom/intellij/configurationStore/DataWriter;", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "loadState", "element", "loadFromStreamProvider", "stream", "Ljava/io/InputStream;", "createSaveSessionProducer", "Lcom/intellij/configurationStore/SaveSessionProducer;", "createSaveSession", "states", "analyzeExternalChangesAndUpdateIfNeeded", "componentNames", "", "(Ljava/util/Set;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setStates", "oldStorageData", "newStorageData", "beforeElementLoaded", "beforeElementSaved", "elements", "", "rootAttributes", "", "updatedFromStreamProvider", "changedComponentNames", "deleted", "getChangedComponentNames", "", "oldStateMap", "newStateMap", "XmlElementStorageSaveSessionProducer", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nXmlElementStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlElementStorage.kt\ncom/intellij/configurationStore/XmlElementStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,518:1\n1#2:519\n60#3,5:520\n60#3,5:525\n60#3,5:530\n*S KotlinDebug\n*F\n+ 1 XmlElementStorage.kt\ncom/intellij/configurationStore/XmlElementStorage\n*L\n142#1:520,5\n147#1:525,5\n149#1:530,5\n*E\n"})
public abstract class XmlElementStorage
extends StateStorageBase<StateMap> {
    @JvmField
    @NotNull
    public final String fileSpec;
    @JvmField
    @Nullable
    protected final String rootElementName;
    @Nullable
    private final PathMacroSubstitutor pathMacroSubstitutor;
    @Nullable
    private final StreamProvider provider;
    @NotNull
    private final RoamingType roamingType;

    protected XmlElementStorage(@NotNull String fileSpec, @Nullable String rootElementName, @Nullable PathMacroSubstitutor pathMacroSubstitutor, @NotNull RoamingType storageRoamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkNotNullParameter((Object)storageRoamingType, (String)"storageRoamingType");
        this.fileSpec = fileSpec;
        this.rootElementName = rootElementName;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        this.provider = provider;
        this.roamingType = ComponentInfoKt.getEffectiveRoamingType(storageRoamingType, this.fileSpec);
    }

    public /* synthetic */ XmlElementStorage(String string, String string2, PathMacroSubstitutor pathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            pathMacroSubstitutor = null;
        }
        if ((n & 0x10) != 0) {
            streamProvider = null;
        }
        this(string, string2, pathMacroSubstitutor, roamingType, streamProvider);
    }

    @Override
    protected final boolean getSaveStorageDataOnReload() {
        return this.provider == null || this.provider.getSaveStorageDataOnReload();
    }

    @Override
    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    protected abstract Element loadLocalData();

    @Override
    @Nullable
    public final Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkNotNullParameter((Object)storageData, (String)"storageData");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        return storageData.getState(componentName, archive);
    }

    @NotNull
    public final <S> StateGetter<S> createGetSession$intellij_platform_configurationStore_impl(@NotNull PersistentStateComponent<S> component, @NotNull String componentName, @NotNull PluginId pluginId, @NotNull Class<S> stateClass, boolean reload2) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)pluginId, (String)"pluginId");
        Intrinsics.checkNotNullParameter(stateClass, (String)"stateClass");
        return new StateGetterImpl<S>(component, componentName, pluginId, (StateMap)this.getStorageData(reload2), stateClass, this);
    }

    @Override
    @NotNull
    protected final StateMap loadData() {
        Object object;
        block3: {
            block2: {
                object = this.loadElement();
                if (object == null) break block2;
                Element it = object;
                boolean bl = false;
                StateMap stateMap = this.loadState(it);
                object = stateMap;
                if (stateMap != null) break block3;
            }
            object = StateMap.EMPTY;
        }
        return object;
    }

    private final Element loadElement() {
        Ref.ObjectRef element = new Ref.ObjectRef();
        try {
            boolean isLoadLocalData = false;
            if (this.provider == null) {
                isLoadLocalData = true;
            } else {
                boolean bl = isLoadLocalData = !this.provider.read(this.fileSpec, this.roamingType, arg_0 -> XmlElementStorage.loadElement$lambda$0(element, this, arg_0));
            }
            if (isLoadLocalData) {
                element.element = this.loadLocalData();
            }
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (Throwable e) {
            ComponentStoreImplKt.LOG.error("Cannot load data for " + this.fileSpec, e);
        }
        return (Element)element.element;
    }

    protected void providerDataStateChanged(@Nullable DataWriter writer, @NotNull DataStateChanged type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
    }

    private final StateMap loadState(Element element) {
        this.beforeElementLoaded(element);
        return StateMap.Companion.fromMap(ComponentStorageUtil.loadComponents((Element)element, (PathMacroSubstitutor)this.pathMacroSubstitutor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element loadFromStreamProvider(@NotNull InputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        try (XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader$default((InputStream)stream, null, (int)2, null);){
            Element element = SafeStAXStreamBuilderKt.buildNsUnawareJdomAndClose((XMLStreamReader2)xmlStreamReader);
            return element;
        }
        catch (XMLStreamException e) {
            throw new JDOMException(e.getMessage(), (Throwable)e);
        }
        catch (UncheckedStreamException e) {
            throw new JDOMException(e.getMessage(), (Throwable)e);
        }
    }

    @Nullable
    public final SaveSessionProducer createSaveSessionProducer() {
        return this.checkIsSavingDisabled() ? null : this.createSaveSession((StateMap)this.getStorageData());
    }

    @NotNull
    protected abstract SaveSessionProducer createSaveSession(@NotNull StateMap var1);

    @Nullable
    public final Object analyzeExternalChangesAndUpdateIfNeeded(@NotNull Set<? super String> componentNames, @NotNull Continuation<? super Unit> $completion) {
        ComponentStoreImplKt.LOG.debug("Running analyzeExternalChangesAndUpdateIfNeeded");
        StateMap oldData = (StateMap)this.storageDataRef.get();
        StateMap newData = (StateMap)this.getStorageData(true);
        if (oldData == null) {
            Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("analyzeExternalChangesAndUpdateIfNeeded: old data null, load new for " + this, e$iv);
            }
            Boxing.boxBoolean((boolean)CollectionsKt.addAll((Collection)componentNames, (Object[])newData.keys()));
        } else {
            Logger logger;
            Set<String> changedComponentNames = this.getChangedComponentNames(oldData, newData);
            Logger $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Changed components: " + changedComponentNames, e$iv);
            }
            if (!((Collection)changedComponentNames).isEmpty()) {
                $this$debug_u24default$iv = ComponentStoreImplKt.LOG;
                e$iv = null;
                $i$f$debug = false;
                if ($this$debug_u24default$iv.isDebugEnabled()) {
                    logger = $this$debug_u24default$iv;
                    boolean bl = false;
                    logger.debug("analyzeExternalChangesAndUpdateIfNeeded: changedComponentNames " + changedComponentNames + " for " + this, e$iv);
                }
                componentNames.addAll((Collection<? super String>)changedComponentNames);
            }
        }
        return Unit.INSTANCE;
    }

    private final void setStates(StateMap oldStorageData, StateMap newStorageData) {
        if (oldStorageData != newStorageData && this.storageDataRef.getAndSet(newStorageData) != oldStorageData) {
            ComponentStoreImplKt.LOG.warn("Old storage data is not equal to current, new storage data was set anyway");
        }
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
    }

    protected void beforeElementSaved(@NotNull List<Element> elements, @NotNull Map<String, String> rootAttributes) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter(rootAttributes, (String)"rootAttributes");
    }

    public final void updatedFromStreamProvider(@NotNull Set<String> changedComponentNames, boolean deleted) {
        Intrinsics.checkNotNullParameter(changedComponentNames, (String)"changedComponentNames");
        Element newElement = deleted ? null : this.loadElement();
        StateMap states = (StateMap)this.storageDataRef.get();
        if (newElement == null) {
            if (states != null) {
                CollectionsKt.addAll((Collection)changedComponentNames, (Object[])states.keys());
                this.setStates(states, StateMap.EMPTY);
            }
        } else if (states != null) {
            StateMap newStates = this.loadState(newElement);
            changedComponentNames.addAll((Collection<String>)this.getChangedComponentNames(states, newStates));
            this.setStates(states, newStates);
        }
    }

    private final Set<String> getChangedComponentNames(StateMap oldStateMap, StateMap newStateMap) {
        Object[] newKeys = newStateMap.keys();
        Object[] existingKeys = oldStateMap.keys();
        ArrayList<String> bothStates = new ArrayList<String>(Math.min(newKeys.length, existingKeys.length));
        Collection existingKeysSet = existingKeys.length < 3 ? (Collection)ArraysKt.asList((Object[])existingKeys) : (Collection)new ObjectOpenHashSet(existingKeys);
        int n = newKeys.length;
        for (int i = 0; i < n; ++i) {
            String newKey = newKeys[i];
            if (!existingKeysSet.contains(newKey)) continue;
            bothStates.add(newKey);
        }
        HashSet diffs = new HashSet(newKeys.length + existingKeys.length);
        CollectionsKt.addAll((Collection)diffs, (Object[])newKeys);
        CollectionsKt.addAll((Collection)diffs, (Object[])existingKeys);
        Iterator iterator = bothStates.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String state = (String)iterator2.next();
            diffs.remove(state);
        }
        Iterator iterator3 = bothStates.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator3, (String)"iterator(...)");
        iterator2 = iterator3;
        while (iterator2.hasNext()) {
            String componentName = (String)iterator2.next();
            oldStateMap.compare(componentName, newStateMap, diffs);
        }
        return diffs;
    }

    private static final Unit loadElement$lambda$0(Ref.ObjectRef $element, XmlElementStorage this$0, InputStream inputStream) {
        block0: {
            InputStream inputStream2 = inputStream;
            if (inputStream2 == null) break block0;
            InputStream it = inputStream2;
            boolean bl = false;
            $element.element = this$0.loadFromStreamProvider(inputStream);
            this$0.providerDataStateChanged(new StringDataWriter((Ref.ObjectRef<Element>)$element){
                final /* synthetic */ Ref.ObjectRef<Element> $element;
                {
                    this.$element = $element;
                }

                public boolean hasData(DataWriterFilter filter2) {
                    Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                    Object object = this.$element.element;
                    Intrinsics.checkNotNull((Object)object);
                    return filter2.hasData((Element)object);
                }

                public void writeTo$intellij_platform_configurationStore_impl(Writer writer, String lineSeparator, DataWriterFilter filter2) {
                    Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                    Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
                    DataWriterFilter dataWriterFilter = filter2;
                    JbXmlOutputter jbXmlOutputter = new JbXmlOutputter(lineSeparator, (JDOMUtil.ElementOutputFilter)(dataWriterFilter != null ? dataWriterFilter.toElementFilter() : null), null, null, false, this.toString(), 28, null);
                    Object object = this.$element.element;
                    Intrinsics.checkNotNull((Object)object);
                    jbXmlOutputter.output((Element)object, writer);
                }
            }, DataStateChanged.LOADED);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001*B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bJ,\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u001fH\u0002J\u001a\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\f2\b\u0010#\u001a\u0004\u0018\u00010\u000fH\u0016J\u0018\u0010$\u001a\u00020!2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u001dH$J \u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u000e\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u001dH$R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00028\u00008\u0004X\u0085\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006+"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSessionProducer;", "T", "Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/SaveSessionProducerBase;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "storage", "<init>", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/XmlElementStorage;)V", "Lcom/intellij/configurationStore/XmlElementStorage;", "copiedStates", "", "", "", "newLiveStates", "Lorg/jdom/Element;", "controller", "Lcom/intellij/platform/settings/SettingsController;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "isSaveAllowed", "", "createSaveSession", "Lcom/intellij/configurationStore/SaveSession;", "save", "", "states", "", "setSerializedState", "", "componentName", "element", "remove", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "saveLocally", "dataWriter", "Lcom/intellij/configurationStore/DataWriter;", "XmlSaveSession", "intellij.platform.configurationStore.impl"})
    @SourceDebugExtension(value={"SMAP\nXmlElementStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlElementStorage.kt\ncom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSessionProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,518:1\n1#2:519\n*E\n"})
    public static abstract class XmlElementStorageSaveSessionProducer<T extends XmlElementStorage>
    extends SaveSessionProducerBase {
        @NotNull
        private final StateMap originalStates;
        @JvmField
        @NotNull
        protected final T storage;
        @Nullable
        private Map<String, Object> copiedStates;
        @Nullable
        private Map<String, Element> newLiveStates;

        public XmlElementStorageSaveSessionProducer(@NotNull StateMap originalStates, @NotNull T storage) {
            Intrinsics.checkNotNullParameter((Object)originalStates, (String)"originalStates");
            Intrinsics.checkNotNullParameter(storage, (String)"storage");
            this.originalStates = originalStates;
            this.storage = storage;
            this.newLiveStates = new HashMap();
        }

        @Override
        @Nullable
        public SettingsController getController() {
            return ((StateStorageBase)this.storage).getController();
        }

        @Override
        @Nullable
        public RoamingType getRoamingType() {
            return ((XmlElementStorage)this.storage).getRoamingType();
        }

        protected boolean isSaveAllowed() {
            return !((StateStorageBase)this.storage).checkIsSavingDisabled();
        }

        @Nullable
        public final SaveSession createSaveSession() {
            XmlDataWriter xmlDataWriter;
            if (this.copiedStates == null || !this.isSaveAllowed()) {
                return null;
            }
            Map<String, Object> map2 = this.copiedStates;
            Intrinsics.checkNotNull(map2);
            StateMap stateMap = StateMap.Companion.fromMap(map2);
            Map<String, Element> map3 = this.newLiveStates;
            if (map3 == null) {
                throw new IllegalStateException("createSaveSession was already called");
            }
            List<Element> elements = this.save(stateMap, map3);
            this.newLiveStates = null;
            if (elements == null) {
                xmlDataWriter = null;
            } else {
                PathMacroManager pathMacroManager;
                LinkedHashMap rootAttributes = new LinkedHashMap();
                ((XmlElementStorage)this.storage).beforeElementSaved(elements, rootAttributes);
                String string = ((XmlElementStorage)this.storage).rootElementName;
                Map map4 = rootAttributes;
                if (((XmlElementStorage)this.storage).pathMacroSubstitutor == null) {
                    pathMacroManager = null;
                } else {
                    PathMacroSubstitutor pathMacroSubstitutor = ((XmlElementStorage)this.storage).pathMacroSubstitutor;
                    Intrinsics.checkNotNull((Object)pathMacroSubstitutor, (String)"null cannot be cast to non-null type com.intellij.configurationStore.TrackingPathMacroSubstitutorImpl");
                    pathMacroManager = ((TrackingPathMacroSubstitutorImpl)pathMacroSubstitutor).getMacroManager$intellij_platform_configurationStore_impl();
                }
                xmlDataWriter = new XmlDataWriter(string, elements, map4, pathMacroManager, this.storage.toString());
            }
            XmlDataWriter writer = xmlDataWriter;
            return new XmlSaveSession(elements, writer, stateMap);
        }

        private final List<Element> save(StateMap states, Map<String, ? extends Element> newLiveStates) {
            if (states.isEmpty()) {
                return null;
            }
            List result = null;
            for (String componentName : states.keys()) {
                Element element = null;
                try {
                    Element element2 = states.getElement(componentName, newLiveStates);
                    if (element2 == null || (element2 = element2.clone()) == null) continue;
                    element = element2;
                }
                catch (Exception e) {
                    ComponentStoreImplKt.LOG.error("Cannot save \"" + componentName + "\" data", (Throwable)e);
                    continue;
                }
                List elementAttributes = element.getAttributes();
                Attribute nameAttribute = element.getAttribute("name");
                if (nameAttribute == null || nameAttribute != elementAttributes.get(0) || !Intrinsics.areEqual((Object)componentName, (Object)nameAttribute.getValue())) {
                    if (nameAttribute == null) {
                        nameAttribute = new Attribute("name", componentName);
                        elementAttributes.add(0, nameAttribute);
                    } else {
                        nameAttribute.setValue(componentName);
                        if (!Intrinsics.areEqual(elementAttributes.get(0), (Object)nameAttribute)) {
                            elementAttributes.remove(nameAttribute);
                            elementAttributes.add(0, nameAttribute);
                        }
                    }
                }
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.add(element);
            }
            return result;
        }

        @Override
        public void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            Element normalized;
            Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
            Map<String, Element> map2 = this.newLiveStates;
            if (map2 == null) {
                throw new IllegalStateException("createSaveSession was already called");
            }
            Map<String, Element> newLiveStates = map2;
            Element element2 = element;
            if (element2 != null) {
                Element it = element2;
                boolean bl = false;
                v2 = XmlElementStorageKt.access$normalizeRootName(it);
            } else {
                v2 = normalized = null;
            }
            if (this.copiedStates == null) {
                this.copiedStates = StateMapKt.setStateAndCloneIfNeeded(componentName, normalized, this.originalStates, newLiveStates);
            } else {
                Map<String, Object> map3 = this.copiedStates;
                Intrinsics.checkNotNull(map3);
                StateMapKt.updateState(map3, componentName, normalized, newLiveStates);
            }
        }

        protected abstract void remove(@Nullable List<VFileEvent> var1);

        protected abstract void saveLocally(@NotNull DataWriter var1, @Nullable List<VFileEvent> var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B)\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001e\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0005H\u0096@\u00a2\u0006\u0002\u0010\u0011R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSessionProducer$XmlSaveSession;", "Lcom/intellij/configurationStore/SaveSession;", "Lcom/intellij/openapi/vfs/SafeWriteRequestor;", "Lcom/intellij/openapi/vfs/LargeFileWriteRequestor;", "elements", "", "Lorg/jdom/Element;", "writer", "Lcom/intellij/configurationStore/DataWriter;", "stateMap", "Lcom/intellij/configurationStore/StateMap;", "<init>", "(Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSessionProducer;Ljava/util/List;Lcom/intellij/configurationStore/DataWriter;Lcom/intellij/configurationStore/StateMap;)V", "save", "", "events", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
        private final class XmlSaveSession
        implements SaveSession,
        SafeWriteRequestor,
        LargeFileWriteRequestor {
            @Nullable
            private final List<Element> elements;
            @Nullable
            private final DataWriter writer;
            @NotNull
            private final StateMap stateMap;

            public XmlSaveSession(@Nullable List<Element> elements, @NotNull DataWriter writer, StateMap stateMap) {
                Intrinsics.checkNotNullParameter((Object)stateMap, (String)"stateMap");
                this.elements = elements;
                this.writer = writer;
                this.stateMap = stateMap;
            }

            @Nullable
            public Object save(@Nullable List<VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
                boolean isSavedLocally = false;
                StreamProvider provider = ((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).provider;
                if (this.elements == null) {
                    if (provider == null || !provider.delete(((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).fileSpec, ((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).getRoamingType())) {
                        isSavedLocally = true;
                        if (this.writer == null) {
                            XmlElementStorageSaveSessionProducer.this.remove(events);
                        } else {
                            XmlElementStorageSaveSessionProducer.this.saveLocally(this.writer, events);
                        }
                    }
                } else if (provider != null && provider.isApplicable(((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).fileSpec, ((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).getRoamingType())) {
                    String string = ((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).fileSpec;
                    DataWriter dataWriter = this.writer;
                    Intrinsics.checkNotNull((Object)dataWriter);
                    byte[] byArray = dataWriter.toBufferExposingByteArray(LineSeparator.LF).toByteArray();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
                    provider.write(string, byArray, ((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).getRoamingType());
                } else {
                    isSavedLocally = true;
                    if (this.writer == null) {
                        XmlElementStorageSaveSessionProducer.this.remove(events);
                    } else {
                        XmlElementStorageSaveSessionProducer.this.saveLocally(this.writer, events);
                    }
                }
                if (!isSavedLocally) {
                    ((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).providerDataStateChanged(this.writer, DataStateChanged.SAVED);
                }
                ((XmlElementStorage)XmlElementStorageSaveSessionProducer.this.storage).setStates(XmlElementStorageSaveSessionProducer.this.originalStates, this.stateMap);
                return Unit.INSTANCE;
            }
        }
    }
}

