/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.ComponentStoreWithExtraComponents;
import com.intellij.configurationStore.CompoundStreamProvider;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.DataWriterFilter;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.StateLoadPolicy;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StringDataWriter;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImplKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.components.impl.stores.IComponentStoreKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.settings.SettingsController;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020!H\u0014J\b\u0010\"\u001a\u0004\u0018\u00010#J\b\u0010$\u001a\u00020%H\u0014J6\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'\"\b\b\u0000\u0010)*\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H)0,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0014J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u00198TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00068"}, d2={"Lcom/intellij/configurationStore/DefaultProjectStoreImpl;", "Lcom/intellij/configurationStore/ComponentStoreWithExtraComponents;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "compoundStreamProvider", "Lcom/intellij/configurationStore/CompoundStreamProvider;", "allowSavingWithoutModifications", "", "getAllowSavingWithoutModifications", "()Z", "loadPolicy", "Lcom/intellij/configurationStore/StateLoadPolicy;", "getLoadPolicy", "()Lcom/intellij/configurationStore/StateLoadPolicy;", "storage", "Lcom/intellij/configurationStore/DefaultProjectStoreImpl$DefaultProjectStorage;", "getStorage", "()Lcom/intellij/configurationStore/DefaultProjectStoreImpl$DefaultProjectStorage;", "storage$delegate", "Lkotlin/Lazy;", "serviceContainer", "Lcom/intellij/openapi/components/ComponentManagerEx;", "getServiceContainer", "()Lcom/intellij/openapi/components/ComponentManagerEx;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "getStorageManager", "()Lcom/intellij/configurationStore/StateStorageManager;", "isUseLoadedStateAsExisting", "Lcom/intellij/openapi/components/StateStorage;", "getStateCopy", "Lorg/jdom/Element;", "getPathMacroManagerForDefaults", "Lcom/intellij/openapi/components/PathMacroManager;", "getStorageSpecs", "", "Lcom/intellij/configurationStore/FileStorageAnnotation;", "T", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "setPath", "", "path", "Ljava/nio/file/Path;", "toString", "", "DefaultProjectStorage", "intellij.platform.configurationStore.impl"})
public final class DefaultProjectStoreImpl
extends ComponentStoreWithExtraComponents {
    @NotNull
    private final Project project;
    @NotNull
    private final CompoundStreamProvider compoundStreamProvider;
    @NotNull
    private final Lazy storage$delegate;
    @NotNull
    private final StateStorageManager storageManager;

    public DefaultProjectStoreImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.compoundStreamProvider = new CompoundStreamProvider();
        this.storage$delegate = LazyKt.lazy(() -> DefaultProjectStoreImpl.storage_delegate$lambda$0(this));
        this.storageManager = new StateStorageManager(this){
            final /* synthetic */ DefaultProjectStoreImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public ComponentManager getComponentManager() {
                return null;
            }

            public void addStreamProvider(StreamProvider provider, boolean first) {
                Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
                DefaultProjectStoreImpl.access$getCompoundStreamProvider$p(this.this$0).addStreamProvider(provider, first);
            }

            public void removeStreamProvider(Class<? extends StreamProvider> aClass) {
                Intrinsics.checkNotNullParameter(aClass, (String)"aClass");
                DefaultProjectStoreImpl.access$getCompoundStreamProvider$p(this.this$0).removeStreamProvider(aClass);
            }

            public DefaultProjectStorage getStateStorage(Storage storageSpec) {
                Intrinsics.checkNotNullParameter((Object)storageSpec, (String)"storageSpec");
                return DefaultProjectStoreImpl.access$getStorage(this.this$0);
            }

            public Void expandMacro(String collapsedPath) {
                Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
                throw new UnsupportedOperationException();
            }

            public String collapseMacro(String path) {
                Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                throw new UnsupportedOperationException();
            }

            public StreamProvider getStreamProvider() {
                return DefaultProjectStoreImpl.access$getCompoundStreamProvider$p(this.this$0);
            }

            public DefaultProjectStorage getOldStorage(Object component, String componentName, StateStorageOperation operation) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
                Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
                return DefaultProjectStoreImpl.access$getStorage(this.this$0);
            }
        };
    }

    @Override
    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Override
    protected boolean getAllowSavingWithoutModifications() {
        return true;
    }

    @Override
    @NotNull
    public StateLoadPolicy getLoadPolicy() {
        return ApplicationManager.getApplication().isUnitTestMode() ? StateLoadPolicy.NOT_LOAD : StateLoadPolicy.LOAD;
    }

    private final DefaultProjectStorage getStorage() {
        Lazy lazy = this.storage$delegate;
        return (DefaultProjectStorage)lazy.getValue();
    }

    @Override
    @NotNull
    protected ComponentManagerEx getServiceContainer() {
        Project project = this.getProject();
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
        return (ComponentManagerEx)project;
    }

    @Override
    @NotNull
    public StateStorageManager getStorageManager() {
        return this.storageManager;
    }

    @Override
    protected boolean isUseLoadedStateAsExisting(@NotNull StateStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        return false;
    }

    @Nullable
    public final Element getStateCopy() {
        return this.getStorage().loadLocalData();
    }

    @Override
    @NotNull
    protected PathMacroManager getPathMacroManagerForDefaults() {
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        return pathMacroManager;
    }

    @NotNull
    protected <T> List<FileStorageAnnotation> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return CollectionsKt.listOf((Object)FileStorageAnnotation.PROJECT_FILE_STORAGE_ANNOTATION);
    }

    public void setPath(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
    }

    @Override
    @NotNull
    public String toString() {
        return "default project";
    }

    private static final DefaultProjectStorage storage_delegate$lambda$0(DefaultProjectStoreImpl this$0) {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        Path file = IComponentStoreKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager().expandMacro("$APP_CONFIG$/project.default.xml");
        PathMacroManager pathMacroManager = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this$0.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)pathMacroManager, (String)"getInstance(...)");
        return new DefaultProjectStorage(file, "$APP_CONFIG$/project.default.xml", pathMacroManager, this$0.compoundStreamProvider);
    }

    public static final /* synthetic */ CompoundStreamProvider access$getCompoundStreamProvider$p(DefaultProjectStoreImpl $this) {
        return $this.compoundStreamProvider;
    }

    public static final /* synthetic */ DefaultProjectStorage access$getStorage(DefaultProjectStoreImpl $this) {
        return $this.getStorage();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\u0004\u0018\u00010\u00112\u000e\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u0016\u0010\f\u001a\u0004\u0018\u00010\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/configurationStore/DefaultProjectStoreImpl$DefaultProjectStorage;", "Lcom/intellij/configurationStore/FileBasedStorage;", "file", "Ljava/nio/file/Path;", "fileSpec", "", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "streamProvider", "Lcom/intellij/configurationStore/StreamProvider;", "<init>", "(Ljava/nio/file/Path;Ljava/lang/String;Lcom/intellij/openapi/components/PathMacroManager;Lcom/intellij/configurationStore/StreamProvider;)V", "controller", "Lcom/intellij/platform/settings/SettingsController;", "getController", "()Lcom/intellij/platform/settings/SettingsController;", "loadLocalData", "Lorg/jdom/Element;", "loadFromStreamProvider", "stream", "Ljava/io/InputStream;", "postProcessLoadedData", "elementProvider", "Lkotlin/Function0;", "createSaveSession", "Lcom/intellij/configurationStore/FileBasedStorage$FileSaveSessionProducer;", "states", "Lcom/intellij/configurationStore/StateMap;", "intellij.platform.configurationStore.impl"})
    private static final class DefaultProjectStorage
    extends FileBasedStorage {
        public DefaultProjectStorage(@NotNull Path file, @NotNull String fileSpec, @NotNull PathMacroManager pathMacroManager, @NotNull StreamProvider streamProvider) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
            Intrinsics.checkNotNullParameter((Object)pathMacroManager, (String)"pathMacroManager");
            Intrinsics.checkNotNullParameter((Object)streamProvider, (String)"streamProvider");
            super(file, fileSpec, "defaultProject", TrackingPathMacroSubstitutorImplKt.createTrackingSubstitutor(pathMacroManager), RoamingType.DISABLED, streamProvider, null, 64, null);
        }

        @Override
        @Nullable
        public SettingsController getController() {
            return null;
        }

        @Override
        @Nullable
        public Element loadLocalData() {
            return this.postProcessLoadedData((Function0<? extends Element>)((Function0)() -> DefaultProjectStorage.loadLocalData$lambda$0(this)));
        }

        @Override
        @Nullable
        public Element loadFromStreamProvider(@NotNull InputStream stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            return this.postProcessLoadedData((Function0<? extends Element>)((Function0)() -> DefaultProjectStorage.loadFromStreamProvider$lambda$0(this, stream)));
        }

        private final Element postProcessLoadedData(Function0<? extends Element> elementProvider) {
            try {
                Element element = (Element)elementProvider.invoke();
                return element != null && (element = element.getChild("component")) != null ? element.getChild("defaultProject") : null;
            }
            catch (NullPointerException nullPointerException) {
                ComponentStoreImplKt.LOG.warn("Cannot read default project");
                return null;
            }
        }

        @Override
        @NotNull
        protected FileBasedStorage.FileSaveSessionProducer createSaveSession(@NotNull StateMap states) {
            Intrinsics.checkNotNullParameter((Object)states, (String)"states");
            return new FileBasedStorage.FileSaveSessionProducer(states, this){

                protected void saveLocally(DataWriter dataWriter, List<VFileEvent> events) {
                    Intrinsics.checkNotNullParameter((Object)dataWriter, (String)"dataWriter");
                    super.saveLocally(new StringDataWriter(dataWriter){
                        final /* synthetic */ DataWriter $dataWriter;
                        {
                            this.$dataWriter = $dataWriter;
                        }

                        public boolean hasData(DataWriterFilter filter2) {
                            Intrinsics.checkNotNullParameter((Object)filter2, (String)"filter");
                            return this.$dataWriter.hasData(filter2);
                        }

                        public void writeTo$intellij_platform_configurationStore_impl(Writer writer, String lineSeparator, DataWriterFilter filter2) {
                            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
                            Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
                            String lineSeparatorWithIndent = lineSeparator + "    ";
                            writer.append("<application>").append(lineSeparator);
                            writer.append("  <component name=\"ProjectManager\">").append(lineSeparatorWithIndent);
                            DataWriter dataWriter = this.$dataWriter;
                            Intrinsics.checkNotNull((Object)dataWriter, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StringDataWriter");
                            ((StringDataWriter)dataWriter).writeTo$intellij_platform_configurationStore_impl(writer, lineSeparatorWithIndent, filter2);
                            writer.append(lineSeparator);
                            writer.append("  </component>").append(lineSeparator);
                            writer.append("</application>");
                        }
                    }, events);
                }
            };
        }

        private static final Element loadLocalData$lambda$0(DefaultProjectStorage this$0) {
            return super.loadLocalData();
        }

        private static final Element loadFromStreamProvider$lambda$0(DefaultProjectStorage this$0, InputStream $stream) {
            return super.loadFromStreamProvider($stream);
        }
    }
}

