/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DotIdeaProjectStoreDescriptor;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.NestedProjectStorePathManagerKt;
import com.intellij.configurationStore.ProjectStoreDescriptor;
import com.intellij.configurationStore.ProjectStoreImplKt;
import com.intellij.configurationStore.ProjectStorePathCustomizerKt;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StreamProviderFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0016J:\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J>\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0018\"\b\b\u0000\u0010\"*\u00020#2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u0002H\"0\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0016\u0010(\u001a\u00020)2\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00a2\u0006\u0002\u0010*R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0019\u0010$\u001a\u00070\u000b\u00a2\u0006\u0002\b%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006+"}, d2={"Lcom/intellij/configurationStore/DotIdeaProjectStoreDescriptor;", "Lcom/intellij/configurationStore/ProjectStoreDescriptor;", "projectIdentityFile", "Ljava/nio/file/Path;", "historicalProjectBasePath", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getProjectIdentityFile", "()Ljava/nio/file/Path;", "getHistoricalProjectBasePath", "lastSavedProjectName", "", "dotIdea", "getDotIdea", "getJpsBridgeAwareStorageSpec", "Lcom/intellij/openapi/components/Storage;", "filePath", "project", "Lcom/intellij/openapi/project/Project;", "isExternalStorageSupported", "", "()Z", "testStoreDirectoryExistsForProjectRoot", "getModuleStorageSpecs", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "getStorageSpecs", "T", "", "projectName", "Lcom/intellij/openapi/util/NlsSafe;", "getProjectName", "()Ljava/lang/String;", "saveProjectName", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.configurationStore.impl"})
final class DotIdeaProjectStoreDescriptor
implements ProjectStoreDescriptor {
    @NotNull
    private final Path projectIdentityFile;
    @NotNull
    private final Path historicalProjectBasePath;
    @Nullable
    private String lastSavedProjectName;
    @NotNull
    private final Path dotIdea;

    public DotIdeaProjectStoreDescriptor(@NotNull Path projectIdentityFile, @NotNull Path historicalProjectBasePath) {
        Intrinsics.checkNotNullParameter((Object)projectIdentityFile, (String)"projectIdentityFile");
        Intrinsics.checkNotNullParameter((Object)historicalProjectBasePath, (String)"historicalProjectBasePath");
        this.projectIdentityFile = projectIdentityFile;
        this.historicalProjectBasePath = historicalProjectBasePath;
        Path path = this.getProjectIdentityFile().resolve(".idea");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        this.dotIdea = path;
    }

    @NotNull
    public Path getProjectIdentityFile() {
        return this.projectIdentityFile;
    }

    @NotNull
    public Path getHistoricalProjectBasePath() {
        return this.historicalProjectBasePath;
    }

    @NotNull
    public Path getDotIdea() {
        return this.dotIdea;
    }

    @NotNull
    public Storage getJpsBridgeAwareStorageSpec(@NotNull String filePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return NestedProjectStorePathManagerKt.doGetJpsBridgeAwareStorageSpec(filePath, project);
    }

    public boolean isExternalStorageSupported() {
        return true;
    }

    public boolean testStoreDirectoryExistsForProjectRoot() {
        return Files.isDirectory(this.getDotIdea(), new LinkOption[0]);
    }

    @NotNull
    public List<Storage> getModuleStorageSpecs(@NotNull PersistentStateComponent<?> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation, @NotNull StateStorageManager storageManager2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        List<Storage> result = stateSpec.storages().length == 0 ? CollectionsKt.listOf((Object)FileStorageAnnotation.MODULE_FILE_STORAGE_ANNOTATION) : ComponentStoreImplKt.getStorageSpecGenericImpl(stateSpec, component);
        for (StreamProviderFactory provider : StreamProviderFactory.EP_NAME.getExtensions((AreaInstance)project)) {
            List list;
            Object $this$getModuleStorageSpecs_u24lambda_u240;
            DotIdeaProjectStoreDescriptor dotIdeaProjectStoreDescriptor = this;
            try {
                $this$getModuleStorageSpecs_u24lambda_u240 = dotIdeaProjectStoreDescriptor;
                boolean bl = false;
                $this$getModuleStorageSpecs_u24lambda_u240 = Result.constructor-impl((Object)provider.customizeStorageSpecs(component, storageManager2, stateSpec, result, operation));
            }
            catch (Throwable bl) {
                $this$getModuleStorageSpecs_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            if ((list = (List)LoggerKt.getOrLogException((Object)$this$getModuleStorageSpecs_u24lambda_u240, (Logger)ComponentStoreImplKt.LOG)) == null) continue;
            List it = list;
            boolean bl = false;
            return it;
        }
        return result;
    }

    @NotNull
    public <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation, @NotNull StateStorageManager storageManager2) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        Object[] storages = stateSpec.storages();
        if (storages.length == 2 && ApplicationManager.getApplication().isUnitTestMode() && ComponentInfoKt.isSpecialStorage(ComponentInfoKt.getPath((Storage)ArraysKt.first((Object[])storages))) && Intrinsics.areEqual((Object)ComponentInfoKt.getPath((Storage)storages[1]), (Object)"$WORKSPACE_FILE$")) {
            return CollectionsKt.listOf((Object)ArraysKt.first((Object[])storages));
        }
        List result = new ArrayList();
        for (Object storage : storages) {
            if (Intrinsics.areEqual((Object)ComponentInfoKt.getPath((Storage)storage), (Object)"$PROJECT_FILE$")) continue;
            result.add(storage);
        }
        if (result.isEmpty()) {
            FileStorageAnnotation fileStorageAnnotation = FileStorageAnnotation.PROJECT_FILE_STORAGE_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fileStorageAnnotation, (String)"PROJECT_FILE_STORAGE_ANNOTATION");
            result.add(fileStorageAnnotation);
        } else {
            CollectionsKt.sortWith((List)result, (Comparator)ProjectStorePathCustomizerKt.getDeprecatedStorageComparator());
        }
        ComponentManager componentManager = storageManager2.getComponentManager();
        Intrinsics.checkNotNull((Object)componentManager, (String)"null cannot be cast to non-null type com.intellij.openapi.project.Project");
        Project project = (Project)componentManager;
        for (StreamProviderFactory providerFactory : StreamProviderFactory.EP_NAME.asSequence((AreaInstance)project)) {
            List customizedSpecs;
            Object object;
            DotIdeaProjectStoreDescriptor dotIdeaProjectStoreDescriptor = this;
            try {
                DotIdeaProjectStoreDescriptor $this$getStorageSpecs_u24lambda_u240 = dotIdeaProjectStoreDescriptor;
                boolean bl = false;
                object = Result.constructor-impl((Object)providerFactory.customizeStorageSpecs(component, storageManager2, stateSpec, result, operation));
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            if ((customizedSpecs = (List)LoggerKt.getOrLogException((Object)object, (Logger)ComponentStoreImplKt.LOG)) == null) continue;
            return customizedSpecs;
        }
        if (!ComponentInfoKt.isSpecialStorage(ComponentInfoKt.getPath((Storage)CollectionsKt.first((List)result)))) {
            result.add(NestedProjectStorePathManagerKt.access$getDEPRECATED_PROJECT_FILE_STORAGE_ANNOTATION$p());
        }
        return result;
    }

    @NotNull
    public String getProjectName() {
        String storedName = JpsPathUtil.readProjectName((Path)this.getDotIdea());
        if (storedName != null) {
            this.lastSavedProjectName = storedName;
            return storedName;
        }
        return super.getProjectName();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object saveProjectName(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof saveProjectName.1)) ** GOTO lbl-1000
        var8_3 = $completion;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ DotIdeaProjectStoreDescriptor this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.saveProjectName(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = project.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getName(...)");
                currentProjectName = v0;
                if (Intrinsics.areEqual((Object)this.lastSavedProjectName, (Object)currentProjectName)) {
                    return Unit.INSTANCE;
                }
                this.lastSavedProjectName = currentProjectName;
                nameFile = NestedProjectStorePathManagerKt.getNameFileForDotIdeaProject(project, this.getDotIdea());
                try {
                    DotIdeaProjectStoreDescriptor.saveProjectName$doSave(this, currentProjectName, nameFile);
                    ** GOTO lbl52
                }
                catch (AccessDeniedException e) {
                    v1 = LocalFileSystem.getInstance().refreshAndFindFileByNioFile(nameFile);
                    Intrinsics.checkNotNull((Object)v1);
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = currentProjectName;
                    $continuation.L$2 = nameFile;
                    $continuation.L$3 = e;
                    $continuation.label = 1;
                    v2 = ProjectStoreImplKt.ensureFilesWritable(project, CollectionsKt.listOf((Object)v1), (Continuation<? super ReadonlyStatusHandler.OperationStatus>)$continuation);
                    if (v2 == var9_5) {
                        return var9_5;
                    }
                    ** GOTO lbl46
                }
            }
            case 1: {
                e = (AccessDeniedException)$continuation.L$3;
                nameFile = (Path)$continuation.L$2;
                currentProjectName = (String)$continuation.L$1;
                project = (Project)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v2 = $result;
lbl46:
                    // 2 sources

                    if ((status = (ReadonlyStatusHandler.OperationStatus)v2).hasReadonlyFiles()) {
                        throw e;
                    }
                    DotIdeaProjectStoreDescriptor.saveProjectName$doSave(this, currentProjectName, nameFile);
                }
                catch (Throwable e) {
                    ComponentStoreImplKt.LOG.error("Unable to store project name", e);
                }
lbl52:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final void saveProjectName$doSave(DotIdeaProjectStoreDescriptor this$0, String currentProjectName, Path nameFile) {
        Path basePath = this$0.getHistoricalProjectBasePath();
        Path path = basePath.getFileName();
        if (Intrinsics.areEqual((Object)currentProjectName, (Object)(path != null ? ((Object)path).toString() : null))) {
            Files.deleteIfExists(nameFile);
        } else if (Files.isDirectory(basePath, new LinkOption[0])) {
            NioFiles.createParentDirectories((Path)nameFile);
            String string = currentProjectName;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            Files.write(nameFile, byArray, new OpenOption[0]);
        }
    }
}

