/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentInfoKt;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileStorageAnnotation;
import com.intellij.configurationStore.NestedProjectStorePathManagerKt;
import com.intellij.configurationStore.ProjectStoreDescriptor;
import com.intellij.configurationStore.ProjectStorePathCustomizerKt;
import com.intellij.configurationStore.StateStorageManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J:\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f2\n\u0010 \u001a\u0006\u0012\u0002\b\u00030!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J>\u0010(\u001a\b\u0012\u0004\u0012\u00020\u001a0\u001f\"\b\b\u0000\u0010)*\u00020*2\f\u0010 \u001a\b\u0012\u0004\u0012\u0002H)0!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0016\u0010\f\u001a\u0004\u0018\u00010\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0014\u0010\u000e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0019\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006+"}, d2={"Lcom/intellij/configurationStore/IprProjectStoreDescriptor;", "Lcom/intellij/configurationStore/ProjectStoreDescriptor;", "userBaseDir", "Ljava/nio/file/Path;", "file", "<init>", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "projectIdentityFile", "getProjectIdentityFile", "()Ljava/nio/file/Path;", "historicalProjectBasePath", "getHistoricalProjectBasePath", "dotIdea", "getDotIdea", "presentableUrl", "getPresentableUrl", "testStoreDirectoryExistsForProjectRoot", "", "removeProjectConfigurationAndCaches", "", "projectName", "", "Lcom/intellij/openapi/util/NlsSafe;", "getProjectName", "()Ljava/lang/String;", "getJpsBridgeAwareStorageSpec", "Lcom/intellij/openapi/components/Storage;", "filePath", "project", "Lcom/intellij/openapi/project/Project;", "getModuleStorageSpecs", "", "component", "Lcom/intellij/openapi/components/PersistentStateComponent;", "stateSpec", "Lcom/intellij/openapi/components/State;", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "storageManager", "Lcom/intellij/configurationStore/StateStorageManager;", "getStorageSpecs", "T", "", "intellij.platform.configurationStore.impl"})
public final class IprProjectStoreDescriptor
implements ProjectStoreDescriptor {
    @NotNull
    private final Path userBaseDir;
    @NotNull
    private final Path file;

    public IprProjectStoreDescriptor(@NotNull Path userBaseDir, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)userBaseDir, (String)"userBaseDir");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.userBaseDir = userBaseDir;
        this.file = file;
    }

    @NotNull
    public Path getProjectIdentityFile() {
        return this.userBaseDir;
    }

    @NotNull
    public Path getHistoricalProjectBasePath() {
        return this.userBaseDir;
    }

    @Nullable
    public Path getDotIdea() {
        return null;
    }

    @NotNull
    public Path getPresentableUrl() {
        return this.file;
    }

    public boolean testStoreDirectoryExistsForProjectRoot() {
        return Files.isRegularFile(this.file, new LinkOption[0]);
    }

    public void removeProjectConfigurationAndCaches() {
        Files.deleteIfExists(this.file);
    }

    @NotNull
    public String getProjectName() {
        return StringsKt.removeSuffix((String)((Object)this.file.getFileName()).toString(), (CharSequence)".ipr");
    }

    @NotNull
    public Storage getJpsBridgeAwareStorageSpec(@NotNull String filePath, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return NestedProjectStorePathManagerKt.doGetJpsBridgeAwareStorageSpec(filePath, project);
    }

    @NotNull
    public List<Storage> getModuleStorageSpecs(@NotNull PersistentStateComponent<?> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation, @NotNull StateStorageManager storageManager2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (stateSpec.storages().length == 0) {
            return CollectionsKt.listOf((Object)FileStorageAnnotation.MODULE_FILE_STORAGE_ANNOTATION);
        }
        return ComponentStoreImplKt.getStorageSpecGenericImpl(stateSpec, component);
    }

    @NotNull
    public <T> List<Storage> getStorageSpecs(@NotNull PersistentStateComponent<T> component, @NotNull State stateSpec, @NotNull StateStorageOperation operation, @NotNull StateStorageManager storageManager2) {
        Intrinsics.checkNotNullParameter(component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)stateSpec, (String)"stateSpec");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        Intrinsics.checkNotNullParameter((Object)storageManager2, (String)"storageManager");
        List result = new ArrayList();
        boolean hasOnlyDeprecatedStorages = true;
        for (Storage storage : stateSpec.storages()) {
            if (!Intrinsics.areEqual((Object)ComponentInfoKt.getPath(storage), (Object)"$PROJECT_FILE$") && !Intrinsics.areEqual((Object)ComponentInfoKt.getPath(storage), (Object)"$WORKSPACE_FILE$") && !ComponentInfoKt.isSpecialStorage(ComponentInfoKt.getPath(storage))) continue;
            result.add(storage);
            if (storage.deprecated()) continue;
            hasOnlyDeprecatedStorages = false;
        }
        if (result.isEmpty()) {
            return CollectionsKt.listOf((Object)FileStorageAnnotation.PROJECT_FILE_STORAGE_ANNOTATION);
        }
        if (hasOnlyDeprecatedStorages) {
            FileStorageAnnotation fileStorageAnnotation = FileStorageAnnotation.PROJECT_FILE_STORAGE_ANNOTATION;
            Intrinsics.checkNotNullExpressionValue((Object)fileStorageAnnotation, (String)"PROJECT_FILE_STORAGE_ANNOTATION");
            result.add(fileStorageAnnotation);
        }
        CollectionsKt.sortWith((List)result, (Comparator)ProjectStorePathCustomizerKt.getDeprecatedStorageComparator());
        return result;
    }
}

