/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.StateMapKt;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.ArrayUtilRt;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\n\u001a\u00020\u0004H\u0016J\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\fJ\u0011\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0004J(\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u00042\u0016\b\u0002\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0014J\u0006\u0010\u0015\u001a\u00020\u0016J$\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001bJ\u001a\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u001d\u001a\u00020\u0016J\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00042\b\u0010\u001e\u001a\u0004\u0018\u00010\u0012R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\tR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/configurationStore/StateMap;", "", "names", "", "", "states", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "<init>", "([Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicReferenceArray;)V", "[Ljava/lang/String;", "toString", "toMutableMap", "", "keys", "()[Ljava/lang/String;", "get", "key", "getElement", "Lorg/jdom/Element;", "newLiveStates", "", "isEmpty", "", "compare", "", "newStates", "diffs", "", "getState", "archive", "state", "Companion", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nStateMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMap.kt\ncom/intellij/configurationStore/StateMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
public final class StateMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String[] names;
    @NotNull
    private final AtomicReferenceArray<Object> states;
    @JvmField
    @NotNull
    public static final StateMap EMPTY;

    private StateMap(String[] names, AtomicReferenceArray<Object> states) {
        this.names = names;
        this.states = states;
    }

    @NotNull
    public String toString() {
        String string;
        if (this == EMPTY) {
            string = "EMPTY";
        } else {
            String string2 = this.states.toString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        }
        return string;
    }

    @NotNull
    public final Map<String, Object> toMutableMap() {
        HashMap<String, Object> map2 = new HashMap<String, Object>(this.names.length);
        int n = this.names.length;
        for (int i = 0; i < n; ++i) {
            map2.put(this.names[i], this.states.get(i));
        }
        return map2;
    }

    @NotNull
    public final String[] keys() {
        return this.names;
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        return index < 0 ? null : this.states.get(index);
    }

    @Nullable
    public final Element getElement(@NotNull String key, @Nullable Map<String, ? extends Element> newLiveStates) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Object state = this.get(key);
        if (state instanceof Element) {
            element = ((Element)state).clone();
        } else {
            element = newLiveStates;
            if (element == null || (element = (Element)element.get(key)) == null) {
                byte[] byArray = state instanceof byte[] ? (byte[])state : null;
                if (byArray != null) {
                    byte[] p0 = byArray;
                    boolean bl = false;
                    element = StateMapKt.access$unarchiveState(p0);
                } else {
                    element = null;
                }
            }
        }
        return element;
    }

    public static /* synthetic */ Element getElement$default(StateMap stateMap, String string, Map map2, int n, Object object) {
        if ((n & 2) != 0) {
            map2 = null;
        }
        return stateMap.getElement(string, map2);
    }

    public final boolean isEmpty() {
        return this.names.length == 0;
    }

    public final void compare(@NotNull String key, @NotNull StateMap newStates, @NotNull Set<String> diffs) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)newStates, (String)"newStates");
        Intrinsics.checkNotNullParameter(diffs, (String)"diffs");
        Object oldState = this.get(key);
        Object newState = newStates.get(key);
        if (oldState instanceof Element) {
            if (!JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) {
                diffs.add(key);
            }
        } else if (oldState == null) {
            if (newState != null) {
                diffs.add(key);
            }
        } else if (newState == null || StateMapKt.access$getNewByteIfDiffers(key, newState, (byte[])oldState) != null) {
            diffs.add(key);
        }
    }

    @Nullable
    public final Element getState(@NotNull String key, boolean archive) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int index = ArraysKt.binarySearch$default((Object[])this.names, (Object)key, (int)0, (int)0, (int)6, null);
        if (index < 0) {
            return null;
        }
        Object prev = archive ? this.states.getAndUpdate(index, StateMap::getState$lambda$0) : this.states.updateAndGet(index, StateMap::getState$lambda$1);
        return prev instanceof Element ? (Element)prev : null;
    }

    public static /* synthetic */ Element getState$default(StateMap stateMap, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stateMap.getState(string, bl);
    }

    public final void archive(@NotNull String key, @Nullable Element state) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index >= 0) {
            byte[] byArray;
            AtomicReferenceArray<Object> atomicReferenceArray = this.states;
            int n = index;
            Element element = state;
            if (element != null) {
                Element element2 = element;
                int n2 = n;
                AtomicReferenceArray<Object> atomicReferenceArray2 = atomicReferenceArray;
                boolean bl = false;
                byte[] byArray2 = StateMapKt.access$archiveState(state).toByteArray();
                atomicReferenceArray = atomicReferenceArray2;
                n = n2;
                byArray = byArray2;
            } else {
                byArray = null;
            }
            atomicReferenceArray.set(n, byArray);
        }
    }

    private static final Object getState$lambda$0(Object state) {
        return state instanceof Element ? (Object)StateMapKt.access$archiveState((Element)state).toByteArray() : state;
    }

    private static final Object getState$lambda$1(Object state) {
        return state instanceof byte[] ? StateMapKt.access$unarchiveState((byte[])state) : state;
    }

    public /* synthetic */ StateMap(String[] names, AtomicReferenceArray states, DefaultConstructorMarker $constructor_marker) {
        this(names, states);
    }

    static {
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_STRING_ARRAY, (String)"EMPTY_STRING_ARRAY");
        EMPTY = new StateMap(ArrayUtilRt.EMPTY_STRING_ARRAY, new AtomicReferenceArray<Object>(0));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u00020\u00052\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\bR\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/configurationStore/StateMap$Companion;", "", "<init>", "()V", "EMPTY", "Lcom/intellij/configurationStore/StateMap;", "fromMap", "map", "", "", "intellij.platform.configurationStore.impl"})
    @SourceDebugExtension(value={"SMAP\nStateMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMap.kt\ncom/intellij/configurationStore/StateMap$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,204:1\n37#2,2:205\n*S KotlinDebug\n*F\n+ 1 StateMap.kt\ncom/intellij/configurationStore/StateMap$Companion\n*L\n30#1:205,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StateMap fromMap(@NotNull Map<String, ? extends Object> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            if (map2.isEmpty()) {
                return EMPTY;
            }
            Collection $this$toTypedArray$iv = map2.keySet();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] names = thisCollection$iv.toArray(new String[0]);
            if (!(map2 instanceof TreeMap)) {
                Arrays.sort(names);
            }
            AtomicReferenceArray<Object> states = new AtomicReferenceArray<Object>(names.length);
            int n = names.length;
            for (int i = 0; i < n; ++i) {
                states.set(i, map2.get(names[i]));
            }
            return new StateMap((String[])names, states, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

