/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ApplicationStoreImplKt;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DataStateChanged;
import com.intellij.configurationStore.DataWriter;
import com.intellij.configurationStore.FileBasedStorage;
import com.intellij.configurationStore.Macro;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.configurationStore.TrackingPathMacroSubstitutorImplKt;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.components.StateStorageOperation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import com.intellij.platform.settings.SettingsController;
import com.intellij.util.LineSeparator;
import java.nio.file.Files;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001d\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\"\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\tH\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\tH\u0016R\u0014\u0010\u000f\u001a\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/intellij/configurationStore/ApplicationStateStorageManager;", "Lcom/intellij/configurationStore/StateStorageManagerImpl;", "pathMacroManager", "Lcom/intellij/openapi/components/PathMacroManager;", "controller", "Lcom/intellij/platform/settings/SettingsController;", "<init>", "(Lcom/intellij/openapi/components/PathMacroManager;Lcom/intellij/platform/settings/SettingsController;)V", "getOldStorageSpec", "", "component", "", "componentName", "operation", "Lcom/intellij/openapi/components/StateStorageOperation;", "isUseXmlProlog", "", "()Z", "providerDataStateChanged", "", "storage", "Lcom/intellij/configurationStore/FileBasedStorage;", "writer", "Lcom/intellij/configurationStore/DataWriter;", "type", "Lcom/intellij/configurationStore/DataStateChanged;", "normalizeFileSpec", "fileSpec", "expandMacro", "Ljava/nio/file/Path;", "collapsedPath", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@VisibleForTesting
public final class ApplicationStateStorageManager
extends StateStorageManagerImpl {
    public ApplicationStateStorageManager(@Nullable PathMacroManager pathMacroManager, @Nullable SettingsController controller) {
        PathMacroManager pathMacroManager2 = pathMacroManager;
        super("application", pathMacroManager2 != null ? TrackingPathMacroSubstitutorImplKt.createTrackingSubstitutor(pathMacroManager2) : null, null, controller);
    }

    public /* synthetic */ ApplicationStateStorageManager(PathMacroManager pathMacroManager, SettingsController settingsController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            pathMacroManager = null;
        }
        this(pathMacroManager, settingsController);
    }

    @Override
    @NotNull
    protected String getOldStorageSpec(@NotNull Object component, @NotNull String componentName, @NotNull StateStorageOperation operation) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
        return "other.xml";
    }

    @Override
    protected boolean isUseXmlProlog() {
        return false;
    }

    @Override
    protected void providerDataStateChanged(@NotNull FileBasedStorage storage, @Nullable DataWriter writer, @NotNull DataStateChanged type) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (Intrinsics.areEqual((Object)storage.fileSpec, (Object)"path.macros.xml") || Intrinsics.areEqual((Object)storage.fileSpec, (Object)"applicationLibraries.xml")) {
            Object object;
            ApplicationStateStorageManager applicationStateStorageManager = this;
            try {
                Boolean bl;
                ApplicationStateStorageManager $this$providerDataStateChanged_u24lambda_u240 = applicationStateStorageManager;
                boolean bl2 = false;
                if (writer == null) {
                    bl = Files.deleteIfExists(storage.getFile());
                } else {
                    writer.writeTo(storage.getFile(), null, LineSeparator.LF, $this$providerDataStateChanged_u24lambda_u240.isUseXmlProlog());
                    bl = Unit.INSTANCE;
                }
                object = Result.constructor-impl((Object)bl);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)ComponentStoreImplKt.LOG);
        }
    }

    @Override
    @NotNull
    protected String normalizeFileSpec(@NotNull String fileSpec) {
        Intrinsics.checkNotNullParameter((Object)fileSpec, (String)"fileSpec");
        return ApplicationStoreImplKt.removeMacroIfStartsWith(super.normalizeFileSpec(fileSpec), "$APP_CONFIG$");
    }

    @Override
    @NotNull
    public Path expandMacro(@NotNull String collapsedPath) {
        Intrinsics.checkNotNullParameter((Object)collapsedPath, (String)"collapsedPath");
        if (collapsedPath.charAt(0) == '$') {
            return super.expandMacro(collapsedPath);
        }
        Path path = ((Macro)this.macros.get((int)0)).value.resolve(collapsedPath);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }
}

