/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.BinaryXmlOutputterKt;
import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.util.SystemProperties;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\u001aF\u0010\u0000\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001H\u0000\u001aD\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\u0004\u001a\u00020\u00022\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001H\u0000\u001a\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0011H\u0002\u001a\"\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0011H\u0002\u00a8\u0006\u0014"}, d2={"setStateAndCloneIfNeeded", "", "", "", "key", "newState", "Lorg/jdom/Element;", "oldStates", "Lcom/intellij/configurationStore/StateMap;", "newLiveStates", "updateState", "", "states", "archiveState", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "state", "unarchiveState", "", "getNewByteIfDiffers", "oldState", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nStateMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMap.kt\ncom/intellij/configurationStore/StateMapKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,204:1\n1#2:205\n*E\n"})
public final class StateMapKt {
    @Nullable
    public static final Map<String, Object> setStateAndCloneIfNeeded(@NotNull String key, @Nullable Element newState, @NotNull StateMap oldStates, @Nullable Map<String, Element> newLiveStates) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)oldStates, (String)"oldStates");
        Object oldState = oldStates.get(key);
        if (newState == null || JDOMUtil.isEmpty((Element)newState)) {
            if (oldState == null) {
                return null;
            }
            Map<String, Object> newStates = oldStates.toMutableMap();
            newStates.remove(key);
            return newStates;
        }
        Map<String, Element> map2 = newLiveStates;
        if (map2 != null) {
            map2.put(key, newState);
        }
        byte[] newBytes = null;
        if (oldState instanceof Element) {
            if (JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState)) {
                return null;
            }
        } else if (oldState != null) {
            byte[] byArray = StateMapKt.getNewByteIfDiffers(key, newState, (byte[])oldState);
            if (byArray == null) {
                return null;
            }
            newBytes = byArray;
        }
        Map<String, Object> newStates = oldStates.toMutableMap();
        Object object = newBytes;
        if (newBytes == null) {
            Element element = JDOMUtil.internElement((Element)newState);
            object = element;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"internElement(...)");
        }
        newStates.put(key, object);
        return newStates;
    }

    public static final boolean updateState(@NotNull Map<String, Object> states, @NotNull String key, @Nullable Element newState, @Nullable Map<String, Element> newLiveStates) {
        Intrinsics.checkNotNullParameter(states, (String)"states");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (newState == null || newState.isEmpty()) {
            states.remove(key);
            return true;
        }
        Map<String, Element> map2 = newLiveStates;
        if (map2 != null) {
            map2.put(key, newState);
        }
        Object oldState = states.get(key);
        byte[] newBytes = null;
        if (oldState instanceof Element) {
            if (JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState)) {
                return false;
            }
        } else if (oldState != null) {
            byte[] byArray = StateMapKt.getNewByteIfDiffers(key, newState, (byte[])oldState);
            if (byArray == null) {
                return false;
            }
            newBytes = byArray;
        }
        Object object = newBytes;
        if (newBytes == null) {
            Element element = JDOMUtil.internElement((Element)newState);
            object = element;
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"internElement(...)");
        }
        states.put(key, object);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final BufferExposingByteArrayOutputStream archiveState(Element state) {
        BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
        Closeable closeable = (Closeable)byteOut;
        Throwable throwable = null;
        try {
            BufferExposingByteArrayOutputStream it = (BufferExposingByteArrayOutputStream)closeable;
            boolean bl = false;
            BinaryXmlOutputterKt.serializeElementToBinary((Element)state, (OutputStream)((OutputStream)it));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return byteOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Element unarchiveState(byte[] state) {
        Element element;
        Closeable closeable = new ByteArrayInputStream(state);
        Throwable throwable = null;
        try {
            ByteArrayInputStream it = (ByteArrayInputStream)closeable;
            boolean bl = false;
            element = BinaryXmlOutputterKt.deserializeElementFromBinary((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return element;
    }

    private static final byte[] getNewByteIfDiffers(String key, Object newState, byte[] oldState) {
        byte[] newBytes = null;
        if (newState instanceof Element) {
            BufferExposingByteArrayOutputStream byteOut = StateMapKt.archiveState((Element)newState);
            int newSize = byteOut.size();
            if (oldState.length == newSize && Arrays.equals(byteOut.getInternalBuffer(), 0, newSize, oldState, 0, oldState.length)) {
                return null;
            }
            byte[] byArray = byteOut.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            newBytes = byArray;
        } else {
            Intrinsics.checkNotNull((Object)newState, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            newBytes = (byte[])newState;
            if (Arrays.equals(newBytes, oldState)) {
                return null;
            }
        }
        boolean logChangedComponents = SystemProperties.getBooleanProperty((String)"idea.log.changed.components", (boolean)false);
        if (ApplicationManager.getApplication().isUnitTestMode() || logChangedComponents) {
            String after;
            String before = StateMapKt.getNewByteIfDiffers$stateToString(oldState);
            if (Intrinsics.areEqual((Object)before, (Object)(after = StateMapKt.getNewByteIfDiffers$stateToString(newState)))) {
                throw new IllegalStateException(key + " serialization error - serialized are different, but unserialized are equal");
            }
            if (logChangedComponents) {
                ComponentStoreImplKt.LOG.info(key + " " + StringsKt.repeat((CharSequence)"=", (int)(80 - key.length())) + "\nBefore:\n" + before + "\nAfter:\n" + after);
            }
        }
        return newBytes;
    }

    private static final String getNewByteIfDiffers$stateToString(Object state) {
        Element element = state instanceof Element ? (Element)state : null;
        if (element == null) {
            Intrinsics.checkNotNull((Object)state, (String)"null cannot be cast to non-null type kotlin.ByteArray");
            element = StateMapKt.unarchiveState((byte[])state);
        }
        String string = JDOMUtil.write((Parent)((Parent)element), (String)"\n");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"write(...)");
        return string;
    }

    public static final /* synthetic */ byte[] access$getNewByteIfDiffers(String key, Object newState, byte[] oldState) {
        return StateMapKt.getNewByteIfDiffers(key, newState, oldState);
    }

    public static final /* synthetic */ Element access$unarchiveState(byte[] state) {
        return StateMapKt.unarchiveState(state);
    }

    public static final /* synthetic */ BufferExposingByteArrayOutputStream access$archiveState(Element state) {
        return StateMapKt.archiveState(state);
    }
}

