/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ConfigurationStoreBundle;
import com.intellij.configurationStore.DirectoryBasedStorage;
import com.intellij.configurationStore.ProjectStoreBridgeKt;
import com.intellij.configurationStore.ProjectStoreImpl;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateStorageBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.trustedProjects.TrustedProjects;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.platform.diagnostic.telemetry.helpers.MillisecondsMeasurer;
import com.intellij.platform.workspace.jps.JpsProjectConfigLocation;
import com.intellij.platform.workspace.jps.serialization.impl.JpsProjectSerializersImplKt;
import com.intellij.util.PathUtilRt;
import com.intellij.workspaceModel.ide.impl.JpsMetricsKt;
import com.intellij.workspaceModel.ide.impl.jps.serialization.CachingJpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReaderWithCache;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableMeasurement;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ$\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\b\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/configurationStore/StorageJpsConfigurationReader;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReaderWithCache;", "project", "Lcom/intellij/openapi/project/Project;", "configLocation", "Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;", "projectStore", "Lcom/intellij/configurationStore/ProjectStoreImpl;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/platform/workspace/jps/JpsProjectConfigLocation;Lcom/intellij/configurationStore/ProjectStoreImpl;)V", "fileContentCachingReader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/CachingJpsFileContentReader;", "externalConfigurationDir", "Lkotlin/Lazy;", "Ljava/nio/file/Path;", "loadComponent", "Lorg/jdom/Element;", "fileUrl", "", "componentName", "customModuleFilePath", "isExternalMiscFile", "", "filePath", "getCachingReader", "getExpandMacroMap", "Lcom/intellij/openapi/components/ExpandMacroToPathMap;", "clearCache", "", "Companion", "intellij.platform.configurationStore.impl"})
@SourceDebugExtension(value={"SMAP\nProjectStoreBridge.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStoreBridge.kt\ncom/intellij/configurationStore/StorageJpsConfigurationReader\n+ 2 MillisecondsMeasurer.kt\ncom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer\n+ 3 Timing.kt\nkotlin/system/TimingKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,483:1\n44#2,2:484\n46#2:490\n29#3,2:486\n31#3:489\n1#4:488\n*S KotlinDebug\n*F\n+ 1 ProjectStoreBridge.kt\ncom/intellij/configurationStore/StorageJpsConfigurationReader\n*L\n398#1:484,2\n398#1:490\n398#1:486,2\n398#1:489\n*E\n"})
final class StorageJpsConfigurationReader
implements JpsFileContentReaderWithCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JpsProjectConfigLocation configLocation;
    @NotNull
    private final ProjectStoreImpl projectStore;
    @Nullable
    private volatile CachingJpsFileContentReader fileContentCachingReader;
    @NotNull
    private final Lazy<Path> externalConfigurationDir;
    @NotNull
    private static final AtomicLong loadComponentTimeMs = MillisecondsMeasurer.constructor-impl$default(null, (int)1, null);

    public StorageJpsConfigurationReader(@NotNull Project project, @NotNull JpsProjectConfigLocation configLocation, @NotNull ProjectStoreImpl projectStore) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configLocation, (String)"configLocation");
        Intrinsics.checkNotNullParameter((Object)projectStore, (String)"projectStore");
        this.project = project;
        this.configLocation = configLocation;
        this.projectStore = projectStore;
        this.externalConfigurationDir = LazyKt.lazy(() -> StorageJpsConfigurationReader.externalConfigurationDir$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Element loadComponent(@NotNull String fileUrl, @NotNull String componentName, @Nullable String customModuleFilePath) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        AtomicLong atomicLong = loadComponentTimeMs;
        boolean bl = false;
        Element value$iv = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv$iv = System.currentTimeMillis();
        AtomicLong atomicLong2 = atomicLong;
        boolean bl2 = false;
        boolean bl3 = false;
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        String string = FileUtilRt.toSystemDependentName((String)filePath);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        if (ProjectUtil.INSTANCE.isRemotePath(string) && !TrustedProjects.isProjectTrusted((Project)this.project)) {
            throw new IOException(ConfigurationStoreBundle.message("error.message.details.configuration.files.from.remote.locations.in.safe.mode", new Object[0]));
        }
        if (((CharSequence)componentName).length() == 0) {
            VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(fileUrl);
            Object object = file;
            if (object != null && (object = object.getInputStream()) != null) {
                Closeable closeable = (Closeable)object;
                Throwable throwable = null;
                try {
                    InputStream it = (InputStream)closeable;
                    boolean bl4 = false;
                    Element element2 = JDOMUtil.load((InputStream)it);
                    element = element2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            } else {
                element = null;
            }
        } else {
            Intrinsics.checkNotNull((Object)filePath);
            if (this.isExternalMiscFile(filePath)) {
                element = this.getCachingReader().loadComponent(fileUrl, componentName, customModuleFilePath);
            } else if (StringsKt.endsWith$default((String)filePath, (String)".iml", (boolean)false, (int)2, null) || JpsProjectSerializersImplKt.isExternalModuleFile((String)filePath)) {
                element = this.getCachingReader().loadComponent(fileUrl, componentName, customModuleFilePath);
            } else {
                Element component;
                Object object;
                StateStorageBase storage = ProjectStoreBridgeKt.access$getProjectStateStorage(filePath, this.projectStore, this.project);
                StateMap stateMap = (StateMap)storage.getStorageData();
                if (storage instanceof DirectoryBasedStorage) {
                    String string2 = PathUtilRt.getFileName((String)filePath);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFileName(...)");
                    Element elementContent = StateMap.getElement$default(stateMap, string2, null, 2, null);
                    object = elementContent == null ? null : new Element("component").setAttribute("name", componentName).addContent(elementContent);
                } else {
                    object = StateMap.getElement$default(stateMap, componentName, null, 2, null);
                }
                element = component = object;
            }
        }
        value$iv = element;
        atomicLong2.addAndGet(System.currentTimeMillis() - start$iv$iv);
        return value$iv;
    }

    private final boolean isExternalMiscFile(String filePath) {
        return Intrinsics.areEqual((Object)PathUtilRt.getFileName((String)filePath), (Object)"misc.xml") && Path.of(filePath, new String[0]).startsWith((Path)this.externalConfigurationDir.getValue());
    }

    private final CachingJpsFileContentReader getCachingReader() {
        CachingJpsFileContentReader reader;
        CachingJpsFileContentReader cachingJpsFileContentReader = this.fileContentCachingReader;
        if (cachingJpsFileContentReader == null) {
            cachingJpsFileContentReader = reader = new CachingJpsFileContentReader(this.configLocation);
        }
        if (this.fileContentCachingReader == null) {
            this.fileContentCachingReader = reader;
        }
        return reader;
    }

    @NotNull
    public ExpandMacroToPathMap getExpandMacroMap(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        String filePath = JpsPathUtil.urlToPath((String)fileUrl);
        Intrinsics.checkNotNull((Object)filePath);
        if (StringsKt.endsWith$default((String)filePath, (String)".iml", (boolean)false, (int)2, null) || JpsProjectSerializersImplKt.isExternalModuleFile((String)filePath)) {
            return this.getCachingReader().getExpandMacroMap(fileUrl);
        }
        ExpandMacroToPathMap expandMacroToPathMap = PathMacroManager.getInstance((ComponentManager)((ComponentManager)this.project)).getExpandMacroMap();
        Intrinsics.checkNotNullExpressionValue((Object)expandMacroToPathMap, (String)"getExpandMacroMap(...)");
        return expandMacroToPathMap;
    }

    public void clearCache() {
        this.fileContentCachingReader = null;
    }

    private static final Path externalConfigurationDir$lambda$0(StorageJpsConfigurationReader this$0) {
        return com.intellij.openapi.project.ProjectUtil.getExternalConfigurationDir((Project)this$0.project);
    }

    static {
        Meter meter = JpsMetricsKt.getJpsMetrics().getMeter();
        Intrinsics.checkNotNullExpressionValue((Object)meter, (String)"getMeter(...)");
        StorageJpsConfigurationReader.Companion.setupOpenTelemetryReporting(meter);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002R\u0010\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/configurationStore/StorageJpsConfigurationReader$Companion;", "", "<init>", "()V", "loadComponentTimeMs", "Lcom/intellij/platform/diagnostic/telemetry/helpers/MillisecondsMeasurer;", "Ljava/util/concurrent/atomic/AtomicLong;", "setupOpenTelemetryReporting", "", "meter", "Lio/opentelemetry/api/metrics/Meter;", "intellij.platform.configurationStore.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final void setupOpenTelemetryReporting(Meter meter) {
            ObservableLongMeasurement loadComponentTimeCounter = meter.counterBuilder("jps.storage.jps.conf.reader.load.component.ms").buildObserver();
            meter.batchCallback(() -> Companion.setupOpenTelemetryReporting$lambda$0(loadComponentTimeCounter), (ObservableMeasurement)loadComponentTimeCounter, new ObservableMeasurement[0]);
        }

        private static final void setupOpenTelemetryReporting$lambda$0(ObservableLongMeasurement $loadComponentTimeCounter) {
            $loadComponentTimeCounter.record(MillisecondsMeasurer.asMilliseconds-impl((AtomicLong)loadComponentTimeMs));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

