/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore.statistic.eventLog;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.configurationStore.statistic.eventLog.ConfigurationState;
import com.intellij.configurationStore.statistic.eventLog.ConfigurationStateExtractor;
import com.intellij.configurationStore.statistic.eventLog.FeatureUsageSettingsEventsKt;
import com.intellij.configurationStore.statistic.eventLog.SettingsChangesCollector;
import com.intellij.configurationStore.statistic.eventLog.SettingsCollector;
import com.intellij.configurationStore.statistic.eventLog.SettingsFields;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.utils.PluginInfo;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJT\u0010\u0013\u001a\u00020\t2&\b\u0001\u0010\u0014\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0012\u0004\u0012\u00020\t0\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014JT\u0010\u001c\u001a\u00020\t2&\b\u0001\u0010\u0014\u001a \u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0012\u0004\u0012\u00020\t0\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\u0010\u0018\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventPrinter;", "", "recordDefault", "", "<init>", "(Z)V", "valuesExtractor", "Lcom/intellij/configurationStore/statistic/eventLog/ConfigurationStateExtractor;", "logDefaultConfigurationState", "", "componentName", "", "clazz", "Ljava/lang/Class;", "project", "Lcom/intellij/openapi/project/Project;", "logConfigurationStateChanged", "state", "logConfigurationState", "logConfig", "eventFunction", "Lkotlin/Function2;", "", "Lcom/intellij/internal/statistic/eventLog/events/EventPair;", "data", "", "id", "", "logSettingsChanged", "intellij.platform.configurationStore.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nFeatureUsageSettingsEvents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureUsageSettingsEvents.kt\ncom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventPrinter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,315:1\n13#2:316\n*S KotlinDebug\n*F\n+ 1 FeatureUsageSettingsEvents.kt\ncom/intellij/configurationStore/statistic/eventLog/FeatureUsageSettingsEventPrinter\n*L\n138#1:316\n*E\n"})
public class FeatureUsageSettingsEventPrinter {
    private final boolean recordDefault;
    @NotNull
    private final ConfigurationStateExtractor valuesExtractor;

    public FeatureUsageSettingsEventPrinter(boolean recordDefault) {
        this.recordDefault = recordDefault;
        this.valuesExtractor = new ConfigurationStateExtractor(this.recordDefault);
    }

    public final void logDefaultConfigurationState(@NotNull String componentName, @NotNull Class<?> clazz, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            PluginInfo pluginInfo;
            if (this.recordDefault) {
                Object object = XmlSerializer.getJdomSerializer().getDefaultSerializationFilter().getDefaultValue(clazz);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefaultValue(...)");
                Object object2 = object;
                this.logConfigurationState(componentName, object2, project);
            } else if (!Intrinsics.areEqual(clazz, Element.class) && (pluginInfo = PluginInfoDetectorKt.getPluginInfo(clazz)).isDevelopedByJetBrains()) {
                FeatureUsageSettingsEventsKt.access$getRecordedComponents$p().add(componentName);
                List data = FeatureUsageSettingsEventsKt.access$createComponentData(project, componentName, pluginInfo);
                this.logConfig((Function2)new Function2<Project, List<? extends EventPair<?>>, Unit>(SettingsCollector.Companion){

                    public final void invoke(Project p0, List<? extends EventPair<?>> p1) {
                        Intrinsics.checkNotNullParameter(p1, (String)"p1");
                        ((SettingsCollector.Companion)this.receiver).logInvoked(p0, p1);
                    }
                }, project, data, FeatureUsageSettingsEventsKt.access$getCounter$p().incrementAndGet());
            }
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(FeatureUsageSettingsEventPrinter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot initialize default settings for '" + componentName + "'");
        }
    }

    public final void logConfigurationStateChanged(@NotNull String componentName, @NotNull Object state, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ConfigurationState configurationState = this.valuesExtractor.extract$intellij_platform_configurationStore_impl(project, componentName, state);
        if (configurationState == null) {
            return;
        }
        ConfigurationState configurationState2 = configurationState;
        List<List<EventPair<?>>> optionsValues = configurationState2.component1();
        PluginInfo pluginInfo = configurationState2.component2();
        int id = FeatureUsageSettingsEventsKt.access$getCounter$p().incrementAndGet();
        for (List<EventPair<?>> data : optionsValues) {
            this.logSettingsChanged((Function2)new Function2<Project, List<? extends EventPair<?>>, Unit>((Object)SettingsChangesCollector.INSTANCE){

                public final void invoke(Project p0, List<? extends EventPair<?>> p1) {
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    SettingsChangesCollector.logComponentChangedOption(p0, p1);
                }
            }, project, data, id);
        }
        if (!this.recordDefault) {
            this.logSettingsChanged((Function2)new Function2<Project, List<? extends EventPair<?>>, Unit>((Object)SettingsChangesCollector.INSTANCE){

                public final void invoke(Project p0, List<? extends EventPair<?>> p1) {
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    SettingsChangesCollector.logComponentChanged(p0, p1);
                }
            }, project, FeatureUsageSettingsEventsKt.access$createComponentData(project, componentName, pluginInfo), id);
        }
    }

    public final void logConfigurationState(@NotNull String componentName, @NotNull Object state, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)componentName, (String)"componentName");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        ConfigurationState configurationState = this.valuesExtractor.extract$intellij_platform_configurationStore_impl(project, componentName, state);
        if (configurationState == null) {
            return;
        }
        ConfigurationState configurationState2 = configurationState;
        List<List<EventPair<?>>> optionsValues = configurationState2.component1();
        PluginInfo pluginInfo = configurationState2.component2();
        KFunction eventId2 = this.recordDefault ? (KFunction)new Function2<Project, List<? extends EventPair<?>>, Unit>(SettingsCollector.Companion){

            public final void invoke(Project p0, List<? extends EventPair<?>> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((SettingsCollector.Companion)this.receiver).logOption(p0, p1);
            }
        } : (KFunction)new Function2<Project, List<? extends EventPair<?>>, Unit>(SettingsCollector.Companion){

            public final void invoke(Project p0, List<? extends EventPair<?>> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((SettingsCollector.Companion)this.receiver).logNotDefault(p0, p1);
            }
        };
        int id = FeatureUsageSettingsEventsKt.access$getCounter$p().incrementAndGet();
        for (List<EventPair<?>> data : optionsValues) {
            this.logConfig((Function2)eventId2, project, data, id);
        }
        if (!this.recordDefault) {
            this.logConfig((Function2)new Function2<Project, List<? extends EventPair<?>>, Unit>(SettingsCollector.Companion){

                public final void invoke(Project p0, List<? extends EventPair<?>> p1) {
                    Intrinsics.checkNotNullParameter(p1, (String)"p1");
                    ((SettingsCollector.Companion)this.receiver).logInvoked(p0, p1);
                }
            }, project, FeatureUsageSettingsEventsKt.access$createComponentData(project, componentName, pluginInfo), id);
        }
    }

    protected void logConfig(@NonNls @NotNull Function2<? super Project, ? super List<? extends EventPair<?>>, Unit> eventFunction, @Nullable Project project, @NotNull List<EventPair<?>> data, int id) {
        Intrinsics.checkNotNullParameter(eventFunction, (String)"eventFunction");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        data.add(SettingsFields.ID_FIELD.with((Object)id));
        eventFunction.invoke((Object)project, data);
    }

    protected void logSettingsChanged(@NonNls @NotNull Function2<? super Project, ? super List<? extends EventPair<?>>, Unit> eventFunction, @Nullable Project project, @NotNull List<EventPair<?>> data, int id) {
        Intrinsics.checkNotNullParameter(eventFunction, (String)"eventFunction");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        data.add(SettingsFields.ID_FIELD.with((Object)id));
        eventFunction.invoke((Object)project, data);
    }
}

