/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.kdbx.KdbxEntry;
import com.intellij.credentialStore.kdbx.KdbxGroupKt;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.util.containers.ContainerUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010!\u001a\u0004\u0018\u00010\u00002\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0000H\u0002J\u000e\u0010\"\u001a\u00020#2\u0006\u0010\r\u001a\u00020\fJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fJ\u0010\u0010&\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\fH\u0002J+\u0010'\u001a\u0004\u0018\u00010\u00162!\u0010(\u001a\u001d\u0012\u0013\u0012\u00110\u0016\u00a2\u0006\f\b*\u0012\b\b\r\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020,0)J\u000e\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0016J\u0010\u0010.\u001a\u00020\u00162\u0006\u0010+\u001a\u00020\u0016H\u0002J\u001a\u0010'\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020\f2\b\u00100\u001a\u0004\u0018\u00010\fJ\u0018\u00101\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\f2\b\u00100\u001a\u0004\u0018\u00010\fJ\u001a\u0010.\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020\f2\b\u00100\u001a\u0004\u0018\u00010\fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\u001b8B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u00062"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "", "element", "Lorg/jdom/Element;", "database", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "parent", "<init>", "(Lorg/jdom/Element;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;Lcom/intellij/credentialStore/kdbx/KdbxGroup;)V", "getElement$intellij_platform_credentialStore_impl", "()Lorg/jdom/Element;", "value", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "groups", "", "entries", "", "Lcom/intellij/credentialStore/kdbx/KdbxEntry;", "getEntries", "()Ljava/util/List;", "entries$delegate", "Lkotlin/Lazy;", "", "locationChanged", "getLocationChanged", "()J", "setLocationChanged", "(J)V", "getGroup", "removeGroup", "", "group", "getOrCreateGroup", "createGroup", "getEntry", "matcher", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "entry", "", "addEntry", "removeEntry", "title", "userName", "createEntry", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nKdbxGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KdbxGroup.kt\ncom/intellij/credentialStore/kdbx/KdbxGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,159:1\n1#2:160\n295#3,2:161\n295#3,2:163\n1563#3:165\n1634#3,3:166\n*S KotlinDebug\n*F\n+ 1 KdbxGroup.kt\ncom/intellij/credentialStore/kdbx/KdbxGroup\n*L\n50#1:161,2\n88#1:163,2\n32#1:165\n32#1:166,3\n*E\n"})
public final class KdbxGroup {
    @NotNull
    private final Element element;
    @NotNull
    private final KeePassDatabase database;
    @Nullable
    private volatile KdbxGroup parent;
    @NotNull
    private final Map<String, KdbxGroup> groups;
    @NotNull
    private final Lazy entries$delegate;

    public KdbxGroup(@NotNull Element element, @NotNull KeePassDatabase database, @Nullable KdbxGroup parent) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)database, (String)"database");
        this.element = element;
        this.database = database;
        this.parent = parent;
        this.groups = new HashMap();
        this.entries$delegate = LazyKt.lazy(() -> KdbxGroup.entries_delegate$lambda$0(this));
    }

    @NotNull
    public final Element getElement$intellij_platform_credentialStore_impl() {
        return this.element;
    }

    @NotNull
    public final synchronized String getName() {
        String string = this.element.getChildText("Name");
        if (string == null) {
            string = "Unnamed";
        }
        return string;
    }

    public final synchronized void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Element nameElement = this.element.getOrCreateChild("Name");
        if (Intrinsics.areEqual((Object)nameElement.getText(), (Object)value)) {
            return;
        }
        nameElement.setText(value);
        this.database.setDirty$intellij_platform_credentialStore_impl(true);
    }

    private final List<KdbxEntry> getEntries() {
        Lazy lazy = this.entries$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (List)object;
    }

    private final long getLocationChanged() {
        long l;
        Object object = this.element.getChild("Times");
        if (object != null && (object = object.getChild("LocationChanged")) != null && (object = object.getText()) != null) {
            Object p0 = object;
            boolean bl = false;
            l = KdbxGroupKt.access$parseTime((String)p0);
        } else {
            l = 0L;
        }
        return l;
    }

    private final void setLocationChanged(long value) {
        this.element.getOrCreateChild("Times").getOrCreateChild("LocationChanged").setText(Instant.ofEpochMilli(value).atZone(ZoneOffset.UTC).format(KeePassDatabaseKt.getDateFormatter()));
    }

    @Nullable
    public final synchronized KdbxGroup getGroup(@NotNull String name) {
        Object v1;
        KdbxGroup result;
        block3: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            result = this.groups.get(name);
            if (result != null) {
                return result;
            }
            List list = this.element.getContent();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Content it = (Content)element$iv;
                boolean bl = false;
                if (!(it instanceof Element && Intrinsics.areEqual((Object)((Element)it).getChildText("Name"), (Object)name))) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        Content content = v1;
        if (content == null) {
            return null;
        }
        Content groupElement = content;
        result = new KdbxGroup((Element)groupElement, this.database, this);
        this.groups.put(name, result);
        return result;
    }

    private final synchronized void removeGroup(KdbxGroup group) {
        KdbxGroup removedGroup = this.groups.remove(group.getName());
        CredentialStoreKt.getLOG().assertTrue(group == removedGroup);
        this.element.getContent().remove(group.element);
        group.parent = null;
        this.database.setDirty$intellij_platform_credentialStore_impl(true);
    }

    public final synchronized void removeGroup(@NotNull String name) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            KdbxGroup kdbxGroup = this.getGroup(name);
            if (kdbxGroup == null) break block0;
            KdbxGroup it = kdbxGroup;
            boolean bl = false;
            this.removeGroup(it);
        }
    }

    @NotNull
    public final synchronized KdbxGroup getOrCreateGroup(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        KdbxGroup kdbxGroup = this.getGroup(name);
        if (kdbxGroup == null) {
            kdbxGroup = this.createGroup(name);
        }
        return kdbxGroup;
    }

    private final KdbxGroup createGroup(String name) {
        KdbxGroup result = KdbxGroupKt.createGroup(this.database, this);
        result.setName(name);
        if (Intrinsics.areEqual((Object)result, (Object)this.database.getRootGroup$intellij_platform_credentialStore_impl())) {
            throw new IllegalStateException("Cannot set root group as child of another group");
        }
        this.groups.put(result.getName(), result);
        result.parent = this;
        result.setLocationChanged(LocalDateTime.now(ZoneOffset.UTC).toEpochSecond(ZoneOffset.UTC));
        this.element.addContent(result.element);
        this.database.setDirty$intellij_platform_credentialStore_impl(true);
        return result;
    }

    @Nullable
    public final synchronized KdbxEntry getEntry(@NotNull Function1<? super KdbxEntry, Boolean> matcher) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter(matcher, (String)"matcher");
            Iterable $this$firstOrNull$iv = this.getEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                if (!((Boolean)matcher.invoke(element$iv)).booleanValue()) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final synchronized KdbxEntry addEntry(@NotNull KdbxEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        KdbxGroup kdbxGroup = entry.getGroup$intellij_platform_credentialStore_impl();
        if (kdbxGroup != null) {
            kdbxGroup.removeEntry(entry);
        }
        this.getEntries().add(entry);
        entry.setGroup$intellij_platform_credentialStore_impl(this);
        this.database.setDirty$intellij_platform_credentialStore_impl(true);
        this.element.addContent(entry.getEntryElement$intellij_platform_credentialStore_impl());
        return entry;
    }

    private final KdbxEntry removeEntry(KdbxEntry entry) {
        if (this.getEntries().remove(entry)) {
            entry.setGroup$intellij_platform_credentialStore_impl(null);
            this.element.getContent().remove(entry.getEntryElement$intellij_platform_credentialStore_impl());
            this.database.setDirty$intellij_platform_credentialStore_impl(true);
        }
        return entry;
    }

    @Nullable
    public final synchronized KdbxEntry getEntry(@NotNull String title, @Nullable String userName) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        return this.getEntry((Function1<? super KdbxEntry, Boolean>)((Function1)arg_0 -> KdbxGroup.getEntry$lambda$0(title, userName, arg_0)));
    }

    @NotNull
    public final synchronized KdbxEntry createEntry(@NotNull String title, @Nullable String userName) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        KdbxEntry entry = this.database.createEntry$intellij_platform_credentialStore_impl(title);
        entry.setUserName(userName);
        this.addEntry(entry);
        return entry;
    }

    @Nullable
    public final synchronized KdbxEntry removeEntry(@NotNull String title, @Nullable String userName) {
        KdbxEntry kdbxEntry;
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        KdbxEntry kdbxEntry2 = this.getEntry(title, userName);
        if (kdbxEntry2 != null) {
            KdbxEntry it = kdbxEntry2;
            boolean bl = false;
            kdbxEntry = this.removeEntry(it);
        } else {
            kdbxEntry = null;
        }
        return kdbxEntry;
    }

    /*
     * WARNING - void declaration
     */
    private static final List entries_delegate$lambda$0(KdbxGroup this$0) {
        void $this$mapTo$iv$iv;
        List list = this$0.element.getChildren("Entry");
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildren(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Element element = (Element)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            collection.add(new KdbxEntry((Element)it, this$0.database, this$0));
        }
        return ContainerUtil.createLockFreeCopyOnWriteList((Collection)((List)destination$iv$iv));
    }

    private static final boolean getEntry$lambda$0(String $title, String $userName, KdbxEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it.getTitle(), (Object)$title) && (Intrinsics.areEqual((Object)it.getUserName(), (Object)$userName) || $userName == null);
    }
}

