/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.ConstantValueCreator;
import com.intellij.credentialStore.kdbx.DateValueCreator;
import com.intellij.credentialStore.kdbx.KdbxGroup;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.kdbx.KeePassDatabaseKt;
import com.intellij.credentialStore.kdbx.UuidValueCreator;
import com.intellij.credentialStore.kdbx.ValueCreator;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0001H\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0002\" \u0010\u0005\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"createGroup", "Lcom/intellij/credentialStore/kdbx/KdbxGroup;", "db", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "parent", "mandatoryGroupElements", "", "", "", "Lcom/intellij/credentialStore/kdbx/ValueCreator;", "parseTime", "", "value", "intellij.platform.credentialStore.impl"})
public final class KdbxGroupKt {
    @NotNull
    private static final Map<String[], ValueCreator> mandatoryGroupElements;

    @NotNull
    public static final KdbxGroup createGroup(@NotNull KeePassDatabase db, @Nullable KdbxGroup parent) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        Element element = new Element("Group");
        KeePassDatabaseKt.ensureElements(element, mandatoryGroupElements);
        return new KdbxGroup(element, db, parent);
    }

    private static final long parseTime(String value) {
        long l;
        try {
            l = ZonedDateTime.parse(value).toEpochSecond();
        }
        catch (DateTimeParseException e) {
            l = 0L;
        }
        return l;
    }

    public static final /* synthetic */ long access$parseTime(String value) {
        return KdbxGroupKt.parseTime(value);
    }

    static {
        Pair[] pairArray = new Pair[10];
        pairArray[0] = TuplesKt.to((Object)KeePassDatabaseKt.getUUID_ELEMENT_NAME(), (Object)new UuidValueCreator());
        String[] stringArray = new String[]{"Notes"};
        pairArray[1] = TuplesKt.to((Object)stringArray, (Object)new ConstantValueCreator(""));
        pairArray[2] = TuplesKt.to((Object)KeePassDatabaseKt.getICON_ELEMENT_NAME(), (Object)new ConstantValueCreator("0"));
        pairArray[3] = TuplesKt.to((Object)KeePassDatabaseKt.getCREATION_TIME_ELEMENT_NAME(), (Object)new DateValueCreator());
        pairArray[4] = TuplesKt.to((Object)KeePassDatabaseKt.getLAST_MODIFICATION_TIME_ELEMENT_NAME(), (Object)new DateValueCreator());
        pairArray[5] = TuplesKt.to((Object)KeePassDatabaseKt.getLAST_ACCESS_TIME_ELEMENT_NAME(), (Object)new DateValueCreator());
        pairArray[6] = TuplesKt.to((Object)KeePassDatabaseKt.getEXPIRY_TIME_ELEMENT_NAME(), (Object)new DateValueCreator());
        pairArray[7] = TuplesKt.to((Object)KeePassDatabaseKt.getEXPIRES_ELEMENT_NAME(), (Object)new ConstantValueCreator("False"));
        pairArray[8] = TuplesKt.to((Object)KeePassDatabaseKt.getUSAGE_COUNT_ELEMENT_NAME(), (Object)new ConstantValueCreator("0"));
        pairArray[9] = TuplesKt.to((Object)KeePassDatabaseKt.getLOCATION_CHANGED(), (Object)new DateValueCreator());
        mandatoryGroupElements = MapsKt.linkedMapOf((Pair[])pairArray);
    }
}

