/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.common.io.LittleEndianDataOutputStream;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.kdbx.HashedBlockOutputStream;
import com.intellij.credentialStore.kdbx.KdbxException;
import com.intellij.credentialStore.kdbx.KdbxHeaderKt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.io.DigestUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.UUID;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002/0B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0002\u0010\tJ\u0016\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010'\u001a\u00020(2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010)\u001a\u00020(J\u0010\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0013H\u0002J\u0010\u0010-\u001a\u00020+2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u0010.\u001a\u00020+2\u0006\u0010)\u001a\u00020(R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u001b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001e\u0010\u001f\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u0013@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u001c\u0010!\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001a\"\u0004\b#\u0010$\u00a8\u00061"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader;", "", "<init>", "()V", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "random", "Ljava/security/SecureRandom;", "(Ljava/security/SecureRandom;)V", "cipherUuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "value", "Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "compressionFlags", "getCompressionFlags", "()Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "mainSeed", "", "transformSeed", "transformRounds", "", "encryptionIv", "protectedStreamKey", "getProtectedStreamKey", "()[B", "Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "protectedStreamAlgorithm", "getProtectedStreamAlgorithm", "()Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "streamStartBytes", "getStreamStartBytes", "headerHash", "getHeaderHash", "setHeaderHash", "([B)V", "createDecryptedStream", "digest", "createEncryptedStream", "Ljava/io/OutputStream;", "outputStream", "setCipherUuid", "", "uuid", "readKdbxHeader", "writeKdbxHeader", "CompressionFlags", "ProtectedStreamAlgorithm", "intellij.platform.credentialStore.impl"})
public final class KdbxHeader {
    private UUID cipherUuid;
    @NotNull
    private CompressionFlags compressionFlags;
    @NotNull
    private byte[] mainSeed;
    @NotNull
    private byte[] transformSeed;
    private long transformRounds;
    @NotNull
    private byte[] encryptionIv;
    @NotNull
    private byte[] protectedStreamKey;
    @NotNull
    private ProtectedStreamAlgorithm protectedStreamAlgorithm;
    @NotNull
    private byte[] streamStartBytes;
    @Nullable
    private byte[] headerHash;

    public KdbxHeader() {
        this.cipherUuid = KdbxHeaderKt.access$getAES_CIPHER$p();
        this.compressionFlags = CompressionFlags.GZIP;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"EMPTY_BYTE_ARRAY");
        this.mainSeed = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"EMPTY_BYTE_ARRAY");
        this.transformSeed = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.transformRounds = 6000L;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"EMPTY_BYTE_ARRAY");
        this.encryptionIv = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        Intrinsics.checkNotNullExpressionValue((Object)ArrayUtilRt.EMPTY_BYTE_ARRAY, (String)"EMPTY_BYTE_ARRAY");
        this.protectedStreamKey = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.CHA_CHA;
        this.streamStartBytes = new byte[32];
    }

    public KdbxHeader(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        this();
        this.readKdbxHeader(inputStream);
    }

    public KdbxHeader(@NotNull SecureRandom random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this();
        this.mainSeed = CredentialStoreKt.generateBytes(random, 32);
        this.transformSeed = CredentialStoreKt.generateBytes(random, 32);
        this.encryptionIv = CredentialStoreKt.generateBytes(random, 16);
        this.protectedStreamKey = CredentialStoreKt.generateBytes(random, 64);
    }

    @NotNull
    public final CompressionFlags getCompressionFlags() {
        return this.compressionFlags;
    }

    @NotNull
    public final byte[] getProtectedStreamKey() {
        return this.protectedStreamKey;
    }

    @NotNull
    public final ProtectedStreamAlgorithm getProtectedStreamAlgorithm() {
        return this.protectedStreamAlgorithm;
    }

    @NotNull
    public final byte[] getStreamStartBytes() {
        return this.streamStartBytes;
    }

    @Nullable
    public final byte[] getHeaderHash() {
        return this.headerHash;
    }

    public final void setHeaderHash(@Nullable byte[] byArray) {
        this.headerHash = byArray;
    }

    @NotNull
    public final InputStream createDecryptedStream(@NotNull byte[] digest, @NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        byte[] finalKeyDigest = KdbxHeaderKt.access$getFinalKeyDigest(digest, this.mainSeed, this.transformSeed, this.transformRounds);
        byte[] byArray = this.encryptionIv;
        Cipher cipher = KdbxHeaderKt.access$createChipper(false, byArray, finalKeyDigest);
        return new CipherInputStream(inputStream, cipher);
    }

    @NotNull
    public final OutputStream createEncryptedStream(@NotNull byte[] digest, @NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        byte[] finalKeyDigest = KdbxHeaderKt.access$getFinalKeyDigest(digest, this.mainSeed, this.transformSeed, this.transformRounds);
        byte[] byArray = this.encryptionIv;
        Cipher cipher = KdbxHeaderKt.access$createChipper(true, byArray, finalKeyDigest);
        CipherOutputStream cipherOutputStream = new CipherOutputStream(outputStream, cipher);
        cipherOutputStream.write(this.streamStartBytes);
        HashedBlockOutputStream out = new HashedBlockOutputStream(cipherOutputStream);
        return WhenMappings.$EnumSwitchMapping$0[this.compressionFlags.ordinal()] == 1 ? (OutputStream)new GZIPOutputStream((OutputStream)out, 8192) : (OutputStream)out;
    }

    private final void setCipherUuid(byte[] uuid) {
        ByteBuffer b = ByteBuffer.wrap(uuid);
        UUID incoming = new UUID(b.getLong(), b.getLong(8));
        if (!Intrinsics.areEqual((Object)incoming, (Object)KdbxHeaderKt.access$getAES_CIPHER$p())) {
            throw new IllegalStateException("Unknown Cipher UUID " + incoming);
        }
        this.cipherUuid = incoming;
    }

    private final void readKdbxHeader(InputStream inputStream) {
        byte headerType;
        MessageDigest digest = DigestUtil.sha256();
        DigestInputStream digestInputStream = new DigestInputStream(inputStream, digest);
        LittleEndianDataInputStream input = new LittleEndianDataInputStream((InputStream)digestInputStream);
        if (!KdbxHeaderKt.access$readSignature(input)) {
            throw new KdbxException("Bad signature");
        }
        if (!KdbxHeaderKt.access$verifyFileVersion(input)) {
            throw new IllegalStateException("File version did not match");
        }
        while ((headerType = input.readByte()) != 0) {
            byte by = headerType;
            if (by == 1) {
                KdbxHeaderKt.access$readHeaderData(input);
                continue;
            }
            if (by == 2) {
                this.setCipherUuid(KdbxHeaderKt.access$readHeaderData(input));
                continue;
            }
            if (by == 3) {
                this.compressionFlags = CompressionFlags.values()[KdbxHeaderKt.access$readIntHeaderData(input)];
                continue;
            }
            if (by == 4) {
                this.mainSeed = KdbxHeaderKt.access$readHeaderData(input);
                continue;
            }
            if (by == 5) {
                this.transformSeed = KdbxHeaderKt.access$readHeaderData(input);
                continue;
            }
            if (by == 6) {
                this.transformRounds = KdbxHeaderKt.access$readLongHeaderData(input);
                continue;
            }
            if (by == 7) {
                this.encryptionIv = KdbxHeaderKt.access$readHeaderData(input);
                continue;
            }
            if (by == 8) {
                this.protectedStreamKey = KdbxHeaderKt.access$readHeaderData(input);
                continue;
            }
            if (by == 9) {
                this.streamStartBytes = KdbxHeaderKt.access$readHeaderData(input);
                continue;
            }
            if (by == 10) {
                this.protectedStreamAlgorithm = ProtectedStreamAlgorithm.values()[KdbxHeaderKt.access$readIntHeaderData(input)];
                continue;
            }
            throw new IllegalStateException("Unknown File Header");
        }
        KdbxHeaderKt.access$readHeaderData(input);
        this.headerHash = digest.digest();
    }

    public final void writeKdbxHeader(@NotNull OutputStream outputStream) {
        Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
        MessageDigest messageDigest = DigestUtil.sha256();
        DigestOutputStream digestOutputStream = new DigestOutputStream(outputStream, messageDigest);
        LittleEndianDataOutputStream output = new LittleEndianDataOutputStream((OutputStream)digestOutputStream);
        output.writeInt(-1700603645);
        output.writeInt(-1253311641);
        output.writeInt(196609);
        output.writeByte(2);
        output.writeShort(16);
        byte[] b = new byte[16];
        ByteBuffer bb = ByteBuffer.wrap(b);
        bb.putLong(this.cipherUuid.getMostSignificantBits());
        bb.putLong(8, this.cipherUuid.getLeastSignificantBits());
        output.write(b);
        output.writeByte(3);
        output.writeShort(4);
        output.writeInt(this.compressionFlags.ordinal());
        output.writeByte(4);
        output.writeShort(this.mainSeed.length);
        output.write(this.mainSeed);
        output.writeByte(5);
        output.writeShort(this.transformSeed.length);
        output.write(this.transformSeed);
        output.writeByte(6);
        output.writeShort(8);
        output.writeLong(this.transformRounds);
        output.writeByte(7);
        output.writeShort(this.encryptionIv.length);
        output.write(this.encryptionIv);
        output.writeByte(8);
        output.writeShort(this.protectedStreamKey.length);
        output.write(this.protectedStreamKey);
        output.writeByte(9);
        output.writeShort(this.streamStartBytes.length);
        output.write(this.streamStartBytes);
        output.writeByte(10);
        output.writeShort(4);
        output.writeInt(this.protectedStreamAlgorithm.ordinal());
        output.writeByte(0);
        output.writeShort(0);
        this.headerHash = digestOutputStream.getMessageDigest().digest();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader$CompressionFlags;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "GZIP", "intellij.platform.credentialStore.impl"})
    public static final class CompressionFlags
    extends Enum<CompressionFlags> {
        public static final /* enum */ CompressionFlags NONE = new CompressionFlags();
        public static final /* enum */ CompressionFlags GZIP = new CompressionFlags();
        private static final /* synthetic */ CompressionFlags[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CompressionFlags[] values() {
            return (CompressionFlags[])$VALUES.clone();
        }

        public static CompressionFlags valueOf(String value) {
            return Enum.valueOf(CompressionFlags.class, value);
        }

        @NotNull
        public static EnumEntries<CompressionFlags> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = compressionFlagsArray = new CompressionFlags[]{CompressionFlags.NONE, CompressionFlags.GZIP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/credentialStore/kdbx/KdbxHeader$ProtectedStreamAlgorithm;", "", "<init>", "(Ljava/lang/String;I)V", "NONE", "ARC_FOUR", "SALSA_20", "CHA_CHA", "intellij.platform.credentialStore.impl"})
    public static final class ProtectedStreamAlgorithm
    extends Enum<ProtectedStreamAlgorithm> {
        public static final /* enum */ ProtectedStreamAlgorithm NONE = new ProtectedStreamAlgorithm();
        public static final /* enum */ ProtectedStreamAlgorithm ARC_FOUR = new ProtectedStreamAlgorithm();
        public static final /* enum */ ProtectedStreamAlgorithm SALSA_20 = new ProtectedStreamAlgorithm();
        public static final /* enum */ ProtectedStreamAlgorithm CHA_CHA = new ProtectedStreamAlgorithm();
        private static final /* synthetic */ ProtectedStreamAlgorithm[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ProtectedStreamAlgorithm[] values() {
            return (ProtectedStreamAlgorithm[])$VALUES.clone();
        }

        public static ProtectedStreamAlgorithm valueOf(String value) {
            return Enum.valueOf(ProtectedStreamAlgorithm.class, value);
        }

        @NotNull
        public static EnumEntries<ProtectedStreamAlgorithm> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = protectedStreamAlgorithmArray = new ProtectedStreamAlgorithm[]{ProtectedStreamAlgorithm.NONE, ProtectedStreamAlgorithm.ARC_FOUR, ProtectedStreamAlgorithm.SALSA_20, ProtectedStreamAlgorithm.CHA_CHA};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompressionFlags.values().length];
            try {
                nArray[CompressionFlags.GZIP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

