/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.credentialStore.kdbx.ProtectedValue;
import com.intellij.credentialStore.kdbx.ProtectedValueKt;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/credentialStore/kdbx/XmlProtectedValueTransformer;", "", "streamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "<init>", "(Lorg/bouncycastle/crypto/SkippingStreamCipher;)V", "position", "", "processEntries", "", "parentElement", "Lorg/jdom/Element;", "intellij.platform.credentialStore.impl"})
public final class XmlProtectedValueTransformer {
    @NotNull
    private final SkippingStreamCipher streamCipher;
    private int position;

    public XmlProtectedValueTransformer(@NotNull SkippingStreamCipher streamCipher) {
        Intrinsics.checkNotNullParameter((Object)streamCipher, (String)"streamCipher");
        this.streamCipher = streamCipher;
    }

    public final void processEntries(@NotNull Element parentElement) {
        Intrinsics.checkNotNullParameter((Object)parentElement, (String)"parentElement");
        for (Content element : parentElement.getContent()) {
            if (!(element instanceof Element)) continue;
            if (Intrinsics.areEqual((Object)((Element)element).getName(), (Object)"Group")) {
                this.processEntries((Element)element);
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Element)element).getName(), (Object)"Entry")) continue;
            for (Element container : ((Element)element).getChildren("String")) {
                Element valueElement;
                if (container.getChild("Value") == null || !ProtectedValueKt.isValueProtected(valueElement)) continue;
                byte[] value = Base64.getDecoder().decode(valueElement.getText());
                Intrinsics.checkNotNull((Object)value);
                valueElement.setContent((Content)new ProtectedValue(value, this.position, this.streamCipher));
                this.position += value.length;
            }
        }
    }
}

