/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreBundle;
import com.intellij.credentialStore.CredentialStoreFactory;
import com.intellij.credentialStore.CredentialStoreManager;
import com.intellij.credentialStore.CredentialStoreUiService;
import com.intellij.credentialStore.PasswordSafeOptions;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.kdbx.IncorrectMainPasswordException;
import com.intellij.credentialStore.keePass.InMemoryCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.TestPasswordSafeImpl;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsContexts;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\n\u0010\b\u001a\u0004\u0018\u00010\u0005H\u0007\u001a\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u000e"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "computeProvider", "Lcom/intellij/credentialStore/CredentialStore;", "settings", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "createPersistentCredentialStore", "createKeePassStore", "Lcom/intellij/ide/passwordSafe/PasswordSafe;", "dbFile", "Ljava/nio/file/Path;", "mainPasswordFile", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nPasswordSafeImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordSafeImpl.kt\ncom/intellij/ide/passwordSafe/impl/PasswordSafeImplKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n13#2:255\n1#3:256\n*S KotlinDebug\n*F\n+ 1 PasswordSafeImpl.kt\ncom/intellij/ide/passwordSafe/impl/PasswordSafeImplKt\n*L\n30#1:255\n*E\n"})
public final class PasswordSafeImplKt {
    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(CredentialStore.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private static final CredentialStore computeProvider(PasswordSafeSettings settings) {
        block20: {
            block16: {
                block17: {
                    block15: {
                        block14: {
                            if (settings.getProviderType() == ProviderType.MEMORY_ONLY) break block14;
                            Application application = ApplicationManager.getApplication();
                            boolean bl = application != null ? application.isUnitTestMode() : false;
                            if (!bl) break block15;
                        }
                        return new InMemoryCredentialStore();
                    }
                    if (!CredentialStoreManager.Companion.getInstance().isSupported(settings.getProviderType())) break block16;
                    if (settings.getProviderType() != ProviderType.KEEPASS) break block17;
                    try {
                        Object object;
                        block19: {
                            block18: {
                                object = settings.getKeepassDb();
                                if (object == null) break block18;
                                String it = object;
                                boolean bl = false;
                                Path path = Paths.get(it, new String[0]);
                                object = path;
                                if (path != null) break block19;
                            }
                            object = KeePassCredentialStoreKt.getDefaultDbFile();
                        }
                        Object dbFile = object;
                        return new KeePassCredentialStore((Path)dbFile, KeePassCredentialStoreKt.getDefaultMainPasswordFile());
                    }
                    catch (IncorrectMainPasswordException e) {
                        PasswordSafeImplKt.getLOG().warn((Throwable)e);
                        PasswordSafeImplKt.computeProvider$showError(e.isFileMissed() ? CredentialStoreBundle.INSTANCE.message("notification.title.password.missing", new Object[0]) : CredentialStoreBundle.INSTANCE.message("notification.title.password.incorrect", new Object[0]));
                    }
                    catch (ProcessCanceledException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        PasswordSafeImplKt.getLOG().error(e);
                        PasswordSafeImplKt.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.database.error", new Object[0]));
                    }
                    break block20;
                }
                try {
                    CredentialStore store = PasswordSafeImplKt.createPersistentCredentialStore();
                    if (store != null) {
                        return store;
                    }
                    PasswordSafeImplKt.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.keychain.not.available", new Object[0]));
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    PasswordSafeImplKt.getLOG().error(e);
                    PasswordSafeImplKt.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.cannot.use.keychain", new Object[0]));
                }
                break block20;
            }
            PasswordSafeImplKt.getLOG().error("Provider " + settings.getProviderType() + " is not supported in this environment");
            Object[] objectArray = new Object[]{settings.getProviderType()};
            PasswordSafeImplKt.computeProvider$showError(CredentialStoreBundle.INSTANCE.message("notification.title.cannot.use.provider", objectArray));
        }
        settings.setProviderType(ProviderType.MEMORY_ONLY);
        return new InMemoryCredentialStore();
    }

    @ApiStatus.Internal
    @Nullable
    public static final CredentialStore createPersistentCredentialStore() {
        for (CredentialStoreFactory factory : CredentialStoreFactory.CREDENTIAL_STORE_FACTORY.getExtensionList()) {
            CredentialStore credentialStore = factory.create();
            if (credentialStore == null) continue;
            return credentialStore;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @TestOnly
    @ApiStatus.Internal
    @NotNull
    public static final PasswordSafe createKeePassStore(@NotNull Path dbFile, @NotNull Path mainPasswordFile) {
        void $this$createKeePassStore_u24lambda_u240;
        PasswordSafeOptions passwordSafeOptions;
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)mainPasswordFile, (String)"mainPasswordFile");
        KeePassCredentialStore store = new KeePassCredentialStore(dbFile, mainPasswordFile);
        PasswordSafeSettings settings = new PasswordSafeSettings();
        PasswordSafeOptions passwordSafeOptions2 = passwordSafeOptions = new PasswordSafeOptions();
        PasswordSafeSettings passwordSafeSettings = settings;
        boolean bl = false;
        $this$createKeePassStore_u24lambda_u240.setProvider(ProviderType.KEEPASS);
        $this$createKeePassStore_u24lambda_u240.setKeepassDb(((Object)store.getDbFile$intellij_platform_credentialStore_impl()).toString());
        passwordSafeSettings.loadState(passwordSafeOptions);
        return new TestPasswordSafeImpl(settings, store);
    }

    private static final void computeProvider$showError(@NlsContexts.NotificationTitle String title) {
        CredentialStoreUiService.Companion.getInstance().notify(title, CredentialStoreBundle.INSTANCE.message("notification.content.in.memory.storage", new Object[0]), null, NotificationAction.createExpiring((String)CredentialStoreBundle.INSTANCE.message("notification.content.password.settings.action", new Object[0]), (arg_0, arg_1) -> PasswordSafeImplKt.computeProvider$showError$lambda$1(PasswordSafeImplKt::computeProvider$showError$lambda$0, arg_0, arg_1)));
    }

    private static final Unit computeProvider$showError$lambda$0(AnActionEvent e, Notification notification) {
        CredentialStoreUiService.Companion.getInstance().openSettings(e.getProject());
        return Unit.INSTANCE;
    }

    private static final void computeProvider$showError$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return PasswordSafeImplKt.getLOG();
    }

    public static final /* synthetic */ CredentialStore access$computeProvider(PasswordSafeSettings settings) {
        return PasswordSafeImplKt.computeProvider(settings);
    }
}

