/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.MacOsKeychainLibrary;
import com.intellij.credentialStore.MacOsKeychainLibraryKt;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.credentialStore.OneTimeStringKt;
import com.intellij.credentialStore.SecKeychainAttribute;
import com.intellij.credentialStore.SecKeychainAttributeList;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.StringKt;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0002J\u001b\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0096\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/credentialStore/KeyChainCredentialStore;", "Lcom/intellij/credentialStore/CredentialStore;", "<init>", "()V", "get", "Lcom/intellij/credentialStore/Credentials;", "attributes", "Lcom/intellij/credentialStore/CredentialAttributes;", "set", "", "credentials", "Companion", "intellij.platform.credentialStore.impl"})
public final class KeyChainCredentialStore
implements CredentialStore {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final MacOsKeychainLibrary library = (MacOsKeychainLibrary)Native.load((String)"Security", MacOsKeychainLibrary.class);

    @Nullable
    public Credentials get(@NotNull CredentialAttributes attributes) {
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        String string = attributes.getServiceName();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        return KeyChainCredentialStore.Companion.findGenericPassword(byArray, StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null));
    }

    /*
     * Unable to fully structure code
     */
    public void set(@NotNull CredentialAttributes attributes, @Nullable Credentials credentials) {
        block16: {
            Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
            var4_3 = attributes.getServiceName();
            v0 = var4_3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getBytes(...)");
            serviceName = v0;
            if (CredentialAttributesKt.isEmpty((Credentials)credentials)) {
                itemRef = new PointerByReference();
                v1 = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
                if (v1 != null) {
                    var7_5 = v1;
                    v2 = var7_5.getBytes(Charsets.UTF_8);
                    v3 = v2;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getBytes(...)");
                } else {
                    v3 = null;
                }
                userName = v3;
                code = KeyChainCredentialStore.library.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, userName != null ? userName.length : 0, userName, null, null, itemRef);
                switch (code) {
                    case -67701: 
                    case -25300: {
                        return;
                    }
                }
                com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "find (for delete)", code);
                v4 = itemRef.getValue();
                if (v4 != null) {
                    it = v4;
                    $i$a$-let-KeyChainCredentialStore$set$1 = false;
                    com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "delete", KeyChainCredentialStore.library.SecKeychainItemDelete(it));
                    KeyChainCredentialStore.library.CFRelease(it);
                }
                return;
            }
            v5 = StringKt.nullize$default((String)attributes.getUserName(), (boolean)false, (int)1, null);
            if (v5 == null) {
                v6 = credentials;
                Intrinsics.checkNotNull((Object)v6);
                v5 = v6.getUserName();
            }
            if (v5 != null) {
                code = v5;
                v7 = code.getBytes(Charsets.UTF_8);
                v8 = v7;
                Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"getBytes(...)");
            } else {
                v8 = null;
            }
            userName = v8;
            searchUserName = (byte[])(Intrinsics.areEqual((Object)attributes.getServiceName(), (Object)"IntelliJ Platform") != false ? userName : null);
            itemRef = new PointerByReference();
            library = KeyChainCredentialStore.library;
            com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "find (for save)", library.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, searchUserName != null ? searchUserName.length : 0, searchUserName, null, null, itemRef));
            if (attributes.isPasswordMemoryOnly()) ** GOTO lbl-1000
            v9 = credentials;
            Intrinsics.checkNotNull((Object)v9);
            if (v9.getPassword() == null) lbl-1000:
            // 2 sources

            {
                v10 = null;
            } else {
                v11 = credentials.getPassword();
                Intrinsics.checkNotNull((Object)v11);
                v10 = v11.toByteArray(false);
            }
            password = v10;
            pointer = itemRef.getValue();
            if (pointer == null) {
                Intrinsics.checkNotNull((Object)library);
                com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "save (new)", MacOsKeychainLibrary.SecKeychainAddGenericPassword$default(library, null, serviceName.length, serviceName, userName != null ? userName.length : 0, userName, password != null ? password.length : 0, password, null, 128, null));
            } else {
                attribute = new SecKeychainAttribute();
                attribute.tag = 1633903476;
                v12 = attribute.length = userName != null ? userName.length : 0;
                if (userName != null && userName.length == 0 == false) {
                    userNamePointer = new Memory((long)userName.length);
                    userNamePointer.write(0L, userName, 0, userName.length);
                    attribute.data = (Pointer)userNamePointer;
                }
                attributeList = new SecKeychainAttributeList();
                attributeList.count = 1;
                attribute.write();
                attributeList.attr = attribute.getPointer();
                v13 = password != null ? password.length : 0;
                v14 = password;
                if (password == null) {
                    v14 = ArrayUtilRt.EMPTY_BYTE_ARRAY;
                }
                com.intellij.credentialStore.KeyChainCredentialStore$Companion.access$checkForError(KeyChainCredentialStore.Companion, "save (update)", library.SecKeychainItemModifyContent(pointer, (Object)attributeList, v13, v14));
                library.CFRelease(pointer);
            }
            if (password == null) break block16;
            ArraysKt.fill$default((byte[])password, (byte)0, (int)0, (int)0, (int)6, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/credentialStore/KeyChainCredentialStore$Companion;", "", "<init>", "()V", "library", "Lcom/intellij/credentialStore/MacOsKeychainLibrary;", "kotlin.jvm.PlatformType", "findGenericPassword", "Lcom/intellij/credentialStore/Credentials;", "serviceName", "", "accountName", "", "checkForError", "", "message", "code", "intellij.platform.credentialStore.impl"})
    @SourceDebugExtension(value={"SMAP\nmacOsKeychainLibrary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 macOsKeychainLibrary.kt\ncom/intellij/credentialStore/KeyChainCredentialStore$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Credentials findGenericPassword(byte[] serviceName, String accountName) {
            byte[] byArray;
            String string = accountName;
            if (string != null) {
                String string2 = string;
                byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
                byArray = byArray2;
                Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            } else {
                byArray = null;
            }
            byte[] accountNameBytes = byArray;
            int[] passwordSize = new int[1];
            PointerByReference passwordRef = new PointerByReference();
            PointerByReference itemRef = new PointerByReference();
            int errorCode = this.checkForError("find", library.SecKeychainFindGenericPassword(null, serviceName.length, serviceName, accountNameBytes != null ? accountNameBytes.length : 0, accountNameBytes, passwordSize, passwordRef, itemRef));
            try {
                Pointer pointer;
                if (errorCode == -128) {
                    Credentials credentials = CredentialAttributesKt.getACCESS_TO_KEY_CHAIN_DENIED();
                    return credentials;
                }
                if (errorCode == -25293) {
                    Credentials credentials = CredentialAttributesKt.getCANNOT_UNLOCK_KEYCHAIN();
                    return credentials;
                }
                if (passwordRef.getValue() == null) {
                    Credentials credentials = null;
                    return credentials;
                }
                Pointer pointer2 = pointer;
                byte[] byArray3 = pointer2.getByteArray(0L, passwordSize[0]);
                Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getByteArray(...)");
                OneTimeString password = OneTimeStringKt.OneTimeString$default((byte[])byArray3, (int)0, (int)0, (boolean)false, (int)14, null);
                library.SecKeychainItemFreeContent(null, pointer2);
                String effectiveAccountName = accountName;
                if (effectiveAccountName == null) {
                    PointerByReference attributes = new PointerByReference();
                    MacOsKeychainLibrary macOsKeychainLibrary = library;
                    Pointer pointer3 = itemRef.getValue();
                    Intrinsics.checkNotNull((Object)pointer3);
                    int[] nArray = new int[]{1633903476};
                    this.checkForError("SecKeychainItemCopyAttributesAndData", macOsKeychainLibrary.SecKeychainItemCopyAttributesAndData(pointer3, MacOsKeychainLibraryKt.access$SecKeychainAttributeInfo(nArray), null, attributes, null, null));
                    Pointer pointer4 = attributes.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)pointer4, (String)"getValue(...)");
                    SecKeychainAttributeList attributeList = new SecKeychainAttributeList(pointer4);
                    try {
                        attributeList.read();
                        effectiveAccountName = (String)MacOsKeychainLibraryKt.access$readAttributes(attributeList).get(1633903476);
                    }
                    finally {
                        library.SecKeychainItemFreeAttributesAndData(attributeList, null);
                    }
                }
                Credentials credentials = new Credentials(effectiveAccountName, password);
                return credentials;
            }
            finally {
                block16: {
                    Pointer pointer = itemRef.getValue();
                    if (pointer == null) break block16;
                    Pointer it = pointer;
                    boolean bl = false;
                    library.CFRelease(it);
                }
            }
        }

        private final int checkForError(String message, int code) {
            switch (code) {
                case -25300: 
                case 0: {
                    return code;
                }
            }
            Pointer translated = library.SecCopyErrorMessageString(code, null);
            StringBuilder builder = new StringBuilder(message).append(": ");
            if (translated == null) {
                v0 = builder.append(code);
            } else {
                char[] buf = new char[(int)library.CFStringGetLength(translated)];
                int n = buf.length;
                for (int i = 0; i < n; ++i) {
                    buf[i] = library.CFStringGetCharacterAtIndex(translated, i);
                }
                library.CFRelease(translated);
                v0 = builder.append(buf).append(" (").append(code).append(')');
            }
            switch (code) {
                case -25299: 
                case -25293: 
                case -128: {
                    CredentialStoreKt.getLOG().warn(builder.toString());
                    break;
                }
                default: {
                    CredentialStoreKt.getLOG().error(builder.toString());
                }
            }
            return code;
        }

        public static final /* synthetic */ int access$checkForError(Companion $this, String message, int code) {
            return $this.checkForError(message, code);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

