/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupport;
import com.intellij.credentialStore.gpg.Pgp;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/credentialStore/PgpKeyEncryptionSupport;", "Lcom/intellij/credentialStore/EncryptionSupport;", "encryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "<init>", "(Lcom/intellij/credentialStore/EncryptionSpec;)V", "encrypt", "", "data", "decrypt", "intellij.platform.credentialStore.impl"})
final class PgpKeyEncryptionSupport
implements EncryptionSupport {
    @NotNull
    private final EncryptionSpec encryptionSpec;

    public PgpKeyEncryptionSupport(@NotNull EncryptionSpec encryptionSpec) {
        Intrinsics.checkNotNullParameter((Object)encryptionSpec, (String)"encryptionSpec");
        this.encryptionSpec = encryptionSpec;
    }

    @Override
    @NotNull
    public byte[] encrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Pgp pgp = new Pgp(null, 1, null);
        String string = this.encryptionSpec.getPgpKeyId();
        Intrinsics.checkNotNull((Object)string);
        return pgp.encrypt(data, string);
    }

    @Override
    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return new Pgp(null, 1, null).decrypt(data);
    }
}

