/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.kdbx;

import com.intellij.configurationStore.JbXmlOutputter;
import com.intellij.credentialStore.kdbx.ProtectedValue;
import com.intellij.credentialStore.kdbx.SecureString;
import com.intellij.credentialStore.kdbx.UnsavedProtectedValue;
import java.io.Writer;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.bouncycastle.crypto.SkippingStreamCipher;
import org.jdom.Content;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/credentialStore/kdbx/ProtectedXmlWriter;", "Lcom/intellij/configurationStore/JbXmlOutputter;", "streamCipher", "Lorg/bouncycastle/crypto/SkippingStreamCipher;", "<init>", "(Lorg/bouncycastle/crypto/SkippingStreamCipher;)V", "writeContent", "", "out", "Ljava/io/Writer;", "element", "Lorg/jdom/Element;", "level", "", "substituteMacro", "intellij.platform.credentialStore.impl"})
public final class ProtectedXmlWriter
extends JbXmlOutputter {
    @NotNull
    private final SkippingStreamCipher streamCipher;

    public ProtectedXmlWriter(@NotNull SkippingStreamCipher streamCipher) {
        Intrinsics.checkNotNullParameter((Object)streamCipher, (String)"streamCipher");
        super(null, null, null, null, false, null, 47, null);
        this.streamCipher = streamCipher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writeContent(@NotNull Writer out, @NotNull Element element, int level, boolean substituteMacro) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!Intrinsics.areEqual((Object)element.getName(), (Object)"Value")) {
            return super.writeContent(out, element, level, substituteMacro);
        }
        List list = element.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContent(...)");
        Content value = (Content)CollectionsKt.firstOrNull((List)list);
        if (value instanceof SecureString) {
            Object protectedValue = null;
            if (value instanceof ProtectedValue) {
                ((ProtectedValue)value).setNewStreamCipher(this.streamCipher);
                protectedValue = value;
            } else {
                byte[] bytes = ((UnsavedProtectedValue)value).getSecureString().getAsByteArray();
                SkippingStreamCipher skippingStreamCipher = this.streamCipher;
                synchronized (skippingStreamCipher) {
                    boolean bl = false;
                    int position = (int)this.streamCipher.getPosition();
                    this.streamCipher.processBytes(bytes, 0, bytes.length, bytes, 0);
                    protectedValue = new ProtectedValue(bytes, position, this.streamCipher);
                    Unit unit = Unit.INSTANCE;
                }
                element.setContent(protectedValue);
            }
            out.write(62);
            out.write(JbXmlOutputter.Companion.escapeElementEntities(((ProtectedValue)protectedValue).encodeToBase64()));
            return true;
        }
        return super.writeContent(out, element, level, substituteMacro);
    }
}

