/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore.keePass;

import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.kdbx.IncorrectMainPasswordException;
import com.intellij.credentialStore.kdbx.KdbxKt;
import com.intellij.credentialStore.kdbx.KdbxPassword;
import com.intellij.credentialStore.kdbx.KeePassDatabase;
import com.intellij.credentialStore.keePass.BaseKeePassCredentialStore;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.MainKey;
import com.intellij.credentialStore.keePass.MainKeyFileStorage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.ApplicationKt;
import com.intellij.util.io.PathKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.io.Closeable;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\t\u0010\fJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u001cJ\u0006\u0010!\u001a\u00020\u001cJ\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007J\b\u0010'\u001a\u00020\u001cH\u0014J\b\u0010(\u001a\u00020\u001cH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\bX\u0094\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006)"}, d2={"Lcom/intellij/credentialStore/keePass/KeePassCredentialStore;", "Lcom/intellij/credentialStore/keePass/BaseKeePassCredentialStore;", "Ljava/io/Closeable;", "dbFile", "Ljava/nio/file/Path;", "mainKeyStorage", "Lcom/intellij/credentialStore/keePass/MainKeyFileStorage;", "preloadedDb", "Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "<init>", "(Ljava/nio/file/Path;Lcom/intellij/credentialStore/keePass/MainKeyFileStorage;Lcom/intellij/credentialStore/kdbx/KeePassDatabase;)V", "mainKeyFile", "(Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "getDbFile$intellij_platform_credentialStore_impl", "()Ljava/nio/file/Path;", "isNeedToSave", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastSavedTimestamp", "", "messageBusConnection", "Lcom/intellij/util/messages/SimpleMessageBusConnection;", "db", "getDb", "()Lcom/intellij/credentialStore/kdbx/KeePassDatabase;", "setDb", "(Lcom/intellij/credentialStore/kdbx/KeePassDatabase;)V", "getMainKeyFile", "reload", "", "save", "mainKeyEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "deleteFileStorage", "clear", "setMainPassword", "mainKey", "Lcom/intellij/credentialStore/keePass/MainKey;", "secureRandom", "Ljava/security/SecureRandom;", "markDirty", "close", "intellij.platform.credentialStore.impl"})
@SourceDebugExtension(value={"SMAP\nKeePassCredentialStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeePassCredentialStore.kt\ncom/intellij/credentialStore/keePass/KeePassCredentialStore\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,183:1\n13#2:184\n*S KotlinDebug\n*F\n+ 1 KeePassCredentialStore.kt\ncom/intellij/credentialStore/keePass/KeePassCredentialStore\n*L\n125#1:184\n*E\n"})
public final class KeePassCredentialStore
extends BaseKeePassCredentialStore
implements Closeable {
    @NotNull
    private final Path dbFile;
    @NotNull
    private final MainKeyFileStorage mainKeyStorage;
    @NotNull
    private final AtomicBoolean isNeedToSave;
    private volatile long lastSavedTimestamp;
    @NotNull
    private final SimpleMessageBusConnection messageBusConnection;
    @NotNull
    private KeePassDatabase db;

    public KeePassCredentialStore(@NotNull Path dbFile, @NotNull MainKeyFileStorage mainKeyStorage, @Nullable KeePassDatabase preloadedDb) {
        KeePassDatabase keePassDatabase;
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)mainKeyStorage, (String)"mainKeyStorage");
        super(null);
        this.dbFile = dbFile;
        this.mainKeyStorage = mainKeyStorage;
        this.messageBusConnection = ApplicationKt.getApplication().getMessageBus().simpleConnect();
        if (preloadedDb == null) {
            this.isNeedToSave = new AtomicBoolean(false);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(this.dbFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                byte[] byArray = this.mainKeyStorage.load();
                if (byArray == null) {
                    throw new IncorrectMainPasswordException(true);
                }
                byte[] mainPassword = byArray;
                LocalFileSystem.getInstance().refreshAndFindFileByPath(((Object)this.dbFile).toString());
                keePassDatabase = KdbxKt.loadKdbx(this.dbFile, KdbxPassword.Companion.createAndClear(mainPassword));
            } else {
                keePassDatabase = new KeePassDatabase(null, 1, null);
            }
        } else {
            this.isNeedToSave = new AtomicBoolean(true);
            keePassDatabase = preloadedDb;
        }
        this.db = keePassDatabase;
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        this.messageBusConnection.subscribe(topic, (Object)new BulkFileListener(){

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void after(List<? extends VFileEvent> events) {
                boolean bl;
                void $this$any$iv;
                Intrinsics.checkNotNullParameter(events, (String)"events");
                Iterable iterable = events;
                KeePassCredentialStore keePassCredentialStore = this;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    return;
                }
                Iterator iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return;
                    Object element$iv = iterator.next();
                    VFileEvent it = (VFileEvent)element$iv;
                    boolean bl2 = false;
                    if (it instanceof VFileContentChangeEvent || it instanceof VFileCreateEvent) {
                        String string = it.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        if (Intrinsics.areEqual((Object)NioPathUtil.toNioPathOrNull((String)string), (Object)keePassCredentialStore.getDbFile$intellij_platform_credentialStore_impl())) {
                            bl = true;
                            continue;
                        }
                    }
                    bl = false;
                } while (!bl);
                boolean bl3 = true;
                if (!bl3) return;
                long currentTimestamp = Files.getLastModifiedTime(this.getDbFile$intellij_platform_credentialStore_impl(), new LinkOption[0]).toMillis();
                if (currentTimestamp <= lastSavedTimestamp) return;
                try {
                    this.reload();
                    return;
                }
                catch (Throwable e) {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KeePassCredentialStore.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Cannot reload KeePass database on external change", e);
                }
            }
        });
    }

    public /* synthetic */ KeePassCredentialStore(Path path, MainKeyFileStorage mainKeyFileStorage, KeePassDatabase keePassDatabase, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            keePassDatabase = null;
        }
        this(path, mainKeyFileStorage, keePassDatabase);
    }

    @NotNull
    public final Path getDbFile$intellij_platform_credentialStore_impl() {
        return this.dbFile;
    }

    public KeePassCredentialStore(@NotNull Path dbFile, @NotNull Path mainKeyFile) {
        Intrinsics.checkNotNullParameter((Object)dbFile, (String)"dbFile");
        Intrinsics.checkNotNullParameter((Object)mainKeyFile, (String)"mainKeyFile");
        this(dbFile, new MainKeyFileStorage(mainKeyFile), null);
    }

    @Override
    @NotNull
    protected KeePassDatabase getDb() {
        return this.db;
    }

    protected void setDb(@NotNull KeePassDatabase keePassDatabase) {
        Intrinsics.checkNotNullParameter((Object)keePassDatabase, (String)"<set-?>");
        this.db = keePassDatabase;
    }

    @NotNull
    public final Path getMainKeyFile() {
        return this.mainKeyStorage.passwordFile;
    }

    public final synchronized void reload() {
        byte[] byArray = this.mainKeyStorage.load();
        if (byArray == null) {
            throw new IllegalStateException("Main key file is missing");
        }
        byte[] key = byArray;
        KdbxPassword kdbxPassword = new KdbxPassword(key);
        ArraysKt.fill$default((byte[])key, (byte)0, (int)0, (int)0, (int)6, null);
        this.setDb(KdbxKt.loadKdbx(this.dbFile, kdbxPassword));
        this.isNeedToSave.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void save(@NotNull EncryptionSpec mainKeyEncryptionSpec) {
        Intrinsics.checkNotNullParameter((Object)mainKeyEncryptionSpec, (String)"mainKeyEncryptionSpec");
        if (!this.isNeedToSave.compareAndSet(true, false) && !this.getDb().isDirty()) {
            return;
        }
        try {
            SecureRandom secureRandom = CredentialStoreKt.createSecureRandom();
            byte[] mainKey = this.mainKeyStorage.load();
            KdbxPassword kdbxPassword = null;
            if (mainKey == null) {
                MainKey key = KeePassCredentialStoreKt.generateRandomMainKey(mainKeyEncryptionSpec, secureRandom);
                byte[] byArray = key.getValue();
                Intrinsics.checkNotNull((Object)byArray);
                kdbxPassword = new KdbxPassword(byArray);
                this.mainKeyStorage.save(key);
            } else {
                kdbxPassword = new KdbxPassword(mainKey);
                ArraysKt.fill$default((byte[])mainKey, (byte)0, (int)0, (int)0, (int)6, null);
            }
            Closeable closeable = PathKt.safeOutputStream((Path)this.dbFile);
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                this.getDb().save$intellij_platform_credentialStore_impl(kdbxPassword, it, secureRandom);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            this.lastSavedTimestamp = Files.getLastModifiedTime(this.dbFile, new LinkOption[0]).toMillis();
        }
        catch (Throwable e) {
            this.isNeedToSave.set(true);
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KeePassCredentialStore.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot save password database", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void deleteFileStorage() {
        try {
            PathKt.delete$default((Path)this.dbFile, (boolean)false, (int)1, null);
        }
        finally {
            this.mainKeyStorage.save(null);
        }
    }

    public final void clear() {
        this.getDb().getRootGroup$intellij_platform_credentialStore_impl().removeGroup("IntelliJ Platform");
        this.isNeedToSave.set(this.getDb().isDirty());
    }

    @TestOnly
    public final void setMainPassword(@NotNull MainKey mainKey, @NotNull SecureRandom secureRandom) {
        Intrinsics.checkNotNullParameter((Object)mainKey, (String)"mainKey");
        Intrinsics.checkNotNullParameter((Object)secureRandom, (String)"secureRandom");
        KeePassCredentialStoreKt.saveDatabase(this.dbFile, this.getDb(), mainKey, this.mainKeyStorage, secureRandom);
    }

    @Override
    protected void markDirty() {
        this.isNeedToSave.set(true);
    }

    @Override
    public void close() {
        this.messageBusConnection.disconnect();
    }
}

