/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import org.jetbrains.annotations.NotNull;

public abstract class XDebuggerActionBase
extends AnAction {
    private final boolean myHideDisabledInPopup;

    protected XDebuggerActionBase() {
        this(false);
    }

    protected XDebuggerActionBase(boolean hideDisabledInPopup) {
        this.myHideDisabledInPopup = hideDisabledInPopup;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            XDebuggerActionBase.$$$reportNull$$$0(0);
        }
        Presentation presentation = event.getPresentation();
        boolean hidden = this.isHidden(event);
        if (hidden) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        boolean enabled = this.isEnabled(event);
        if (this.myHideDisabledInPopup && event.isFromContextMenu()) {
            presentation.setVisible(enabled);
        } else {
            presentation.setVisible(true);
        }
        presentation.setEnabled(enabled);
    }

    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            XDebuggerActionBase.$$$reportNull$$$0(1);
        }
        if ((project = e.getProject()) != null && !project.isDisposed()) {
            DebuggerSupport support = new DebuggerSupport();
            return this.isEnabled(project, e, support);
        }
        return false;
    }

    @NotNull
    protected abstract DebuggerActionHandler getHandler(@NotNull DebuggerSupport var1);

    private boolean isEnabled(Project project, AnActionEvent event, DebuggerSupport support) {
        return this.getHandler(support).isEnabled(project, event);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            XDebuggerActionBase.$$$reportNull$$$0(2);
        }
        XDebuggerUtilImpl.performDebuggerAction(e, () -> this.performWithHandler(e));
    }

    protected boolean performWithHandler(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            XDebuggerActionBase.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null || project.isDisposed()) {
            return true;
        }
        DebuggerSupport support = new DebuggerSupport();
        if (this.isEnabled(project, e, support)) {
            this.perform(project, e, support);
            return true;
        }
        return false;
    }

    private void perform(@NotNull Project project, @NotNull AnActionEvent e, @NotNull DebuggerSupport support) {
        if (project == null) {
            XDebuggerActionBase.$$$reportNull$$$0(4);
        }
        if (e == null) {
            XDebuggerActionBase.$$$reportNull$$$0(5);
        }
        if (support == null) {
            XDebuggerActionBase.$$$reportNull$$$0(6);
        }
        this.getHandler(support).perform(project, e);
    }

    protected boolean isHidden(@NotNull AnActionEvent event) {
        Project project;
        if (event == null) {
            XDebuggerActionBase.$$$reportNull$$$0(7);
        }
        if ((project = event.getProject()) != null && !project.isDisposed()) {
            DebuggerSupport support = new DebuggerSupport();
            return this.getHandler(support).isHidden(project, event);
        }
        return true;
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            XDebuggerActionBase.$$$reportNull$$$0(8);
        }
        return actionUpdateThread;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "support";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/XDebuggerActionBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/XDebuggerActionBase";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performWithHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }
}

