/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.editor.markup.GutterDraggableObject;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.EditBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.CommonBreakpointGutterIconRenderer;
import com.intellij.xdebugger.impl.breakpoints.RemoveBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.ToggleBreakpointGutterIconAction;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.util.MonolithUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BreakpointGutterIconRenderer
extends CommonBreakpointGutterIconRenderer
implements DumbAware {
    private final XBreakpointProxy myBreakpoint;

    @ApiStatus.Internal
    public BreakpointGutterIconRenderer(XBreakpointProxy breakpoint2) {
        this.myBreakpoint = breakpoint2;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = this.myBreakpoint.getIcon();
        if (icon == null) {
            BreakpointGutterIconRenderer.$$$reportNull$$$0(0);
        }
        return icon;
    }

    @NotNull
    public String getAccessibleName() {
        String string = XDebuggerBundle.message((String)"accessible.name.icon.0.1.2", (Object[])new Object[]{this.myBreakpoint.getType().getTitle(), this.myBreakpoint.getConditionExpression() != null ? " " + XDebuggerBundle.message((String)"accessible.name.icon.conditional", (Object[])new Object[0]) : "", !this.myBreakpoint.isEnabled() ? " " + XDebuggerBundle.message((String)"accessible.name.icon.disabled", (Object[])new Object[0]) : ""});
        if (string == null) {
            BreakpointGutterIconRenderer.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public AnAction getClickAction() {
        if (Registry.is((String)"debugger.click.disable.breakpoints")) {
            return new ToggleBreakpointGutterIconAction(this.myBreakpoint);
        }
        return new RemoveBreakpointGutterIconAction(this.myBreakpoint);
    }

    @NotNull
    public AnAction getMiddleButtonClickAction() {
        if (!Registry.is((String)"debugger.click.disable.breakpoints")) {
            return new ToggleBreakpointGutterIconAction(this.myBreakpoint);
        }
        return new RemoveBreakpointGutterIconAction(this.myBreakpoint);
    }

    @NotNull
    public AnAction getRightButtonClickAction() {
        return new EditBreakpointAction.ContextAction(this, this.myBreakpoint);
    }

    @Nullable
    public ActionGroup getPopupMenuActions() {
        XDebugSessionProxy currentSessionProxy = XDebugManagerProxy.getInstance().getCurrentSessionProxy(this.myBreakpoint.getProject());
        if (currentSessionProxy != null) {
            XDebugSessionImpl debugSession = MonolithUtils.findSessionById(currentSessionProxy.getId());
            XBreakpointBase<?, ?, ?> breakpoint2 = MonolithUtils.findBreakpointById(this.myBreakpoint.getId());
            if (debugSession != null && breakpoint2 != null) {
                return new DefaultActionGroup(breakpoint2.getAdditionalPopupMenuActions(debugSession));
            }
        }
        return super.getPopupMenuActions();
    }

    @NotNull
    public String getTooltipText() {
        String string = this.myBreakpoint.getTooltipDescription();
        if (string == null) {
            BreakpointGutterIconRenderer.$$$reportNull$$$0(2);
        }
        return string;
    }

    public GutterDraggableObject getDraggableObject() {
        return this.myBreakpoint.createBreakpointDraggableObject();
    }

    XBreakpointProxy getBreakpoint() {
        return this.myBreakpoint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BreakpointGutterIconRenderer)) return false;
        BreakpointGutterIconRenderer renderer = (BreakpointGutterIconRenderer)((Object)obj);
        if (!this.myBreakpoint.equals(renderer.myBreakpoint)) return false;
        if (!Comparing.equal((Object)this.getIcon(), (Object)renderer.getIcon())) return false;
        return true;
    }

    public int hashCode() {
        return this.getBreakpoint().hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xdebugger/impl/breakpoints/BreakpointGutterIconRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTooltipText";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

