/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.idea.AppMode;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.rpc.topics.ProjectRemoteTopicKt;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.impl.breakpoints.ShowBreakpointDialogRemoteTopicKt;
import com.intellij.xdebugger.impl.breakpoints.ShowBreakpointDialogRequest;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialog;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.rpc.XBreakpointId;
import java.awt.Window;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u0015J\u0014\u0010\u0016\u001a\u00020\u00102\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0018J\u0010\u0010\u0016\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u001aH\u0007J\b\u0010\u001c\u001a\u00020\u0010H\u0002J\u0012\u0010\u001d\u001a\u00020\u00142\b\u0010\u0017\u001a\u0004\u0018\u00010\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0004\u0018\u00010\n8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialogFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "balloonToHide", "Lcom/intellij/openapi/ui/popup/Balloon;", "breakpointFromBalloon", "showingDialog", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog;", "getShowingDialog", "()Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog;", "setShowingDialog", "(Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialog;)V", "setBalloonToHide", "", "balloon", "breakpoint", "popupRequested", "", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointProxy;", "showDialog", "initialBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "initialBreakpointId", "Lcom/intellij/xdebugger/impl/rpc/XBreakpointId;", "showDialogImpl", "hideBalloon", "selectInDialogShowing", "Companion", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class BreakpointsDialogFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Balloon balloonToHide;
    @Nullable
    private Object breakpointFromBalloon;
    @VisibleForTesting
    @Nullable
    private BreakpointsDialog showingDialog;

    public BreakpointsDialogFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final BreakpointsDialog getShowingDialog() {
        return this.showingDialog;
    }

    public final void setShowingDialog(@Nullable BreakpointsDialog breakpointsDialog) {
        this.showingDialog = breakpointsDialog;
    }

    public final void setBalloonToHide(@NotNull Balloon balloon, @Nullable Object breakpoint2) {
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        this.balloonToHide = balloon;
        this.breakpointFromBalloon = breakpoint2;
        Disposer.register((Disposable)((Disposable)balloon), () -> BreakpointsDialogFactory.setBalloonToHide$lambda$0(this, balloon));
    }

    public final boolean popupRequested(@Nullable XBreakpointProxy breakpoint2) {
        if (this.balloonToHide != null) {
            Balloon balloon = this.balloonToHide;
            Intrinsics.checkNotNull((Object)balloon);
            if (!balloon.isDisposed()) {
                return true;
            }
        }
        XBreakpointProxy xBreakpointProxy = breakpoint2;
        return this.selectInDialogShowing((XBreakpointId)(xBreakpointProxy != null ? xBreakpointProxy.getId() : null));
    }

    public final void showDialog(@Nullable XBreakpoint<?> initialBreakpoint) {
        XBreakpointBase xBreakpointBase = initialBreakpoint instanceof XBreakpointBase ? (XBreakpointBase)initialBreakpoint : null;
        XBreakpointId initialBreakpointId = xBreakpointBase != null ? xBreakpointBase.getBreakpointId() : null;
        this.showDialog(initialBreakpointId);
    }

    public final void showDialog(@Nullable XBreakpointId initialBreakpointId) {
        if (XDebugSessionProxy.Companion.useFeProxy() && AppMode.isRemoteDevHost()) {
            this.hideBalloon();
            ProjectRemoteTopicKt.sendToClient$default(ShowBreakpointDialogRemoteTopicKt.getSHOW_BREAKPOINT_DIALOG_REMOTE_TOPIC(), (Project)this.project, (Object)new ShowBreakpointDialogRequest(initialBreakpointId), null, (int)4, null);
            return;
        }
        this.showDialogImpl(initialBreakpointId);
    }

    @ApiStatus.Internal
    public final void showDialogImpl(@Nullable XBreakpointId initialBreakpoint) {
        if (this.selectInDialogShowing(initialBreakpoint)) {
            return;
        }
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.Companion.getInstance().getBreakpointManagerProxy(this.project);
        Project project = this.project;
        BreakpointsDialog dialog2 = new BreakpointsDialog(initialBreakpoint, breakpointManager, this, project){
            final /* synthetic */ BreakpointsDialogFactory this$0;
            {
                this.this$0 = $receiver;
                super($super_call_param$1, $initialBreakpoint, $breakpointManager);
            }

            protected void dispose() {
                BreakpointsDialogFactory.access$setBreakpointFromBalloon$p(this.this$0, null);
                this.this$0.setShowingDialog(null);
                super.dispose();
            }
        };
        this.hideBalloon();
        this.showingDialog = dialog2;
        dialog2.show();
    }

    private final void hideBalloon() {
        if (this.balloonToHide != null) {
            Balloon balloon = this.balloonToHide;
            Intrinsics.checkNotNull((Object)balloon);
            if (!balloon.isDisposed()) {
                Balloon balloon2 = this.balloonToHide;
                Intrinsics.checkNotNull((Object)balloon2);
                balloon2.hide();
            }
            this.balloonToHide = null;
        }
    }

    private final boolean selectInDialogShowing(XBreakpointId initialBreakpoint) {
        if (this.showingDialog != null) {
            BreakpointsDialog breakpointsDialog = this.showingDialog;
            Intrinsics.checkNotNull((Object)((Object)breakpointsDialog));
            Window window = breakpointsDialog.getWindow();
            if (window != null && window.isDisplayable()) {
                BreakpointsDialog breakpointsDialog2 = this.showingDialog;
                Intrinsics.checkNotNull((Object)((Object)breakpointsDialog2));
                breakpointsDialog2.selectBreakpoint(initialBreakpoint, true);
                BreakpointsDialog breakpointsDialog3 = this.showingDialog;
                Intrinsics.checkNotNull((Object)((Object)breakpointsDialog3));
                breakpointsDialog3.toFront();
                return true;
            }
        }
        return false;
    }

    private static final void setBalloonToHide$lambda$0(BreakpointsDialogFactory this$0, Balloon $balloon) {
        if (this$0.balloonToHide == $balloon) {
            this$0.balloonToHide = null;
            this$0.breakpointFromBalloon = null;
        }
    }

    @JvmStatic
    @NotNull
    public static final BreakpointsDialogFactory getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ void access$setBreakpointFromBalloon$p(BreakpointsDialogFactory $this, Object object) {
        $this.breakpointFromBalloon = object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialogFactory$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialogFactory;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.debugger.impl"})
    @SourceDebugExtension(value={"SMAP\nBreakpointsDialogFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreakpointsDialogFactory.kt\ncom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialogFactory$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,113:1\n30#2,2:114\n*S KotlinDebug\n*F\n+ 1 BreakpointsDialogFactory.kt\ncom/intellij/xdebugger/impl/breakpoints/ui/BreakpointsDialogFactory$Companion\n*L\n109#1:114,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BreakpointsDialogFactory getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<BreakpointsDialogFactory> serviceClass$iv = BreakpointsDialogFactory.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BreakpointsDialogFactory)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

