/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui.grouping;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointGroupingRule;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointTypeProxy;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointFileGroup;
import com.intellij.xdebugger.impl.breakpoints.ui.grouping.XBreakpointGroupingUtilKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointFileGroupingRule;", "B", "", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointGroupingRule;", "Lcom/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointFileGroup;", "<init>", "()V", "getPriority", "", "getGroup", "breakpoint", "(Ljava/lang/Object;)Lcom/intellij/xdebugger/impl/breakpoints/ui/grouping/XBreakpointFileGroup;", "getIcon", "Ljavax/swing/Icon;", "intellij.platform.debugger.impl"})
public final class XBreakpointFileGroupingRule<B>
extends XBreakpointGroupingRule<B, XBreakpointFileGroup> {
    public XBreakpointFileGroupingRule() {
        super("by-file", XDebuggerBundle.message((String)"rule.name.group.by.file", (Object[])new Object[0]));
    }

    public int getPriority() {
        return 600;
    }

    @Nullable
    public XBreakpointFileGroup getGroup(@NotNull B breakpoint2) {
        Intrinsics.checkNotNullParameter(breakpoint2, (String)"breakpoint");
        XBreakpointProxy xBreakpointProxy = XBreakpointGroupingUtilKt.asBreakpointProxyOrNull(breakpoint2);
        if (xBreakpointProxy == null) {
            return null;
        }
        XBreakpointProxy proxy = xBreakpointProxy;
        if (!(proxy.getType() instanceof XLineBreakpointTypeProxy)) {
            return null;
        }
        XSourcePosition position = proxy.getSourcePosition();
        if (position == null) {
            return null;
        }
        VirtualFile virtualFile = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile file = virtualFile;
        return new XBreakpointFileGroup(file);
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.Actions.GroupByFile;
    }
}

