/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.dashboard;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.dashboard.RunDashboardCustomizationBuilder;
import com.intellij.execution.dashboard.RunDashboardCustomizer;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\"\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/xdebugger/impl/dashboard/XDebuggerRunDashboardCustomizer;", "Lcom/intellij/execution/dashboard/RunDashboardCustomizer;", "<init>", "()V", "isApplicable", "", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "descriptor", "Lcom/intellij/execution/ui/RunContentDescriptor;", "updatePresentation", "customizationBuilder", "Lcom/intellij/execution/dashboard/RunDashboardCustomizationBuilder;", "configurationSettings", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nXDebuggerRunDashboardCustomizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XDebuggerRunDashboardCustomizer.kt\ncom/intellij/xdebugger/impl/dashboard/XDebuggerRunDashboardCustomizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,31:1\n1761#2,3:32\n1#3:35\n*S KotlinDebug\n*F\n+ 1 XDebuggerRunDashboardCustomizer.kt\ncom/intellij/xdebugger/impl/dashboard/XDebuggerRunDashboardCustomizer\n*L\n17#1:32,3\n*E\n"})
public final class XDebuggerRunDashboardCustomizer
extends RunDashboardCustomizer {
    public boolean isApplicable(@NotNull RunnerAndConfigurationSettings settings, @Nullable RunContentDescriptor descriptor) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            if (descriptor == null) {
                return false;
            }
            Project project = settings.getConfiguration().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Set executors = ExecutionManager.Companion.getInstance(project).getExecutors(descriptor);
            Iterable $this$any$iv = executors;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Executor it = (Executor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)"Debug")) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean updatePresentation(@NotNull RunDashboardCustomizationBuilder customizationBuilder, @NotNull RunnerAndConfigurationSettings configurationSettings, @Nullable RunContentDescriptor descriptor) {
        Object object;
        block6: {
            Intrinsics.checkNotNullParameter((Object)customizationBuilder, (String)"customizationBuilder");
            Intrinsics.checkNotNullParameter((Object)configurationSettings, (String)"configurationSettings");
            RunContentDescriptor runContentDescriptor = descriptor;
            if (runContentDescriptor == null || (runContentDescriptor = runContentDescriptor.getProcessHandler()) == null) {
                return false;
            }
            RunContentDescriptor processHandler = runContentDescriptor;
            XDebugSession[] xDebugSessionArray = XDebuggerManager.getInstance((Project)configurationSettings.getConfiguration().getProject()).getDebugSessions();
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSessionArray, (String)"getDebugSessions(...)");
            for (Object object2 : (Object[])xDebugSessionArray) {
                XDebugSession it = (XDebugSession)object2;
                boolean bl = false;
                if (!(it.getDebugProcess().getProcessHandler() == processHandler)) continue;
                object = object2;
                break block6;
            }
            object = null;
        }
        XDebugSession xDebugSession = (XDebugSession)object;
        if (xDebugSession == null) {
            return false;
        }
        XDebugSession session = xDebugSession;
        if (session.isPaused()) {
            Icon icon = AllIcons.Actions.Pause;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Pause");
            customizationBuilder.setIcon(icon);
        } else if (!session.isStopped()) {
            Icon icon = AllIcons.Actions.StartDebugger;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"StartDebugger");
            customizationBuilder.setIcon(icon);
        }
        return false;
    }
}

