/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.HelpTooltip;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.actionSystem.remoting.ActionRemoteBehaviorSpecification;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListItemDescriptor;
import com.intellij.openapi.ui.popup.ListItemDescriptorAdapter;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiManager;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ExpandedItemListCellRendererWrapper;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.hover.HoverListener;
import com.intellij.ui.icons.IconReplacer;
import com.intellij.ui.icons.ReplaceableIcon;
import com.intellij.ui.popup.list.GroupedItemsListRenderer;
import com.intellij.ui.popup.list.SelectablePanel;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBScalableIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.NamedColorUtil;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XDropFrameHandler;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.frame.DebuggerFramesList;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxyKeeperKt;
import com.intellij.xdebugger.impl.frame.XFramesAsyncPresentationHandler;
import com.intellij.xdebugger.impl.frame.XFramesAsyncPresentationManager;
import com.intellij.xdebugger.impl.frame.XFramesView;
import com.intellij.xdebugger.impl.frame.XStackFramesListColorsCache;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.Transferable;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.FontUIResource;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerFramesList
extends DebuggerFramesList
implements UiCompatibleDataProvider {
    private final Project myProject;
    private final XStackFramesListColorsCache myFileColorsCache;
    @NotNull
    private final XFramesAsyncPresentationHandler myPresentationHandler;
    private static final DataKey<XDebuggerFramesList> FRAMES_LIST = DataKey.create((String)"FRAMES_LIST");

    private void copyStack() {
        List items = this.getModel().getItems();
        if (!items.isEmpty()) {
            StringBuilder plainBuf = new StringBuilder();
            TextTransferable.ColoredStringBuilder coloredTextContainer = new TextTransferable.ColoredStringBuilder();
            for (Object value : items) {
                ItemWithSeparatorAbove item;
                if (value instanceof ItemWithSeparatorAbove && (item = (ItemWithSeparatorAbove)value).hasSeparatorAbove()) {
                    String caption = " - " + StringUtil.notNullize((String)item.getCaptionAboveOf());
                    plainBuf.append(caption).append('\n');
                }
                if (value != null) {
                    if (value instanceof XStackFrame) {
                        ((XStackFrame)value).customizeTextPresentation((ColoredTextContainer)coloredTextContainer);
                        coloredTextContainer.appendTo(new StringBuilder[]{plainBuf});
                    } else {
                        String text = value.toString();
                        plainBuf.append(text);
                    }
                }
                plainBuf.append('\n');
            }
            plainBuf.setLength(plainBuf.length() - 1);
            String plainText = plainBuf.toString();
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable("<html><body><pre>\n" + XmlStringUtil.escapeString((String)plainText) + "\n</pre></body></html>", plainText));
        }
    }

    @ApiStatus.Obsolete
    public XDebuggerFramesList(@NotNull Project project) {
        if (project == null) {
            XDebuggerFramesList.$$$reportNull$$$0(0);
        }
        this(project, (XDebugSessionProxy)null);
    }

    public XDebuggerFramesList(@NotNull Project project, @NotNull XDebugSession session) {
        if (project == null) {
            XDebuggerFramesList.$$$reportNull$$$0(1);
        }
        if (session == null) {
            XDebuggerFramesList.$$$reportNull$$$0(2);
        }
        this(project, XDebugSessionProxyKeeperKt.asProxy(session));
    }

    @ApiStatus.Internal
    public XDebuggerFramesList(@NotNull Project project, @Nullable XDebugSessionProxy sessionProxy) {
        if (project == null) {
            XDebuggerFramesList.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myFileColorsCache = sessionProxy == null ? new OldFileColorsCache(project) : sessionProxy.createFileColorsCache(this);
        this.myPresentationHandler = XFramesAsyncPresentationManager.getInstance(project).createFor(this);
        this.doInit();
        Font font = this.getFont();
        if (font != null) {
            this.setFont(new FontUIResource(font.getName(), font.getStyle(), font.getSize()));
        }
        new XDebuggerFrameListMouseListener().installListeners(this);
        final ResetFrameAction resetFrameAction = new ResetFrameAction();
        resetFrameAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)this));
        this.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                XDebuggerFramesList list = (XDebuggerFramesList)((Object)ObjectUtils.tryCast((Object)e.getComponent(), XDebuggerFramesList.class));
                if (list != null && XDebuggerFrameListMouseListener.getResetIconHovered((Component)((Object)list))) {
                    ActionManager.getInstance().tryToExecute((AnAction)resetFrameAction, (InputEvent)e, (Component)((Object)list), "XDebuggerFramesList", true);
                }
            }
        });
        this.getModel().addListDataListener((ListDataListener)new PresentationScheduler());
    }

    public void updateUI() {
        super.updateUI();
        ListCellRenderer listCellRenderer = ExpandedItemListCellRendererWrapper.unwrap((ListCellRenderer)this.getCellRenderer());
        if (listCellRenderer instanceof XDebuggerGroupedFrameListRenderer) {
            XDebuggerGroupedFrameListRenderer renderer = (XDebuggerGroupedFrameListRenderer)((Object)listCellRenderer);
            renderer.updateUI();
        }
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        XStackFrame frame;
        Rectangle cellBounds;
        if (sink == null) {
            XDebuggerFramesList.$$$reportNull$$$0(4);
        }
        sink.set(FRAMES_LIST, (Object)this);
        int index = this.getSelectedIndex();
        Rectangle rectangle = cellBounds = index != -1 ? this.getCellBounds(index, index) : null;
        if (cellBounds != null) {
            Rectangle visibleRect = this.getVisibleRect();
            sink.set(PlatformDataKeys.CONTEXT_MENU_POINT, (Object)new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y + cellBounds.height - 1));
        }
        if ((frame = this.getSelectedFrame()) == null) {
            return;
        }
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> this.getFrameNavigatable(frame, true));
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> XDebuggerFramesList.getFile(frame));
        sink.lazy(CommonDataKeys.PSI_FILE, () -> {
            VirtualFile file = XDebuggerFramesList.getFile(frame);
            return file != null && file.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(file) : null;
        });
    }

    public boolean selectFrame(@NotNull XStackFrame toSelect) {
        if (toSelect == null) {
            XDebuggerFramesList.$$$reportNull$$$0(5);
        }
        if (Objects.equals(this.getSelectedValue(), toSelect)) {
            return false;
        }
        if (this.getModel().contains((Object)toSelect)) {
            this.setSelectedValue(toSelect, true);
            return true;
        }
        if (toSelect instanceof XFramesView.HiddenStackFramesItem) {
            XFramesView.HiddenStackFramesItem placeholder = (XFramesView.HiddenStackFramesItem)toSelect;
            XStackFrame firstHiddenFrame = placeholder.hiddenFrames.get(0);
            if (this.getModel().contains((Object)firstHiddenFrame)) {
                this.setSelectedValue(firstHiddenFrame, true);
                return true;
            }
        } else {
            Object placeholderContainingFrameToSelect = ContainerUtil.find((Iterable)this.getModel().getItems(), frame -> {
                if (!(frame instanceof XFramesView.HiddenStackFramesItem)) return false;
                XFramesView.HiddenStackFramesItem placeholder = (XFramesView.HiddenStackFramesItem)frame;
                if (!placeholder.hiddenFrames.contains(toSelect)) return false;
                return true;
            });
            if (placeholderContainingFrameToSelect != null) {
                this.setSelectedValue(placeholderContainingFrameToSelect, true);
                return true;
            }
        }
        return false;
    }

    public boolean selectFrame(int indexToSelect) {
        if (this.getSelectedIndex() != indexToSelect && this.getElementCount() > indexToSelect && this.getModel().getElementAt(indexToSelect) != null) {
            this.setSelectedIndex(indexToSelect);
            return true;
        }
        return false;
    }

    @Nullable
    public XStackFrame getSelectedFrame() {
        Object value = this.getSelectedValue();
        return value instanceof XStackFrame ? (XStackFrame)value : null;
    }

    @Override
    @Nullable
    protected Navigatable getSelectedFrameNavigatable() {
        Navigatable navigatable;
        XStackFrame frame = this.getSelectedFrame();
        Navigatable navigatable2 = navigatable = frame != null ? this.getFrameNavigatable(frame, false) : null;
        if (navigatable instanceof OpenFileDescriptor) {
            ((OpenFileDescriptor)navigatable).setUsePreviewTab(true);
        }
        return navigatable != null ? XDebuggerUtilImpl.wrapKeepEditorAreaFocusNavigatable(this.myProject, navigatable) : null;
    }

    @Nullable
    protected Navigatable getFrameNavigatable(@NotNull XStackFrame frame, boolean isMainSourceKindPreferred) {
        XSourcePosition position;
        if (frame == null) {
            XDebuggerFramesList.$$$reportNull$$$0(6);
        }
        return (position = frame.getSourcePosition()) != null ? position.createNavigatable(this.myProject) : null;
    }

    public void sessionStopped() {
        this.myPresentationHandler.sessionStopped();
    }

    @Nullable
    private static VirtualFile getFile(XStackFrame frame) {
        XSourcePosition position = frame.getSourcePosition();
        return position != null ? position.getFile() : null;
    }

    @Override
    protected ListCellRenderer createListRenderer() {
        return new XDebuggerGroupedFrameListRenderer();
    }

    Color getFrameBgColor(XStackFrame stackFrame) {
        if (stackFrame instanceof ItemWithCustomBackgroundColor) {
            return ((ItemWithCustomBackgroundColor)stackFrame).getBackgroundColor();
        }
        return this.myFileColorsCache.get(stackFrame);
    }

    @Nullable
    private static XDropFrameHandler findDropFrameHandler(XDebuggerFramesList list) {
        XDebugSessionProxy session = (XDebugSessionProxy)DataManager.getInstance().getDataContext((Component)((Object)list)).getData(XDebugSessionProxy.DEBUG_SESSION_PROXY_KEY);
        if (session == null) {
            return null;
        }
        return session.getDropFrameHandler();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "selectFrame";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getFrameNavigatable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ItemWithSeparatorAbove {
        public boolean hasSeparatorAbove();

        @NlsContexts.Separator
        public String getCaptionAboveOf();

        default public void setWithSeparator(boolean withSeparator) {
        }
    }

    @Deprecated
    private class OldFileColorsCache
    extends XStackFramesListColorsCache {
        private static final Color NULL_COLOR = JBColor.marker((String)"NULL_COLOR");
        private static final Color COMPUTING_COLOR = JBColor.marker((String)"COMPUTING_COLOR");
        private volatile Map<VirtualFile, Color> myFileColors;

        OldFileColorsCache(Project project) {
            super(project);
            this.myFileColors = new HashMap<VirtualFile, Color>();
        }

        @Override
        @Nullable
        public Color get(@NotNull XStackFrame stackFrame) {
            VirtualFile file;
            if (stackFrame == null) {
                OldFileColorsCache.$$$reportNull$$$0(0);
            }
            if ((file = XDebuggerFramesList.getFile(stackFrame)) == null) {
                return null;
            }
            return this.get(file);
        }

        /*
         * WARNING - void declaration
         */
        @RequiresEdt
        @Nullable
        Color get(@Nullable VirtualFile virtualFile) {
            void virtualFile2;
            ThreadingAssertions.assertEventDispatchThread();
            if (virtualFile2 != null) {
                Color res = this.myFileColors.get(virtualFile2);
                if (res != null) {
                    return res == NULL_COLOR || res == COMPUTING_COLOR ? null : res;
                }
                if (virtualFile2.isValid()) {
                    Map<VirtualFile, Color> fileColors = this.myFileColors;
                    fileColors.put((VirtualFile)virtualFile2, COMPUTING_COLOR);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> this.lambda$get$2(fileColors, (VirtualFile)virtualFile2));
                }
            } else {
                return this.getColorsManager().getScopeColor("Non-Project Files");
            }
            return null;
        }

        @RequiresEdt
        void clear() {
            ThreadingAssertions.assertEventDispatchThread();
            this.myFileColors = new HashMap<VirtualFile, Color>();
        }

        private /* synthetic */ void lambda$get$2(Map fileColors, VirtualFile virtualFile) {
            if (fileColors == this.myFileColors) {
                Color color = (Color)ReadAction.compute(() -> this.getColorsManager().getFileColor(virtualFile));
                EdtExecutorService.getInstance().execute(() -> {
                    if (fileColors == this.myFileColors) {
                        fileColors.put(virtualFile, color == null ? NULL_COLOR : color);
                        if (!fileColors.containsValue(COMPUTING_COLOR)) {
                            XDebuggerFramesList.this.repaint();
                        }
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackFrame", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$OldFileColorsCache", "get"));
        }
    }

    private static final class XDebuggerFrameListMouseListener
    extends HoverListener {
        private static final Key<Point> HOVER_POSITION = Key.create((String)"XDEBUGGER_HOVER_POSITION");
        private static final Key<Integer> HOVER_INDEX = Key.create((String)"XDEBUGGER_HOVER_INDEX");
        private static final Key<Rectangle> HOVER_BOUNDS = Key.create((String)"XDEBUGGER_HOVER_BOUNDS");
        private static final Key<Boolean> CAN_DROP_FRAME = Key.create((String)"XDEBUGGER_CAN_DROP_FRAME");
        private static final Key<Boolean> RESET_ICON_HOVERED = Key.create((String)"XDEBUGGER_RESET_ICON_HOVERERD");

        private XDebuggerFrameListMouseListener() {
        }

        private void installListeners(@NotNull XDebuggerFramesList list) {
            if (list == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(0);
            }
            this.addTo((JComponent)((Object)list));
            HelpTooltip helpTooltip = new HelpTooltip().setTitle(XDebuggerBundle.message((String)"debugger.frame.list.help.title", (Object[])new Object[0])).setDescription(XDebuggerBundle.message((String)"debugger.frame.list.help.description", (Object[])new Object[0]));
            Shortcut[] shortcuts = CommonShortcuts.getDelete().getShortcuts();
            if (shortcuts.length > 0) {
                helpTooltip.setShortcut(shortcuts[0]);
            }
            helpTooltip.installOn((JComponent)((Object)list));
            HelpTooltip.setMasterPopupOpenCondition((Component)((Object)list), () -> ClientProperty.isTrue((Component)((Object)list), RESET_ICON_HOVERED));
        }

        @Nullable
        public static Point getMouseLocation(@NotNull Component component) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(1);
            }
            return (Point)ClientProperty.get((Component)component, HOVER_POSITION);
        }

        public static int getHoveredIndex(@NotNull Component component) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(2);
            }
            return Optional.ofNullable((Integer)ClientProperty.get((Component)component, HOVER_INDEX)).orElse(-1);
        }

        @Nullable
        public static Rectangle getHoveredCellBounds(@NotNull Component component) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(3);
            }
            return (Rectangle)ClientProperty.get((Component)component, HOVER_BOUNDS);
        }

        public static boolean getCanDropFrame(@NotNull Component component) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(4);
            }
            return ClientProperty.isTrue((Component)component, CAN_DROP_FRAME);
        }

        public static boolean getResetIconHovered(@NotNull Component component) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(5);
            }
            return ClientProperty.isTrue((Component)component, RESET_ICON_HOVERED);
        }

        private static void updateHover(@NotNull Component component, @Nullable Point point) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(6);
            }
            if (!(component instanceof XDebuggerFramesList)) {
                return;
            }
            XDebuggerFramesList list = (XDebuggerFramesList)((Object)component);
            int oldHoverIndex = XDebuggerFrameListMouseListener.getHoveredIndex(component);
            ClientProperty.put((JComponent)((Object)list), HOVER_POSITION, null);
            ClientProperty.put((JComponent)((Object)list), HOVER_BOUNDS, null);
            ClientProperty.put((JComponent)((Object)list), HOVER_INDEX, (Object)-1);
            ClientProperty.put((JComponent)((Object)list), CAN_DROP_FRAME, (Object)false);
            ClientProperty.put((JComponent)((Object)list), RESET_ICON_HOVERED, (Object)false);
            boolean resetHoverActions = true;
            if (point != null) {
                boolean isHovered;
                Object value;
                Point pointInCellBounds;
                XDebuggerFrameListRenderer renderer = XDebuggerFrameListMouseListener.getFrameListRenderer((JList)((Object)list), point);
                int index = list.locationToIndex(point);
                Rectangle bounds = list.getCellBounds(index, index);
                Point point2 = pointInCellBounds = bounds == null ? point : new Point(point.x - bounds.x, point.y - bounds.y);
                if (oldHoverIndex != index) {
                    HelpTooltip.hide((Component)((Object)list));
                }
                if (bounds != null) {
                    ClientProperty.put((JComponent)((Object)list), HOVER_POSITION, (Object)pointInCellBounds);
                    ClientProperty.put((JComponent)((Object)list), HOVER_BOUNDS, (Object)bounds);
                }
                ClientProperty.put((JComponent)((Object)list), HOVER_INDEX, (Object)index);
                if (index >= 0 && index < list.getModel().getSize() && (value = list.getModel().getElementAt(index)) instanceof XStackFrame) {
                    XStackFrame frame = (XStackFrame)value;
                    XDropFrameHandler dropFrameHandler = XDebuggerFramesList.findDropFrameHandler(list);
                    ClientProperty.put((JComponent)((Object)list), CAN_DROP_FRAME, (Object)(dropFrameHandler != null && dropFrameHandler.canDropFrame(frame) == ThreeState.YES ? 1 : 0));
                }
                if (renderer != null && XDebuggerFrameListMouseListener.getCanDropFrame((Component)((Object)list)) && (isHovered = renderer.isIconHovered(pointInCellBounds, bounds))) {
                    list.setCursor(Cursor.getPredefinedCursor(12));
                    ClientProperty.put((JComponent)((Object)list), RESET_ICON_HOVERED, (Object)true);
                    resetHoverActions = false;
                }
            }
            if (resetHoverActions) {
                list.setCursor(Cursor.getDefaultCursor());
                HelpTooltip.hide((Component)((Object)list));
            }
            component.repaint();
        }

        public void mouseEntered(@NotNull Component component, int x, int y) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(7);
            }
            XDebuggerFrameListMouseListener.updateHover(component, new Point(x, y));
        }

        public void mouseMoved(@NotNull Component component, int x, int y) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(8);
            }
            XDebuggerFrameListMouseListener.updateHover(component, new Point(x, y));
        }

        public void mouseExited(@NotNull Component component) {
            if (component == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(9);
            }
            XDebuggerFrameListMouseListener.updateHover(component, null);
        }

        @Nullable
        private static XDebuggerFrameListRenderer getFrameListRenderer(@NotNull JList list, @NotNull Point mouseLocation) {
            if (list == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(10);
            }
            if (mouseLocation == null) {
                XDebuggerFrameListMouseListener.$$$reportNull$$$0(11);
            }
            ListCellRenderer renderer = list.getCellRenderer();
            int index = list.locationToIndex(mouseLocation);
            if (index < 0 || index >= list.getModel().getSize()) {
                return null;
            }
            Object value = list.getModel().getElementAt(index);
            JComponent component = (JComponent)ObjectUtils.tryCast((Object)renderer.getListCellRendererComponent(list, value, index, false, false), JComponent.class);
            if (component == null) {
                return null;
            }
            return (XDebuggerFrameListRenderer)((Object)ContainerUtil.getFirstItem((List)ComponentUtil.findComponentsOfType((JComponent)component, XDebuggerFrameListRenderer.class)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mouseLocation";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListMouseListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "installListeners";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMouseLocation";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHoveredIndex";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getHoveredCellBounds";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getCanDropFrame";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getResetIconHovered";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateHover";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFrameListRenderer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ResetFrameAction
    extends DumbAwareAction
    implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
        private ResetFrameAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ResetFrameAction.$$$reportNull$$$0(0);
            }
            InputEvent inputEvent = e.getInputEvent();
            XDebuggerFramesList list = (XDebuggerFramesList)((Object)e.getData(FRAMES_LIST));
            if (inputEvent == null || list == null) {
                return;
            }
            int index = -1;
            MouseEvent event = (MouseEvent)ObjectUtils.tryCast((Object)inputEvent, MouseEvent.class);
            if (event != null) {
                if (UIUtil.isActionClick((MouseEvent)event, (int)501) && XDebuggerFrameListMouseListener.getResetIconHovered((Component)((Object)list))) {
                    index = XDebuggerFrameListMouseListener.getHoveredIndex((Component)((Object)list));
                }
            } else {
                index = list.getSelectedIndex();
            }
            CollectionListModel model = list.getModel();
            if (index >= 0 && index < model.getSize()) {
                XDropFrameHandler handler = XDebuggerFramesList.findDropFrameHandler(list);
                XStackFrame frame = (XStackFrame)ObjectUtils.tryCast((Object)model.getElementAt(index), XStackFrame.class);
                if (frame != null && handler != null && handler.canDropFrame(frame) == ThreeState.YES) {
                    handler.drop(frame);
                    inputEvent.consume();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$ResetFrameAction", "actionPerformed"));
        }
    }

    private class PresentationScheduler
    implements ListDataListener {
        private PresentationScheduler() {
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.schedulePresentations(e);
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.schedulePresentations(e);
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            if (XDebuggerFramesList.this.getModel().isEmpty()) {
                XDebuggerFramesList.this.myPresentationHandler.clear();
            }
        }

        private void schedulePresentations(ListDataEvent e) {
            ArrayList<XStackFrame> frames = new ArrayList<XStackFrame>();
            for (int i = e.getIndex0(); i <= e.getIndex1(); ++i) {
                Object item = XDebuggerFramesList.this.getModel().getElementAt(i);
                if (!(item instanceof XStackFrame)) continue;
                XStackFrame frame = (XStackFrame)item;
                frames.add(frame);
            }
            if (frames.isEmpty()) {
                return;
            }
            XDebuggerFramesList.this.myPresentationHandler.scheduleForFrames(frames);
        }
    }

    private class XDebuggerGroupedFrameListRenderer
    extends GroupedItemsListRenderer {
        private XDebuggerFrameListRenderer myOriginalRenderer;

        XDebuggerGroupedFrameListRenderer() {
            super((ListItemDescriptor)new ListItemDescriptorAdapter(){

                @Nullable
                public String getTextFor(Object value) {
                    return null;
                }

                @Nullable
                public String getCaptionAboveOf(Object value) {
                    return value instanceof ItemWithSeparatorAbove ? ((ItemWithSeparatorAbove)value).getCaptionAboveOf() : null;
                }

                public boolean hasSeparatorAboveOf(Object value) {
                    return value instanceof ItemWithSeparatorAbove && ((ItemWithSeparatorAbove)value).hasSeparatorAbove();
                }
            });
            this.mySeparatorComponent.setCaptionCentered(false);
        }

        public void updateUI() {
            SwingUtilities.updateComponentTreeUI((Component)this.myRendererComponent);
        }

        protected Border getDefaultItemComponentBorder() {
            return null;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setSeparatorFont(list.getFont());
            this.myOriginalRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Component result2 = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            result2.getAccessibleContext().setAccessibleName(this.myOriginalRenderer.getAccessibleContext().getAccessibleName());
            JComponent itemComponent = this.getItemComponent();
            if (itemComponent instanceof SelectablePanel) {
                Color color;
                SelectablePanel selectablePanel = (SelectablePanel)itemComponent;
                if (value instanceof XStackFrame) {
                    XStackFrame stackFrame = (XStackFrame)value;
                    color = XDebuggerFramesList.this.getFrameBgColor(stackFrame);
                } else {
                    color = null;
                }
                Color stackFrameColor = color;
                selectablePanel.setOpaque(true);
                selectablePanel.setBackground(stackFrameColor);
                selectablePanel.setSelectionColor(this.myOriginalRenderer.background);
            } else {
                this.myOriginalRenderer.setBackground(this.myOriginalRenderer.background);
            }
            return result2;
        }

        protected JComponent createItemComponent() {
            this.createLabel();
            this.myOriginalRenderer = new XDebuggerFrameListRenderer();
            return this.layoutComponent((JComponent)((Object)this.myOriginalRenderer));
        }
    }

    public static interface ItemWithCustomBackgroundColor {
        @Nullable
        public Color getBackgroundColor();
    }

    private static class XDebuggerPopFrameIcon
    extends JBScalableIcon
    implements ReplaceableIcon {
        @NotNull
        private final Icon myIcon;
        @Nullable
        private final Icon mySelectedIcon;
        @Nullable
        private Color myBackground;
        private boolean isSelected;
        private final int myIconWidth;
        private final int myIconHeight;

        XDebuggerPopFrameIcon(@NotNull Icon icon, @Nullable Icon selectedIcon, int width, int height) {
            if (icon == null) {
                XDebuggerPopFrameIcon.$$$reportNull$$$0(0);
            }
            this.myBackground = null;
            this.isSelected = false;
            this.myIcon = icon;
            this.mySelectedIcon = selectedIcon;
            this.myIconWidth = width;
            this.myIconHeight = height;
        }

        @NotNull
        public XDebuggerPopFrameIcon replaceBy(@NotNull IconReplacer replacer) {
            if (replacer == null) {
                XDebuggerPopFrameIcon.$$$reportNull$$$0(1);
            }
            XDebuggerPopFrameIcon icon = new XDebuggerPopFrameIcon(replacer.replaceIcon(this.myIcon), replacer.replaceIcon(this.mySelectedIcon), this.myIconWidth, this.myIconHeight);
            icon.isSelected = this.isSelected;
            XDebuggerPopFrameIcon xDebuggerPopFrameIcon = icon;
            if (xDebuggerPopFrameIcon == null) {
                XDebuggerPopFrameIcon.$$$reportNull$$$0(2);
            }
            return xDebuggerPopFrameIcon;
        }

        @Nullable
        private Color getBackground() {
            return this.myBackground;
        }

        private void setBackground(@Nullable Color background) {
            this.myBackground = background;
        }

        private boolean isSelected() {
            return this.isSelected;
        }

        private void setSelected(boolean selected) {
            this.isSelected = selected;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color background = this.getBackground();
            if (background != null) {
                if (g instanceof Graphics2D) {
                    ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                g.setColor(background);
                int arc = (int)Math.ceil(this.scaleVal(5.0));
                g.fillRoundRect(x, y, this.getIconWidth(), this.getIconHeight(), arc, arc);
            }
            Icon icon = !this.isSelected() || this.mySelectedIcon == null || ExperimentalUI.isNewUI() ? this.myIcon : this.mySelectedIcon;
            icon.paintIcon(c, g, x + (this.getIconWidth() - icon.getIconWidth()) / 2, y + (this.getIconHeight() - icon.getIconHeight()) / 2);
        }

        public int getIconWidth() {
            return (int)Math.ceil(this.scaleVal(this.myIconWidth));
        }

        public int getIconHeight() {
            return (int)Math.ceil(this.scaleVal(this.myIconHeight));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerPopFrameIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerPopFrameIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "replaceBy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceBy";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class CopyStackAction
    extends DumbAwareAction
    implements ActionRemoteBehaviorSpecification.FrontendOtherwiseBackend {
        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyStackAction.$$$reportNull$$$0(0);
            }
            XDebuggerFramesList framesList = (XDebuggerFramesList)((Object)e.getData(FRAMES_LIST));
            e.getPresentation().setEnabledAndVisible(framesList != null && ContainerUtil.getLastItem((List)framesList.getModel().getItems()) != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                CopyStackAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            XDebuggerFramesList framesList;
            if (e == null) {
                CopyStackAction.$$$reportNull$$$0(2);
            }
            if ((framesList = (XDebuggerFramesList)((Object)e.getData(FRAMES_LIST))) != null) {
                framesList.copyStack();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$CopyStackAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$CopyStackAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class XDebuggerFrameListRenderer
    extends ColoredListCellRenderer {
        Color background;
        private final XDebuggerPopFrameIcon myPopFrameIcon = (XDebuggerPopFrameIcon)JBUIScale.scaleIcon((JBScalableIcon)new XDebuggerPopFrameIcon(AllIcons.Actions.InlineDropFrame, AllIcons.Actions.InlineDropFrameSelected, 16, 16));

        private XDebuggerFrameListRenderer() {
            if (ExperimentalUI.isNewUI()) {
                this.getIpad().left = 0;
                this.getIpad().right = 0;
            }
        }

        protected void paintIcon(@NotNull Graphics g, @NotNull Icon icon, int offset) {
            if (g == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(0);
            }
            if (icon == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(1);
            }
            Rectangle area = this.computePaintArea();
            icon.paintIcon((Component)((Object)this), g, offset, area.y + (area.height - icon.getIconHeight()) / 2);
        }

        protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(2);
            }
            this.background = null;
            if (value == null) {
                this.append(XDebuggerBundle.message((String)"stack.frame.loading.text", (Object[])new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
                return;
            }
            if (value instanceof String) {
                this.append((String)value, SimpleTextAttributes.ERROR_ATTRIBUTES);
                return;
            }
            XStackFrame stackFrame = (XStackFrame)value;
            Point loc = XDebuggerFrameListMouseListener.getMouseLocation(list);
            Rectangle bounds = XDebuggerFrameListMouseListener.getHoveredCellBounds(list);
            int hoveredIndex = XDebuggerFrameListMouseListener.getHoveredIndex(list);
            boolean iconHovered = this.isIconHovered(loc, bounds);
            boolean hovered = index == hoveredIndex;
            boolean canDropSomething = XDebuggerFrameListMouseListener.getCanDropFrame(list);
            if (!selected) {
                Color c = XDebuggerFramesList.this.getFrameBgColor(stackFrame);
                if (index <= hoveredIndex && canDropSomething && iconHovered) {
                    this.background = RenderingUtil.getHoverBackground((JList)list);
                } else if (c != null) {
                    this.background = c;
                }
            } else {
                this.background = UIUtil.getListSelectionBackground((boolean)hasFocus);
                this.setForeground(NamedColorUtil.getListSelectionForeground((boolean)hasFocus));
                this.mySelectionForeground = this.getForeground();
            }
            XDebuggerFramesList.this.myPresentationHandler.customizePresentation(stackFrame, (ColoredTextContainer)this);
            if (hovered && canDropSomething || selected && hoveredIndex < 0 && XDebuggerFrameListRenderer.canDropSelectedFrame(list)) {
                this.setIcon((Icon)((Object)this.myPopFrameIcon));
                if (iconHovered && selected) {
                    this.myPopFrameIcon.setBackground(ColorUtil.withAlpha((Color)NamedColorUtil.getListSelectionForeground((boolean)true), (double)0.2));
                } else {
                    this.myPopFrameIcon.setBackground(null);
                }
                this.myPopFrameIcon.setSelected(selected && hasFocus);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
        }

        private static boolean canDropSelectedFrame(JList list) {
            if (!(list instanceof XDebuggerFramesList)) {
                return false;
            }
            Object selectedValue = list.getSelectedValue();
            if (!(selectedValue instanceof XStackFrame)) {
                return false;
            }
            XStackFrame frame = (XStackFrame)selectedValue;
            try {
                XDropFrameHandler dropFrameHandler = XDebuggerFramesList.findDropFrameHandler((XDebuggerFramesList)((Object)list));
                if (dropFrameHandler == null) {
                    return false;
                }
                return dropFrameHandler.canDropFrame(frame) == ThreeState.YES;
            }
            catch (Throwable throwable) {
                return false;
            }
        }

        @NotNull
        public CharSequence getCharSequence(boolean mainOnly) {
            CharSequence charSequence = super.getCharSequence(false);
            if (charSequence == null) {
                XDebuggerFrameListRenderer.$$$reportNull$$$0(3);
            }
            return charSequence;
        }

        public boolean isIconHovered(@Nullable Point p, @Nullable Rectangle bounds) {
            if (p == null || bounds == null) {
                return false;
            }
            int leftPadding = ExperimentalUI.isNewUI() ? JBUI.CurrentTheme.Popup.Selection.LEFT_RIGHT_INSET.get() + JBUI.CurrentTheme.Popup.Selection.innerInsets().left : this.getIpad().left;
            int iconWidth = this.myPopFrameIcon.getIconWidth();
            return new Rectangle(leftPadding, 0, iconWidth, bounds.height).contains(p);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "g";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "icon";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/frame/XDebuggerFramesList$XDebuggerFrameListRenderer";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "paintIcon";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "customizeCellRenderer";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

