/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog.items.tree;

import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.AttachToProcessElementsFilters;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.cells.AttachTableCell;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.columns.AttachDialogColumnsLayout;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.nodes.AttachDialogElementNode;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.nodes.AttachDialogGroupNode;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.nodes.AttachDialogProcessNode;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.tree.AttachTreeNodeWrapper;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.tree.AttachTreeRootNode;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000]\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000*\u0001\u0013\b\u0000\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0000J\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00000\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0000J\u0006\u0010\u001b\u001a\u00020\tJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\tH\u0002J8\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020#2\u0006\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020#J\u000e\u0010(\u001a\u00020\u00012\u0006\u0010)\u001a\u00020\tJ\b\u0010*\u001a\u00020+H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/tree/AttachTreeNodeWrapper;", "", "node", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/nodes/AttachDialogElementNode;", "filters", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters;", "columnsLayout", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/columns/AttachDialogColumnsLayout;", "indentLevel", "", "<init>", "(Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/nodes/AttachDialogElementNode;Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/AttachToProcessElementsFilters;Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/columns/AttachDialogColumnsLayout;I)V", "getNode", "()Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/nodes/AttachDialogElementNode;", "children", "", "parent", "myIndentLevel", "elementRenderer", "com/intellij/xdebugger/impl/ui/attach/dialog/items/tree/AttachTreeNodeWrapper$elementRenderer$1", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/tree/AttachTreeNodeWrapper$elementRenderer$1;", "addChild", "", "child", "getChildNodes", "", "getParent", "getIndentLevel", "updateIndentLevel", "newIndentLevel", "getTreeCellRendererComponent", "Ljava/awt/Component;", "tree", "Ljavax/swing/JTree;", "selected", "", "expanded", "leaf", "row", "hasFocus", "getValueAtColumn", "column", "toString", "", "intellij.platform.debugger.impl"})
public final class AttachTreeNodeWrapper {
    @NotNull
    private final AttachDialogElementNode node;
    @NotNull
    private final AttachToProcessElementsFilters filters;
    @NotNull
    private final AttachDialogColumnsLayout columnsLayout;
    @NotNull
    private final List<AttachTreeNodeWrapper> children;
    @Nullable
    private AttachTreeNodeWrapper parent;
    private int myIndentLevel;
    @NotNull
    private final elementRenderer.1 elementRenderer;

    public AttachTreeNodeWrapper(@NotNull AttachDialogElementNode node, @NotNull AttachToProcessElementsFilters filters, @NotNull AttachDialogColumnsLayout columnsLayout, int indentLevel) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)columnsLayout, (String)"columnsLayout");
        this.node = node;
        this.filters = filters;
        this.columnsLayout = columnsLayout;
        this.children = new ArrayList();
        this.myIndentLevel = indentLevel;
        this.elementRenderer = new ColoredTreeCellRenderer(this){
            final /* synthetic */ AttachTreeNodeWrapper this$0;
            {
                this.this$0 = $receiver;
            }

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                AttachDialogProcessNode attachDialogProcessNode = value instanceof AttachDialogProcessNode ? (AttachDialogProcessNode)((Object)value) : null;
                if (attachDialogProcessNode == null) {
                    Class<?> clazz = value;
                    throw new IllegalStateException("value of type " + (clazz != null && (clazz = clazz.getClass()) != null ? clazz.getSimpleName() : null) + " should not be passed here");
                }
                AttachDialogProcessNode attachTreeProcessNode = attachDialogProcessNode;
                AttachTableCell cell = AttachTreeNodeWrapper.access$getColumnsLayout$p(this.this$0).createCell$intellij_platform_debugger_impl(0, attachTreeProcessNode, AttachTreeNodeWrapper.access$getFilters$p(this.this$0), true);
                Pair<String, String> pair = cell.getPresentation((SimpleColoredComponent)this, (this.this$0.getIndentLevel() + 1) * JBUI.scale((int)18));
                String text = (String)pair.component1();
                String tooltip = (String)pair.component2();
                TreeTableTree treeTableTree = tree instanceof TreeTableTree ? (TreeTableTree)tree : null;
                TreeTable treeTable = treeTableTree != null ? treeTableTree.getTreeTable() : null;
                JBTable jBTable = treeTable instanceof JBTable ? (JBTable)treeTable : null;
                if (jBTable == null) {
                    throw new IllegalStateException("can't get parent table");
                }
                JBTable table = jBTable;
                this.append(text, this.modifyAttributes(cell.getTextAttributes(), table, row));
                this.setToolTipText(tooltip);
            }

            private final SimpleTextAttributes modifyAttributes(SimpleTextAttributes attributes, JBTable tree, int row) {
                boolean isTableRowSelected = tree.isRowSelected(row);
                return !isTableRowSelected ? attributes : new SimpleTextAttributes(attributes.getStyle(), RenderingUtil.getSelectionForeground((JTable)((JTable)tree)));
            }
        };
    }

    public /* synthetic */ AttachTreeNodeWrapper(AttachDialogElementNode attachDialogElementNode, AttachToProcessElementsFilters attachToProcessElementsFilters, AttachDialogColumnsLayout attachDialogColumnsLayout, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = 0;
        }
        this(attachDialogElementNode, attachToProcessElementsFilters, attachDialogColumnsLayout, n);
    }

    @NotNull
    public final AttachDialogElementNode getNode() {
        return this.node;
    }

    public final void addChild(@NotNull AttachTreeNodeWrapper child) {
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        this.children.add(child);
        child.parent = this;
        child.updateIndentLevel(this.myIndentLevel + 1);
    }

    @NotNull
    public final List<AttachTreeNodeWrapper> getChildNodes() {
        return this.children;
    }

    @Nullable
    public final AttachTreeNodeWrapper getParent() {
        return this.parent;
    }

    public final int getIndentLevel() {
        return this.myIndentLevel;
    }

    private final void updateIndentLevel(int newIndentLevel) {
        this.myIndentLevel = newIndentLevel;
        for (AttachTreeNodeWrapper child : this.children) {
            child.updateIndentLevel(newIndentLevel + 1);
        }
    }

    @NotNull
    public final Component getTreeCellRendererComponent(@Nullable JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component component;
        AttachDialogElementNode attachDialogElementNode = this.node;
        if (attachDialogElementNode instanceof AttachDialogGroupNode) {
            component = new JLabel(((AttachDialogGroupNode)this.node).getMessage());
        } else if (attachDialogElementNode instanceof AttachDialogProcessNode) {
            Component component2 = this.elementRenderer.getTreeCellRendererComponent(tree, this.node, selected, expanded, leaf, row, hasFocus);
            component = component2;
            Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"getTreeCellRendererComponent(...)");
        } else if (attachDialogElementNode instanceof AttachTreeRootNode) {
            component = new JLabel();
        } else {
            throw new IllegalStateException("Unexpected node type: " + this.node.getClass().getSimpleName());
        }
        return component;
    }

    @NotNull
    public final Object getValueAtColumn(int column) {
        if (column == 0) {
            return this;
        }
        return this.node.getValueAtColumn(column);
    }

    @NotNull
    public String toString() {
        return "(" + this.node + ")";
    }

    public static final /* synthetic */ AttachDialogColumnsLayout access$getColumnsLayout$p(AttachTreeNodeWrapper $this) {
        return $this.columnsLayout;
    }

    public static final /* synthetic */ AttachToProcessElementsFilters access$getFilters$p(AttachTreeNodeWrapper $this) {
        return $this.filters;
    }
}

