/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import java.awt.Font;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class HeadlessValueEvaluationCallbackBase
implements XFullValueEvaluator.XFullValueEvaluationCallback {
    private volatile boolean myEvaluated;
    private volatile boolean myCanceled;
    private final Semaphore mySemaphore;
    private final Project myProject;

    public HeadlessValueEvaluationCallbackBase(@NotNull Project project) {
        if (project == null) {
            HeadlessValueEvaluationCallbackBase.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySemaphore = new Semaphore();
        this.mySemaphore.down();
    }

    public void startFetchingValue(@NotNull XFullValueEvaluator fullValueEvaluator) {
        if (fullValueEvaluator == null) {
            HeadlessValueEvaluationCallbackBase.$$$reportNull$$$0(1);
        }
        fullValueEvaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)this);
        new Alarm().addRequest(() -> this.showProgress(), 500);
    }

    public void evaluated(@NotNull String fullValue, @Nullable Font font) {
        if (fullValue == null) {
            HeadlessValueEvaluationCallbackBase.$$$reportNull$$$0(2);
        }
        this.evaluationComplete(fullValue);
    }

    public void errorOccurred(@NotNull String errorMessage) {
        if (errorMessage == null) {
            HeadlessValueEvaluationCallbackBase.$$$reportNull$$$0(3);
        }
        try {
            String message = XDebuggerBundle.message((String)"load.value.task.error", (Object[])new Object[]{errorMessage});
            XDebuggerManagerImpl.getNotificationGroup().createNotification(message, NotificationType.ERROR).notify(this.myProject);
        }
        finally {
            this.evaluationComplete(errorMessage);
        }
    }

    private void evaluationComplete(@NotNull String value) {
        if (value == null) {
            HeadlessValueEvaluationCallbackBase.$$$reportNull$$$0(4);
        }
        try {
            this.myEvaluated = true;
            this.mySemaphore.up();
        }
        finally {
            this.evaluationComplete(value, this.myProject);
        }
    }

    protected void evaluationComplete(@NotNull String value, @NotNull Project project) {
        if (value == null) {
            HeadlessValueEvaluationCallbackBase.$$$reportNull$$$0(5);
        }
        if (project == null) {
            HeadlessValueEvaluationCallbackBase.$$$reportNull$$$0(6);
        }
    }

    public boolean isObsolete() {
        return this.myCanceled;
    }

    public void showProgress() {
        if (this.myEvaluated || this.isObsolete()) {
            return;
        }
        new Task.Backgroundable(this.myProject, XDebuggerBundle.message((String)"load.value.task.text", (Object[])new Object[0]), true, PerformInBackgroundOption.DEAF){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setIndeterminate(true);
                int i = 0;
                while (!HeadlessValueEvaluationCallbackBase.this.myCanceled && !HeadlessValueEvaluationCallbackBase.this.myEvaluated) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)(i++ % 100) * 0.01);
                    HeadlessValueEvaluationCallbackBase.this.mySemaphore.waitFor(300L);
                }
            }

            public void onCancel() {
                HeadlessValueEvaluationCallbackBase.this.myCanceled = true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallbackBase$1", "run"));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullValueEvaluator";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallbackBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "startFetchingValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluated";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "errorOccurred";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluationComplete";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

