/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diff.impl.DiffUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.impl.XEditorSourcePosition;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.ToggleLineBreakpointAction;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointTypeProxy;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler;", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "myTemporary", "", "<init>", "(Z)V", "isEnabled", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "toggleLineBreakpoint", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nXToggleLineBreakpointActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XToggleLineBreakpointActionHandler.kt\ncom/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,89:1\n37#2,2:90\n*S KotlinDebug\n*F\n+ 1 XToggleLineBreakpointActionHandler.kt\ncom/intellij/xdebugger/impl/actions/handlers/XToggleLineBreakpointActionHandler\n*L\n86#1:90,2\n*E\n"})
public final class XToggleLineBreakpointActionHandler
extends DebuggerActionHandler {
    private final boolean myTemporary;

    public XToggleLineBreakpointActionHandler(boolean myTemporary) {
        this.myTemporary = myTemporary;
    }

    @Override
    public boolean isEnabled(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        if (editor == null || DiffUtil.isDiffEditor((Editor)editor)) {
            return false;
        }
        XBreakpointManagerProxy breakpointManager = XDebugManagerProxy.Companion.getInstance().getBreakpointManagerProxy(project);
        List<XLineBreakpointTypeProxy> breakpointTypes = breakpointManager.getLineBreakpointTypes();
        Collection<XEditorSourcePosition> collection = ToggleLineBreakpointAction.getAllPositionsForBreakpoints(project, event.getDataContext());
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getAllPositionsForBreakpoints(...)");
        Collection<XEditorSourcePosition> breakpointPositions = collection;
        for (XEditorSourcePosition position : breakpointPositions) {
            for (XLineBreakpointTypeProxy breakpointType : breakpointTypes) {
                VirtualFile file;
                Intrinsics.checkNotNullExpressionValue((Object)position.getFile(), (String)"getFile(...)");
                int line = position.getLine();
                if (!breakpointType.canPutAtFast(position.getEditor(), line, project).isAtLeast(ThreeState.UNSURE) && breakpointManager.findBreakpointAtLine(breakpointType, file, line) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void perform(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.toggleLineBreakpoint(project, event);
    }

    @VisibleForTesting
    @NotNull
    public final CompletableFuture<Void> toggleLineBreakpoint(@NotNull Project project, @NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Editor editor = (Editor)event.getData(CommonDataKeys.EDITOR);
        boolean isFromGutterClick = event.getData(XLineBreakpointManager.BREAKPOINT_LINE_KEY) != null;
        InputEvent inputEvent = event.getInputEvent();
        boolean isAltClick = isFromGutterClick && inputEvent != null && inputEvent.isAltDown();
        boolean isShiftClick = isFromGutterClick && inputEvent != null && inputEvent.isShiftDown();
        boolean canRemove = !isFromGutterClick || !isShiftClick && !Registry.Companion.is("debugger.click.disable.breakpoints");
        boolean isLoggingBreakpoint = isFromGutterClick && editor != null && inputEvent instanceof MouseEvent && !isAltClick && isShiftClick;
        String selection = isLoggingBreakpoint ? editor.getSelectionModel().getSelectedText() : null;
        HashSet<Integer> processedLines = new HashSet<Integer>();
        List futures = new ArrayList();
        for (XEditorSourcePosition position : ToggleLineBreakpointAction.getAllPositionsForBreakpoints(project, event.getDataContext())) {
            if (!processedLines.add(position.getLine())) continue;
            Intrinsics.checkNotNull((Object)position);
            CompletionStage future = XBreakpointUtil.toggleLineBreakpointProxy(project, position, !isFromGutterClick, position.getEditor(), isAltClick || this.myTemporary, !isFromGutterClick, canRemove, isLoggingBreakpoint, selection).thenAccept(arg_0 -> XToggleLineBreakpointActionHandler.toggleLineBreakpoint$lambda$1(arg_0 -> XToggleLineBreakpointActionHandler.toggleLineBreakpoint$lambda$0(isLoggingBreakpoint, inputEvent, editor, project, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)future);
            futures.add(future);
        }
        Collection $this$toTypedArray$iv = futures;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, completableFutureArray.length));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"allOf(...)");
        return completableFuture;
    }

    private static final Unit toggleLineBreakpoint$lambda$0(boolean $isLoggingBreakpoint, InputEvent $inputEvent, Editor $editor, Project $project, XLineBreakpointProxy breakpoint2) {
        if (breakpoint2 != null && $isLoggingBreakpoint) {
            ActionsKt.runInEdt$default(null, () -> XToggleLineBreakpointActionHandler.toggleLineBreakpoint$lambda$0$0(breakpoint2, $inputEvent, $editor, $project), (int)1, null);
        }
        return Unit.INSTANCE;
    }

    private static final Unit toggleLineBreakpoint$lambda$0$0(XLineBreakpointProxy $breakpoint, InputEvent $inputEvent, Editor $editor, Project $project) {
        LogicalPosition position = new LogicalPosition($breakpoint.getLine() + 1, 0);
        Point point = new Point(((MouseEvent)$inputEvent).getPoint().x, $editor.logicalPositionToXY((LogicalPosition)position).y);
        Editor editor = $editor;
        Intrinsics.checkNotNull((Object)editor, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorEx");
        DebuggerUIUtil.showXBreakpointEditorBalloon($project, point, (JComponent)((EditorEx)editor).getGutterComponentEx(), false, $breakpoint);
        return Unit.INSTANCE;
    }

    private static final void toggleLineBreakpoint$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

