/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.project.Project;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxyKeeperKt;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreePanel;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0004\u001c\u001d\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tJ\b\u0010\u0014\u001a\u00020\u0011H\u0016J\u0006\u0010\u0015\u001a\u00020\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u001b\u001a\u00020\u0017H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006 "}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView;", "Lcom/intellij/xdebugger/impl/frame/XDebugView;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;)V", "Lcom/intellij/xdebugger/XDebugSession;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XDebugSession;)V", "treePanel", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTreePanel;", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "getTree", "()Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "panel", "Ljavax/swing/JPanel;", "getPanel", "()Ljavax/swing/JPanel;", "getMainComponent", "getDefaultFocusedComponent", "clear", "", "processSessionEvent", "event", "Lcom/intellij/xdebugger/impl/frame/XDebugView$SessionEvent;", "dispose", "ThreadsContainer", "FramesContainer", "FrameValue", "XThreadsRootNode", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class XThreadsView
extends XDebugView {
    @NotNull
    private final XDebuggerTreePanel treePanel;

    public XThreadsView(@NotNull Project project, final @NotNull XDebugSessionProxy session) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.treePanel = new XDebuggerTreePanel(project, session.getEditorsProvider(), this, null, "XDebugger.Threads.View.Popup", null);
        new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return true;
            }

            protected void setAutoScrollMode(boolean state) {
            }

            protected boolean needToCheckFocus() {
                return false;
            }

            @RequiresEdt
            protected void scrollToSource(Component tree) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
                    Object object = tree instanceof XDebuggerTree ? (XDebuggerTree)((Object)tree) : null;
                    if (object == null || (object = object.getSelectionPath()) == null) {
                        return;
                    }
                    Object path = object;
                    Object object2 = ((TreePath)path).getLastPathComponent();
                    XValueNodeImpl xValueNodeImpl = object2 instanceof XValueNodeImpl ? (XValueNodeImpl)object2 : null;
                    if (xValueNodeImpl == null || (xValueNodeImpl = (XValue)xValueNodeImpl.getValueContainer()) == null) break block2;
                    XValueNodeImpl xValueNodeImpl2 = xValueNodeImpl;
                    XDebugSessionProxy xDebugSessionProxy = session;
                    XValueNodeImpl xValueContainer = xValueNodeImpl2;
                    boolean bl = false;
                    if (xValueContainer instanceof FrameValue) {
                        XStackFrame xStackFrame = ((FrameValue)((Object)xValueContainer)).getFrame();
                        xDebugSessionProxy.setCurrentStackFrame(((FrameValue)((Object)xValueContainer)).getExecutionStack(), xStackFrame, false);
                    }
                }
            }
        }.install((JTree)((Object)this.getTree()));
    }

    @ApiStatus.Obsolete
    public XThreadsView(@NotNull Project project, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this(project, XDebugSessionProxyKeeperKt.asProxy(session));
    }

    @NotNull
    public final XDebuggerTree getTree() {
        XDebuggerTree xDebuggerTree = this.treePanel.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)xDebuggerTree), (String)"getTree(...)");
        return xDebuggerTree;
    }

    @NotNull
    public final JPanel getPanel() {
        JPanel jPanel = this.treePanel.getMainPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getMainPanel(...)");
        return jPanel;
    }

    @Override
    @NotNull
    public JPanel getMainComponent() {
        return this.getPanel();
    }

    @NotNull
    public final XDebuggerTree getDefaultFocusedComponent() {
        return this.getTree();
    }

    @Override
    protected void clear() {
        DebuggerUIUtil.invokeLater(() -> XThreadsView.clear$lambda$0(this));
    }

    @Override
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSessionProxy session) {
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        if (!session.hasSuspendContext()) {
            this.requestClear();
            return;
        }
        if (event == XDebugView.SessionEvent.FRAME_CHANGED) {
            return;
        }
        if (event == XDebugView.SessionEvent.PAUSED) {
            this.cancelClear();
            this.clear();
        }
        DebuggerUIUtil.invokeLater(() -> XThreadsView.processSessionEvent$lambda$0(this, session));
    }

    public void dispose() {
    }

    private static final void clear$lambda$0(XThreadsView this$0) {
        XDebuggerTree xDebuggerTree = this$0.getTree();
        XValueContainer xValueContainer = new XValueContainer(){};
        this$0.getTree().setRoot(new XValueContainerNode<XValueContainer>(xDebuggerTree, xValueContainer){}, false);
    }

    private static final void processSessionEvent$lambda$0(XThreadsView this$0, XDebugSessionProxy $session) {
        this$0.getTree().setRoot(new XThreadsRootNode(this$0.getTree(), $session), false);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$FrameValue;", "Lcom/intellij/xdebugger/frame/XValue;", "executionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "frame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "<init>", "(Lcom/intellij/xdebugger/frame/XExecutionStack;Lcom/intellij/xdebugger/frame/XStackFrame;)V", "getExecutionStack", "()Lcom/intellij/xdebugger/frame/XExecutionStack;", "getFrame", "()Lcom/intellij/xdebugger/frame/XStackFrame;", "computePresentation", "", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.platform.debugger.impl"})
    public static final class FrameValue
    extends XValue {
        @NotNull
        private final XExecutionStack executionStack;
        @NotNull
        private final XStackFrame frame;

        public FrameValue(@NotNull XExecutionStack executionStack, @NotNull XStackFrame frame) {
            Intrinsics.checkNotNullParameter((Object)executionStack, (String)"executionStack");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            this.executionStack = executionStack;
            this.frame = frame;
        }

        @NotNull
        public final XExecutionStack getExecutionStack() {
            return this.executionStack;
        }

        @NotNull
        public final XStackFrame getFrame() {
            return this.frame;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            SimpleColoredComponent component = new SimpleColoredComponent();
            this.frame.customizeTextPresentation((ColoredTextContainer)component);
            node.setPresentation(component.getIcon(), new XValuePresentation(component){
                final /* synthetic */ SimpleColoredComponent $component;
                {
                    this.$component = $component;
                }

                public String getSeparator() {
                    return "";
                }

                public void renderValue(XValuePresentation.XValueTextRenderer renderer) {
                    Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
                    SimpleColoredComponent.ColoredIterator coloredIterator = this.$component.iterator();
                    Intrinsics.checkNotNullExpressionValue((Object)coloredIterator, (String)"iterator(...)");
                    SimpleColoredComponent.ColoredIterator i = coloredIterator;
                    while (i.hasNext()) {
                        String text;
                        i.next();
                        Intrinsics.checkNotNullExpressionValue((Object)i.getFragment(), (String)"getFragment(...)");
                        SimpleTextAttributes simpleTextAttributes = i.getTextAttributes();
                        if (Intrinsics.areEqual((Object)simpleTextAttributes, (Object)SimpleTextAttributes.GRAYED_ATTRIBUTES)) {
                            renderer.renderComment(text);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)simpleTextAttributes, (Object)SimpleTextAttributes.ERROR_ATTRIBUTES)) {
                            renderer.renderError(text);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)simpleTextAttributes, (Object)SimpleTextAttributes.REGULAR_ATTRIBUTES)) continue;
                        renderer.renderValue(text);
                    }
                }
            }, false);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$FramesContainer;", "Lcom/intellij/xdebugger/frame/XValue;", "executionStack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "<init>", "(Lcom/intellij/xdebugger/frame/XExecutionStack;)V", "getExecutionStack", "()Lcom/intellij/xdebugger/frame/XExecutionStack;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "intellij.platform.debugger.impl"})
    public static final class FramesContainer
    extends XValue {
        @NotNull
        private final XExecutionStack executionStack;

        public FramesContainer(@NotNull XExecutionStack executionStack) {
            Intrinsics.checkNotNullParameter((Object)executionStack, (String)"executionStack");
            this.executionStack = executionStack;
        }

        @NotNull
        public final XExecutionStack getExecutionStack() {
            return this.executionStack;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.executionStack.computeStackFrames(0, new XExecutionStack.XStackFrameContainer(node, this){
                final /* synthetic */ XCompositeNode $node;
                final /* synthetic */ FramesContainer this$0;
                {
                    this.$node = $node;
                    this.this$0 = $receiver;
                }

                public void errorOccurred(String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                }

                /*
                 * WARNING - void declaration
                 */
                public void addStackFrames(List<? extends XStackFrame> stackFrames, boolean last) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter(stackFrames, (String)"stackFrames");
                    XValueChildrenList children = new XValueChildrenList();
                    Iterable iterable = stackFrames;
                    FramesContainer framesContainer = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        XStackFrame it = (XStackFrame)element$iv;
                        boolean bl = false;
                        children.add("", (XValue)new FrameValue(framesContainer.getExecutionStack(), it));
                    }
                    this.$node.addChildren(children, last);
                }
            });
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            node.setPresentation(this.executionStack.getIcon(), (XValuePresentation)new XRegularValuePresentation(this.executionStack.getDisplayName(), null, ""), true);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$ThreadsContainer;", "Lcom/intellij/xdebugger/frame/XValueContainer;", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "<init>", "(Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;)V", "getSession", "()Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "intellij.platform.debugger.impl"})
    public static final class ThreadsContainer
    extends XValueContainer {
        @NotNull
        private final XDebugSessionProxy session;

        public ThreadsContainer(@NotNull XDebugSessionProxy session) {
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final XDebugSessionProxy getSession() {
            return this.session;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.session.computeExecutionStacks((Function0<? extends XSuspendContext.XExecutionStackContainer>)((Function0)() -> ThreadsContainer.computeChildren$lambda$0(node)));
        }

        private static final XSuspendContext.XExecutionStackContainer computeChildren$lambda$0(XCompositeNode $node) {
            return new XSuspendContext.XExecutionStackContainer($node){
                final /* synthetic */ XCompositeNode $node;
                {
                    this.$node = $node;
                }

                public void errorOccurred(String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                }

                /*
                 * WARNING - void declaration
                 */
                public void addExecutionStack(List<? extends XExecutionStack> executionStacks, boolean last) {
                    void $this$forEach$iv;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(executionStacks, (String)"executionStacks");
                    XValueChildrenList children = new XValueChildrenList();
                    Iterable $this$map$iv = executionStacks;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        XExecutionStack xExecutionStack = (XExecutionStack)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(new FramesContainer((XExecutionStack)it));
                    }
                    $this$map$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        FramesContainer it = (FramesContainer)((Object)element$iv);
                        boolean bl = false;
                        children.add("", (XValue)it);
                    }
                    this.$node.addChildren(children, last);
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/frame/XThreadsView$XThreadsRootNode;", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueContainerNode;", "Lcom/intellij/xdebugger/impl/frame/XThreadsView$ThreadsContainer;", "tree", "Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "<init>", "(Lcom/intellij/xdebugger/impl/ui/tree/XDebuggerTree;Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;)V", "intellij.platform.debugger.impl"})
    public static final class XThreadsRootNode
    extends XValueContainerNode<ThreadsContainer> {
        public XThreadsRootNode(@NotNull XDebuggerTree tree, @NotNull XDebugSessionProxy session) {
            Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            super(tree, null, false, (XValueContainer)new ThreadsContainer(session));
        }
    }
}

