/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Constraints;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.evaluate.quick.XDebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.XDebuggerTextPopup;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.inline.InlineWatchNodeImpl;
import com.intellij.xdebugger.impl.inline.XDebuggerTreeInlayPopup;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Point;
import java.util.Collections;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promises;

@ApiStatus.Internal
@ApiStatus.Experimental
public class XDebuggerTextInlayPopup<D>
extends XDebuggerTextPopup<D> {
    @NotNull
    private final XSourcePosition myPosition;
    @NotNull
    private final XDebugSessionProxy mySession;
    @NotNull
    private final XValueNodeImpl myValueNode;

    private XDebuggerTextInlayPopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull XValue value, @NotNull D initialItem, @NotNull Editor editor, @NotNull Point point, @NotNull XSourcePosition presentationPosition, @NotNull XDebugSessionProxy session, @Nullable Runnable hideRunnable, @NotNull XValueNodeImpl valueNode2) {
        if (creator == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(0);
        }
        if (value == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(1);
        }
        if (initialItem == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(3);
        }
        if (point == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(4);
        }
        if (presentationPosition == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(5);
        }
        if (session == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(6);
        }
        if (valueNode2 == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(7);
        }
        super(valueNode2.getFullValueEvaluator(), value, creator, initialItem, editor, point, session.getProject(), hideRunnable);
        this.myPosition = presentationPosition;
        this.mySession = session;
        this.myValueNode = valueNode2;
    }

    @Override
    @NotNull
    protected DefaultActionGroup getToolbarActions() {
        DefaultActionGroup toolbarActions = super.getToolbarActions();
        if (Registry.is((String)"debugger.watches.inline.enabled")) {
            AnAction watchAction = this.myValueNode instanceof InlineWatchNodeImpl ? new EditInlineWatch() : new AddInlineWatch();
            toolbarActions.add(watchAction, Constraints.LAST);
        }
        DefaultActionGroup defaultActionGroup = toolbarActions;
        if (defaultActionGroup == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(8);
        }
        return defaultActionGroup;
    }

    @Override
    protected void showTreePopup(Runnable hideTreeRunnable) {
        XDebuggerTreeInlayPopup.showTreePopup(this.myTreeCreator, this.myInitialItem, this.myValueNode, this.myEditor, this.myPoint, this.myPosition, this.mySession, hideTreeRunnable);
    }

    public static void showTextPopup(@NotNull String initialText, @NotNull XDebuggerTreeCreator creator, @NotNull Pair<XValue, String> initialItem, @NotNull XValueNodeImpl valueNode2, @NotNull Editor editor, @NotNull Point point, @NotNull XSourcePosition position, @NotNull XDebugSessionProxy session, Runnable hideRunnable) {
        if (initialText == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(9);
        }
        if (creator == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(10);
        }
        if (initialItem == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(11);
        }
        if (valueNode2 == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(13);
        }
        if (point == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(14);
        }
        if (position == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(15);
        }
        if (session == null) {
            XDebuggerTextInlayPopup.$$$reportNull$$$0(16);
        }
        new XDebuggerTextInlayPopup<Pair<XValue, String>>(creator, (XValue)initialItem.first, initialItem, editor, point, position, session, hideRunnable, valueNode2).show(initialText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "creator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialItem";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationPosition";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/inline/XDebuggerTextInlayPopup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/inline/XDebuggerTextInlayPopup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showTextPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    private class EditInlineWatch
    extends AnAction {
        private EditInlineWatch() {
            super(XDebuggerBundle.message((String)"debugger.inline.watches.edit.watch.expression.text", (Object[])new Object[0]));
        }

        public boolean displayTextInToolbar() {
            return true;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                EditInlineWatch.$$$reportNull$$$0(0);
            }
            InlineWatchNodeImpl watch = (InlineWatchNodeImpl)XDebuggerTextInlayPopup.this.myValueNode;
            XDebuggerWatchesManager watchesManager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)XDebuggerTextInlayPopup.this.mySession.getProject())).getWatchesManager();
            watchesManager.inlineWatchesRemoved(Collections.singletonList(watch.getWatch()), null);
            watchesManager.showInplaceEditor(watch.getPosition(), XDebuggerTextInlayPopup.this.myEditor, XDebuggerTextInlayPopup.this.mySession, watch.getExpression());
            XDebuggerTextInlayPopup.this.hideTextPopup();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/inline/XDebuggerTextInlayPopup$EditInlineWatch", "actionPerformed"));
        }
    }

    private class AddInlineWatch
    extends AnAction {
        private AddInlineWatch() {
            ActionUtil.mergeFrom((AnAction)this, (String)"Debugger.AddInlineWatch");
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(XDebuggerBundle.message((String)"debugger.inline.watches.popup.action.add.as.inline.watch", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                AddInlineWatch.$$$reportNull$$$0(0);
            }
            XDebuggerTextInlayPopup.this.myValueNode.calculateEvaluationExpression().thenAsync(expr -> Promises.resolvedPromise((Object)expr)).onSuccess(expr -> AppUIUtil.invokeOnEdt(() -> {
                XDebuggerWatchesManager manager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)XDebuggerTextInlayPopup.this.mySession.getProject())).getWatchesManager();
                manager.showInplaceEditor(XDebuggerTextInlayPopup.this.myPosition, XDebuggerTextInlayPopup.this.myEditor, XDebuggerTextInlayPopup.this.mySession, (XExpression)expr);
                XDebuggerTextInlayPopup.this.hideTextPopup();
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/inline/XDebuggerTextInlayPopup$AddInlineWatch", "actionPerformed"));
        }
    }
}

