/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.rpc.models;

import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.platform.debugger.impl.rpc.XValueAdvancedPresentationPart;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u000b\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0015\u0010\u0010\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0015\u0010\u0011\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0015\u0010\u0012\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u001d\u0010\u000b\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J,\u0010\u0010\u001a\u00020\f2\u000b\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f2\r\u0010\u0015\u001a\t\u0018\u00010\u000e\u00a2\u0006\u0002\b\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0015\u0010\u0018\u001a\u00020\f2\u000b\u0010\u0019\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0015\u0010\u001a\u001a\u00020\f2\u000b\u0010\u001b\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0015\u0010\u001c\u001a\u00020\f2\u000b\u0010\u001d\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001e"}, d2={"Lcom/intellij/xdebugger/impl/rpc/models/XValueTextRendererPartsCollector;", "Lcom/intellij/xdebugger/frame/presentation/XValuePresentation$XValueTextRenderer;", "<init>", "()V", "_parts", "", "Lcom/intellij/platform/debugger/impl/rpc/XValueAdvancedPresentationPart;", "parts", "", "getParts", "()Ljava/util/List;", "renderValue", "", "value", "", "Lcom/intellij/openapi/util/NlsSafe;", "renderStringValue", "renderNumericValue", "renderKeywordValue", "key", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "additionalSpecialCharsToHighlight", "maxLength", "", "renderComment", "comment", "renderSpecialSymbol", "symbol", "renderError", "error", "intellij.platform.debugger.impl"})
final class XValueTextRendererPartsCollector
implements XValuePresentation.XValueTextRenderer {
    @NotNull
    private final List<XValueAdvancedPresentationPart> _parts = new ArrayList();

    @NotNull
    public final List<XValueAdvancedPresentationPart> getParts() {
        return this._parts;
    }

    public void renderValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.Value(value));
    }

    public void renderStringValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.StringValue(value));
    }

    public void renderNumericValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.NumericValue(value));
    }

    public void renderKeywordValue(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.KeywordValue(value));
    }

    public void renderValue(@NotNull String value, @NotNull TextAttributesKey key) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.ValueWithAttributes(value, key));
    }

    public void renderStringValue(@NotNull String value, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.StringValueWithHighlighting(value, additionalSpecialCharsToHighlight, maxLength));
    }

    public void renderComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.Comment(comment));
    }

    public void renderSpecialSymbol(@NotNull String symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.SpecialSymbol(symbol));
    }

    public void renderError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this._parts.add((XValueAdvancedPresentationPart)new XValueAdvancedPresentationPart.Error(error));
    }
}

