/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.settings.DataViewsConfigurable;
import com.intellij.xdebugger.impl.settings.MergedCompositeConfigurable;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DebuggerConfigurable
implements SearchableConfigurable.Parent {
    static final Configurable[] EMPTY_CONFIGURABLES = new Configurable[0];
    private static final DebuggerSettingsCategory[] MERGED_CATEGORIES = new DebuggerSettingsCategory[]{DebuggerSettingsCategory.STEPPING, DebuggerSettingsCategory.HOTSWAP};
    private Configurable myRootConfigurable;
    private Configurable[] myChildren;

    public String getDisplayName() {
        return DebuggerConfigurable.getDisplayNameText();
    }

    public String getHelpTopic() {
        return "reference.idesettings.debugger";
    }

    public Configurable @NotNull [] getConfigurables() {
        this.compute();
        if (this.myChildren.length == 0 && this.myRootConfigurable instanceof SearchableConfigurable.Parent) {
            Configurable[] configurableArray = ((SearchableConfigurable.Parent)this.myRootConfigurable).getConfigurables();
            if (configurableArray == null) {
                DebuggerConfigurable.$$$reportNull$$$0(0);
            }
            return configurableArray;
        }
        if (this.myChildren == null) {
            DebuggerConfigurable.$$$reportNull$$$0(1);
        }
        return this.myChildren;
    }

    private void compute() {
        if (this.myChildren != null) {
            return;
        }
        SmartList configurables = new SmartList();
        configurables.add(new DataViewsConfigurable());
        List providers = DebuggerConfigurableProvider.EXTENSION_POINT.getExtensionList();
        DebuggerConfigurable.computeMergedConfigurables(providers, (List<? super Configurable>)configurables);
        for (DebuggerConfigurableProvider provider : providers) {
            configurables.addAll(provider.getConfigurables(DebuggerSettingsCategory.ROOT));
        }
        MergedCompositeConfigurable mergedGeneralConfigurable = this.computeGeneralConfigurables(providers);
        if (configurables.isEmpty() && mergedGeneralConfigurable == null) {
            this.myRootConfigurable = null;
            this.myChildren = EMPTY_CONFIGURABLES;
        } else if (configurables.size() == 1) {
            Configurable firstConfigurable = (Configurable)configurables.get(0);
            if (mergedGeneralConfigurable == null) {
                this.myRootConfigurable = firstConfigurable;
                this.myChildren = EMPTY_CONFIGURABLES;
            } else {
                Configurable[] mergedArray = (Configurable[])ArrayUtil.append((Object[])mergedGeneralConfigurable.children, (Object)firstConfigurable);
                this.myRootConfigurable = new MergedCompositeConfigurable(this.getId(), this.getDisplayName(), null, mergedArray);
                this.myChildren = firstConfigurable instanceof SearchableConfigurable.Parent ? ((SearchableConfigurable.Parent)firstConfigurable).getConfigurables() : EMPTY_CONFIGURABLES;
            }
        } else {
            this.myChildren = configurables.toArray(new Configurable[0]);
            this.myRootConfigurable = mergedGeneralConfigurable;
        }
    }

    private static void computeMergedConfigurables(List<DebuggerConfigurableProvider> providers, @NotNull List<? super Configurable> result2) {
        if (result2 == null) {
            DebuggerConfigurable.$$$reportNull$$$0(2);
        }
        for (DebuggerSettingsCategory category : MERGED_CATEGORIES) {
            List<Configurable> configurables = DebuggerConfigurable.getConfigurables(category, providers);
            if (configurables.isEmpty()) continue;
            String id = StringUtil.toLowerCase((String)category.name());
            result2.add((Configurable)new MergedCompositeConfigurable("debugger." + id, XDebuggerBundle.message((String)("debugger." + id + ".display.name"), (Object[])new Object[0]), DebuggerConfigurable.getDefaultCategoryHelpTopic(category), configurables.toArray(new Configurable[0])));
        }
    }

    @Nullable
    private MergedCompositeConfigurable computeGeneralConfigurables(List<DebuggerConfigurableProvider> providers) {
        List<Configurable> rootConfigurables = DebuggerConfigurable.getConfigurables(DebuggerSettingsCategory.GENERAL, providers);
        if (rootConfigurables.isEmpty()) {
            return null;
        }
        Configurable[] mergedRootConfigurables = rootConfigurables.toArray(new Configurable[0]);
        Arrays.sort(mergedRootConfigurables, (o1, o2) -> {
            boolean c1e = StringUtil.isEmpty((String)o1.getDisplayName());
            return c1e == StringUtil.isEmpty((String)o2.getDisplayName()) ? 0 : (c1e ? -1 : 1);
        });
        return new MergedCompositeConfigurable(this.getId(), this.getDisplayName(), null, mergedRootConfigurables);
    }

    public void apply() throws ConfigurationException {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.apply();
        }
    }

    public boolean hasOwnContent() {
        this.compute();
        return this.myRootConfigurable != null;
    }

    public JComponent createComponent() {
        this.compute();
        return this.myRootConfigurable != null ? this.myRootConfigurable.createComponent() : null;
    }

    public boolean isModified() {
        return this.myRootConfigurable != null && this.myRootConfigurable.isModified();
    }

    public void reset() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.reset();
        }
    }

    public void disposeUIResources() {
        if (this.myRootConfigurable != null) {
            this.myRootConfigurable.disposeUIResources();
        }
    }

    @NotNull
    @NonNls
    public String getId() {
        return "project.propDebugger";
    }

    static @Unmodifiable @NotNull List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category) {
        if (category == null) {
            DebuggerConfigurable.$$$reportNull$$$0(3);
        }
        return DebuggerConfigurable.getConfigurables(category, DebuggerConfigurableProvider.EXTENSION_POINT.getExtensionList());
    }

    private static @Unmodifiable @NotNull List<Configurable> getConfigurables(@NotNull DebuggerSettingsCategory category, List<DebuggerConfigurableProvider> providers) {
        if (category == null) {
            DebuggerConfigurable.$$$reportNull$$$0(4);
        }
        List configurables = null;
        for (DebuggerConfigurableProvider provider : providers) {
            Collection providerConfigurables = provider.getConfigurables(category);
            if (providerConfigurables.isEmpty()) continue;
            if (configurables == null) {
                configurables = new SmartList();
            }
            configurables.addAll(providerConfigurables);
        }
        List list = ContainerUtil.notNullize(configurables);
        if (list == null) {
            DebuggerConfigurable.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static String getDefaultCategoryHelpTopic(DebuggerSettingsCategory category) {
        return switch (category) {
            case DebuggerSettingsCategory.STEPPING -> "reference.idesettings.debugger.stepping";
            case DebuggerSettingsCategory.HOTSWAP -> "reference.idesettings.debugger.hotswap";
            default -> null;
        };
    }

    @Nls
    public static String getDisplayNameText() {
        return XDebuggerBundle.message((String)"debugger.configurable.display.name", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/settings/DebuggerConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "category";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/settings/DebuggerConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "computeMergedConfigurables";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurables";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

