/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.actions.CustomContentLayoutSettings;
import com.intellij.execution.ui.layout.actions.RestoreViewAction;
import com.intellij.execution.ui.layout.actions.ViewLayoutModeActionGroup;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.custom.options.ContentLayoutStateSettings;
import com.intellij.ui.content.custom.options.CustomContentLayoutOption;
import com.intellij.ui.content.custom.options.CustomContentLayoutOptions;
import com.intellij.ui.content.custom.options.PersistentContentCustomLayoutOption;
import com.intellij.ui.content.custom.options.PersistentContentCustomLayoutOptions;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesView;
import com.intellij.xdebugger.impl.ui.DefaultLayoutOption;
import com.intellij.xdebugger.impl.ui.FramesAndThreadsLayoutOptionBase;
import com.intellij.xdebugger.impl.ui.FramesOnlyLayoutOption;
import com.intellij.xdebugger.impl.ui.SideBySideLayoutOption;
import com.intellij.xdebugger.impl.ui.ThreadsTreeLayoutOption;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab3;
import com.intellij.xdebugger.impl.ui.XDebugThreadsFramesViewChangeCollector;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001f !B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001aH\u0002J\b\u0010\u001d\u001a\u00020\u0017H\u0002J\b\u0010\u001e\u001a\u00020\u0017H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\b\u001a\u00060\tR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\rR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings;", "Lcom/intellij/execution/ui/layout/actions/CustomContentLayoutSettings;", "content", "Lcom/intellij/ui/content/Content;", "debugTab", "Lcom/intellij/xdebugger/impl/ui/XDebugSessionTab3;", "<init>", "(Lcom/intellij/ui/content/Content;Lcom/intellij/xdebugger/impl/ui/XDebugSessionTab3;)V", "threadsAndFramesOptions", "Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings$XDebugFramesAndThreadsLayoutOptions;", "getThreadsAndFramesOptions", "()Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings$XDebugFramesAndThreadsLayoutOptions;", "variablesLayoutSettings", "Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings$XDebugVariablesLayoutSettings;", "getVariablesLayoutSettings", "()Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings$XDebugVariablesLayoutSettings;", "myContentUI", "Lcom/intellij/execution/ui/layout/impl/RunnerContentUi;", "getActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "runnerContentUi", "restore", "", "onThreadsSettingsChanged", "isHidden", "", "onVariablesSettingsChanged", "visible", "enableTabIfNeeded", "hideContent", "Companion", "XDebugFramesAndThreadsLayoutOptions", "XDebugVariablesLayoutSettings", "intellij.platform.debugger.impl"})
@ApiStatus.Internal
public final class XDebugTabLayoutSettings
implements CustomContentLayoutSettings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Content content;
    @NotNull
    private final XDebugSessionTab3 debugTab;
    @NotNull
    private final XDebugFramesAndThreadsLayoutOptions threadsAndFramesOptions;
    @NotNull
    private final XDebugVariablesLayoutSettings variablesLayoutSettings;
    @Nullable
    private RunnerContentUi myContentUI;
    @NotNull
    public static final String THREADS_VIEW_SETTINGS_KEY = "ThreadsFramesSelectedView";
    @NotNull
    private static final String VARIABLES_VIEW_SETTINGS_KEY = "VariablesViewMinimized";

    public XDebugTabLayoutSettings(@NotNull Content content, @NotNull XDebugSessionTab3 debugTab) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)((Object)debugTab), (String)"debugTab");
        this.content = content;
        this.debugTab = debugTab;
        this.threadsAndFramesOptions = new XDebugFramesAndThreadsLayoutOptions(this.content, this.debugTab);
        this.variablesLayoutSettings = new XDebugVariablesLayoutSettings(this.content);
    }

    @NotNull
    public final XDebugFramesAndThreadsLayoutOptions getThreadsAndFramesOptions() {
        return this.threadsAndFramesOptions;
    }

    @NotNull
    public final XDebugVariablesLayoutSettings getVariablesLayoutSettings() {
        return this.variablesLayoutSettings;
    }

    @NotNull
    public List<AnAction> getActions(@NotNull RunnerContentUi runnerContentUi) {
        Intrinsics.checkNotNullParameter((Object)runnerContentUi, (String)"runnerContentUi");
        this.myContentUI = runnerContentUi;
        Object[] objectArray = new AnAction[]{new ViewLayoutModeActionGroup(this.content, (CustomContentLayoutOptions)this.threadsAndFramesOptions), new RestoreViewAction(this.content, (ContentLayoutStateSettings)this.variablesLayoutSettings)};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public void restore() {
        this.threadsAndFramesOptions.restore();
        this.variablesLayoutSettings.restore();
    }

    private final void onThreadsSettingsChanged(boolean isHidden) {
        if (isHidden) {
            if (!this.variablesLayoutSettings.isSelected()) {
                this.hideContent();
            }
        } else {
            this.enableTabIfNeeded();
        }
    }

    private final void onVariablesSettingsChanged(boolean visible) {
        if (visible) {
            this.enableTabIfNeeded();
        } else if (this.threadsAndFramesOptions.isHidden()) {
            this.hideContent();
        }
    }

    private final void enableTabIfNeeded() {
        RunnerLayoutUi runnerLayoutUi = this.debugTab.getUi();
        RunnerLayoutUiImpl runnerLayoutUiImpl = runnerLayoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)runnerLayoutUi : null;
        if (runnerLayoutUiImpl == null) {
            return;
        }
        RunnerLayoutUiImpl ui = runnerLayoutUiImpl;
        RunnerContentUi runnerContentUi = ui.getContentUI();
        Intrinsics.checkNotNullExpressionValue((Object)runnerContentUi, (String)"getContentUI(...)");
        RunnerContentUi contentUi = runnerContentUi;
        if (!this.threadsAndFramesOptions.isContentVisible()) {
            contentUi.restore(this.content);
            contentUi.select(this.content, true);
        }
    }

    private final void hideContent() {
        RunnerLayoutUi runnerLayoutUi = this.debugTab.getUi();
        RunnerLayoutUiImpl runnerLayoutUiImpl = runnerLayoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)runnerLayoutUi : null;
        if (runnerLayoutUiImpl == null) {
            return;
        }
        RunnerLayoutUiImpl ui = runnerLayoutUiImpl;
        RunnerContentUi runnerContentUi = ui.getContentUI();
        Intrinsics.checkNotNullExpressionValue((Object)runnerContentUi, (String)"getContentUI(...)");
        RunnerContentUi contentUi = runnerContentUi;
        contentUi.minimize(this.content, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings$Companion;", "", "<init>", "()V", "THREADS_VIEW_SETTINGS_KEY", "", "VARIABLES_VIEW_SETTINGS_KEY", "isVariablesViewVisible", "", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isVariablesViewVisible() {
            return !PropertiesComponent.getInstance().getBoolean(XDebugTabLayoutSettings.VARIABLES_VIEW_SETTINGS_KEY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u0013\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\b\u0010\u0019\u001a\u00020\u0015H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings$XDebugFramesAndThreadsLayoutOptions;", "Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOptions;", "content", "Lcom/intellij/ui/content/Content;", "debugTab", "Lcom/intellij/xdebugger/impl/ui/XDebugSessionTab3;", "<init>", "(Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings;Lcom/intellij/ui/content/Content;Lcom/intellij/xdebugger/impl/ui/XDebugSessionTab3;)V", "getContent", "()Lcom/intellij/ui/content/Content;", "getDebugTab", "()Lcom/intellij/xdebugger/impl/ui/XDebugSessionTab3;", "options", "", "Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOption;", "[Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOption;", "doSelect", "", "option", "Lcom/intellij/ui/content/custom/options/CustomContentLayoutOption;", "getDefaultOptionKey", "", "getAvailableOptions", "()[Lcom/intellij/ui/content/custom/options/PersistentContentCustomLayoutOption;", "onHide", "getDisplayName", "isHideOptionVisible", "", "intellij.platform.debugger.impl"})
    public final class XDebugFramesAndThreadsLayoutOptions
    extends PersistentContentCustomLayoutOptions {
        @NotNull
        private final Content content;
        @NotNull
        private final XDebugSessionTab3 debugTab;
        @NotNull
        private final PersistentContentCustomLayoutOption[] options;

        public XDebugFramesAndThreadsLayoutOptions(@NotNull Content content, XDebugSessionTab3 debugTab) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)((Object)debugTab), (String)"debugTab");
            super(content, XDebugTabLayoutSettings.THREADS_VIEW_SETTINGS_KEY);
            this.content = content;
            this.debugTab = debugTab;
            PersistentContentCustomLayoutOption[] persistentContentCustomLayoutOptionArray = new PersistentContentCustomLayoutOption[]{new DefaultLayoutOption(this), new ThreadsTreeLayoutOption(this), new SideBySideLayoutOption(this), new FramesOnlyLayoutOption(this)};
            this.options = persistentContentCustomLayoutOptionArray;
        }

        @NotNull
        public final Content getContent() {
            return this.content;
        }

        @NotNull
        public final XDebugSessionTab3 getDebugTab() {
            return this.debugTab;
        }

        protected void doSelect(@NotNull CustomContentLayoutOption option) {
            Intrinsics.checkNotNullParameter((Object)option, (String)"option");
            if ((option instanceof FramesAndThreadsLayoutOptionBase ? (FramesAndThreadsLayoutOptionBase)option : null) == null) {
                throw new IllegalStateException("Unexpected option type: " + option.getClass());
            }
            if (!((FramesAndThreadsLayoutOptionBase)option).isSelected()) {
                XDebugSessionProxy xDebugSessionProxy = this.debugTab.mySession;
                if (xDebugSessionProxy != null) {
                    XDebugSessionProxy it = xDebugSessionProxy;
                    boolean bl = false;
                    XDebugView newView = ((FramesAndThreadsLayoutOptionBase)option).createView(it);
                    this.debugTab.registerThreadsView$intellij_platform_debugger_impl(this.content, newView);
                }
                XDebugThreadsFramesViewChangeCollector.INSTANCE.framesViewSelected(((FramesAndThreadsLayoutOptionBase)option).getOptionKey());
                Object object = this.debugTab.getView("FrameContent", XDebugView.class);
                if (object != null && (object = ((XDebugView)object).getMainComponent()) != null) {
                    ((JComponent)object).setVisible(true);
                }
            }
            XDebugTabLayoutSettings.this.onThreadsSettingsChanged(false);
        }

        @NotNull
        protected String getDefaultOptionKey() {
            String string = this.debugTab.getDefaultFramesViewKey();
            if (string == null) {
                string = Registry.Companion.stringValue("debugger.default.selected.view.key");
            }
            return string;
        }

        @NotNull
        public PersistentContentCustomLayoutOption[] getAvailableOptions() {
            return this.options;
        }

        public void onHide() {
            super.onHide();
            XDebugThreadsFramesViewChangeCollector.INSTANCE.framesViewSelected("Hidden");
            Object object = this.debugTab.getView("FrameContent", XDebugView.class);
            if (object != null && (object = ((XDebugView)object).getMainComponent()) != null) {
                ((JComponent)object).setVisible(false);
            }
            XDebugTabLayoutSettings.this.onThreadsSettingsChanged(true);
        }

        @NotNull
        public String getDisplayName() {
            String string = XDebuggerBundle.message((String)"xdebugger.threads.tab.layout.settings.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public boolean isHideOptionVisible() {
            if (super.isHideOptionVisible()) {
                return true;
            }
            return XDebugTabLayoutSettings.this.getVariablesLayoutSettings().isSelected();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings$XDebugVariablesLayoutSettings;", "Lcom/intellij/ui/content/custom/options/ContentLayoutStateSettings;", "content", "Lcom/intellij/ui/content/Content;", "<init>", "(Lcom/intellij/xdebugger/impl/ui/XDebugTabLayoutSettings;Lcom/intellij/ui/content/Content;)V", "getContent", "()Lcom/intellij/ui/content/Content;", "isSelected", "", "setSelected", "", "state", "getDisplayName", "", "restore", "isEnabled", "intellij.platform.debugger.impl"})
    public final class XDebugVariablesLayoutSettings
    implements ContentLayoutStateSettings {
        @NotNull
        private final Content content;

        public XDebugVariablesLayoutSettings(Content content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            this.content = content;
        }

        @NotNull
        public final Content getContent() {
            return this.content;
        }

        public boolean isSelected() {
            JComponent jComponent;
            XVariablesView xVariablesView = XDebugTabLayoutSettings.this.debugTab.getView("VariablesContent", XVariablesView.class);
            return xVariablesView != null && (jComponent = xVariablesView.getMainComponent()) != null ? jComponent.isVisible() : false;
        }

        public void setSelected(boolean state) {
            Object object;
            Object object2 = XDebugTabLayoutSettings.this.debugTab.getView("VariablesContent", XVariablesView.class);
            if (object2 != null && (object2 = ((XVariablesView)object2).getMainComponent()) != null) {
                ((JComponent)object2).setVisible(state);
            }
            if ((object = XDebugTabLayoutSettings.this.debugTab.getView("WatchesContent", XVariablesView.class)) != null && (object = ((XVariablesView)object).getMainComponent()) != null) {
                ((JComponent)object).setVisible(state);
            }
            PropertiesComponent.getInstance().setValue(XDebugTabLayoutSettings.VARIABLES_VIEW_SETTINGS_KEY, !state);
            XDebugTabLayoutSettings.this.onVariablesSettingsChanged(state);
        }

        @NotNull
        public String getDisplayName() {
            String string = XDebuggerBundle.message((String)"debugger.session.tab.variables.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void restore() {
            this.setSelected(true);
        }

        public boolean isEnabled() {
            Content[] contentArray;
            return !this.isSelected() || ((contentArray = this.content.getManager()) != null && (contentArray = contentArray.getContents()) != null ? contentArray.length : 0) > 1 || !XDebugTabLayoutSettings.this.getThreadsAndFramesOptions().isHidden();
        }
    }
}

