/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog.items.tree;

import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.tree.AttachTreeModel;
import com.intellij.xdebugger.impl.ui.attach.dialog.items.tree.FilteringTreeTableModelKt;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\bH\u0016J\u001c\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\u0012\u0010\u0012\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\bH\u0016J\u0012\u0010\u0013\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u0016J\u001c\u0010\u001a\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\nH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\nH\u0016J\u0014\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010#\u001a\u00020\nH\u0016J\u001a\u0010&\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\nH\u0016J\u001a\u0010'\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\nH\u0016J$\u0010(\u001a\u00020\u00162\b\u0010)\u001a\u0004\u0018\u00010\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\nH\u0016J\u0012\u0010*\u001a\u00020\u00162\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u001a\u0010-\u001a\u00020\u00162\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fJ\u0006\u0010.\u001a\u00020\u0016J\u001a\u0010/\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007H\u0002J*\u00100\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\b2\u0018\u00101\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t02H\u0002J\u0010\u00103\u001a\u00020\r2\u0006\u00104\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/tree/FilteringTreeTableModel;", "Lcom/intellij/ui/treeStructure/treetable/TreeTableModel;", "initialModel", "Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/tree/AttachTreeModel;", "<init>", "(Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/tree/AttachTreeModel;)V", "acceptedNodeIndex", "", "", "", "", "condition", "Lkotlin/Function1;", "", "getRoot", "getChild", "parent", "index", "getChildCount", "isLeaf", "node", "valueForPathChanged", "", "path", "Ljavax/swing/tree/TreePath;", "newValue", "getIndexOfChild", "child", "addTreeModelListener", "l", "Ljavax/swing/event/TreeModelListener;", "removeTreeModelListener", "getColumnCount", "getColumnName", "", "column", "getColumnClass", "Ljava/lang/Class;", "getValueAt", "isCellEditable", "setValueAt", "aValue", "setTree", "tree", "Ljavax/swing/JTree;", "setCondition", "refilter", "buildAcceptanceCache", "processNode", "acceptedNodesIndicesToChildren", "", "matches", "item", "intellij.platform.debugger.impl"})
public final class FilteringTreeTableModel
implements TreeTableModel {
    @NotNull
    private final AttachTreeModel initialModel;
    @NotNull
    private Map<Object, ? extends List<Integer>> acceptedNodeIndex;
    @NotNull
    private Function1<Object, Boolean> condition;

    public FilteringTreeTableModel(@NotNull AttachTreeModel initialModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)initialModel), (String)"initialModel");
        this.initialModel = initialModel;
        this.condition = FilteringTreeTableModel::condition$lambda$0;
        this.acceptedNodeIndex = this.buildAcceptanceCache();
    }

    @NotNull
    public Object getRoot() {
        return this.initialModel.getRoot();
    }

    @Nullable
    public Object getChild(@Nullable Object parent, int index) {
        List<Integer> list = this.acceptedNodeIndex.get(parent);
        if (list == null) {
            return null;
        }
        List<Integer> childrenMask = list;
        if (index < 0 || index >= childrenMask.size()) {
            return null;
        }
        int initialIndex = ((Number)childrenMask.get(index)).intValue();
        return this.initialModel.getChild(parent, initialIndex);
    }

    public int getChildCount(@Nullable Object parent) {
        List<Integer> list = this.acceptedNodeIndex.get(parent);
        return list != null ? list.size() : 0;
    }

    public boolean isLeaf(@Nullable Object node) {
        List<Integer> list = this.acceptedNodeIndex.get(node);
        return list != null ? list.isEmpty() : true;
    }

    public void valueForPathChanged(@Nullable TreePath path, @Nullable Object newValue) {
        this.initialModel.valueForPathChanged(path, newValue);
    }

    public int getIndexOfChild(@Nullable Object parent, @Nullable Object child) {
        List<Integer> list = this.acceptedNodeIndex.get(parent);
        if (list == null) {
            return -1;
        }
        List<Integer> childrenMask = list;
        int initialIndex = this.initialModel.getIndexOfChild(parent, child);
        if (initialIndex == -1) {
            return -1;
        }
        return childrenMask.indexOf(initialIndex);
    }

    public void addTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.initialModel.addTreeModelListener(l);
    }

    public void removeTreeModelListener(@NotNull TreeModelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.initialModel.removeTreeModelListener(l);
    }

    public int getColumnCount() {
        return this.initialModel.getColumnCount();
    }

    @NotNull
    public String getColumnName(int column) {
        return this.initialModel.getColumnName(column);
    }

    @NotNull
    public Class<?> getColumnClass(int column) {
        return this.initialModel.getColumnClass(column);
    }

    @NotNull
    public Object getValueAt(@Nullable Object node, int column) {
        return this.initialModel.getValueAt(node, column);
    }

    public boolean isCellEditable(@Nullable Object node, int column) {
        return this.initialModel.isCellEditable(node, column);
    }

    public void setValueAt(@Nullable Object aValue, @Nullable Object node, int column) {
        this.initialModel.setValueAt(aValue, node, column);
    }

    public void setTree(@Nullable JTree tree) {
        this.initialModel.setTree(tree);
    }

    public final void setCondition(@NotNull Function1<Object, Boolean> condition) {
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        this.condition = condition;
    }

    public final void refilter() {
        this.acceptedNodeIndex = this.buildAcceptanceCache();
        this.initialModel.treeStructureChanged$intellij_platform_debugger_impl();
    }

    private final Map<Object, List<Integer>> buildAcceptanceCache() {
        Map acceptedNodesIndicesToChildren = new LinkedHashMap();
        this.processNode(this.getRoot(), acceptedNodesIndicesToChildren);
        return acceptedNodesIndicesToChildren;
    }

    private final boolean processNode(Object node, Map<Object, List<Integer>> acceptedNodesIndicesToChildren) {
        boolean isAccepted = false;
        List acceptedChildrenIndices = new ArrayList();
        int n = this.initialModel.getChildCount(node);
        for (int i = 0; i < n; ++i) {
            Object child = this.initialModel.getChild(node, i);
            if (child == null) {
                FilteringTreeTableModelKt.access$getLogger$p().error("Child " + i + " of node " + node + " is not expected to be null");
                continue;
            }
            boolean isChildAccepted = this.processNode(child, acceptedNodesIndicesToChildren);
            if (isChildAccepted) {
                acceptedChildrenIndices.add(i);
            }
            isAccepted = isChildAccepted | isAccepted;
        }
        if (isAccepted |= this.matches(node)) {
            acceptedNodesIndicesToChildren.put(node, acceptedChildrenIndices);
        }
        return isAccepted;
    }

    private final boolean matches(Object item) {
        return (Boolean)this.condition.invoke(item);
    }

    private static final boolean condition$lambda$0(Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }
}

