/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.memory.component.InstancesTracker;
import com.intellij.xdebugger.memory.tracking.TrackerForNewInstancesBase;
import com.intellij.xdebugger.memory.tracking.TrackingType;
import com.intellij.xdebugger.memory.ui.ClassesFilteredViewBase;
import com.intellij.xdebugger.memory.ui.TypeInfo;
import com.intellij.xdebugger.memory.utils.AbstractTableColumnDescriptor;
import com.intellij.xdebugger.memory.utils.AbstractTableModelWithColumns;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClassesTable
extends JBTable
implements UiDataProvider,
Disposable {
    public static final DataKey<TypeInfo> SELECTED_CLASS_KEY = DataKey.create((String)"ClassesTable.SelectedClass");
    public static final DataKey<ReferenceCountProvider> REF_COUNT_PROVIDER_KEY = DataKey.create((String)"ClassesTable.ReferenceCountProvider");
    private static final JBColor CLICKABLE_COLOR = new JBColor(new Color(250, 251, 252), new Color(62, 66, 69));
    private static final SimpleTextAttributes LINK_ATTRIBUTES = new SimpleTextAttributes(0, SimpleTextAttributes.LINK_ATTRIBUTES.getFgColor());
    private static final SimpleTextAttributes UNDERLINE_LINK_ATTRIBUTES = SimpleTextAttributes.LINK_ATTRIBUTES;
    private static final int CLASSES_COLUMN_PREFERRED_WIDTH = 250;
    private static final int COUNT_COLUMN_MIN_WIDTH = 80;
    private static final int DIFF_COLUMN_MIN_WIDTH = 80;
    private static final UnknownDiffValue UNKNOWN_VALUE = new UnknownDiffValue();
    private final DiffViewTableModel myModel;
    private final Map<TypeInfo, DiffValue> myCounts;
    private final InstancesTracker myInstancesTracker;
    private final ClassesFilteredViewBase myParent;
    private final ReferenceCountProvider myCountProvider;
    private boolean myOnlyWithDiff;
    private boolean myOnlyTracked;
    private boolean myOnlyWithInstances;
    private MinusculeMatcher myMatcher;
    private String myFilteringPattern;
    private final MergingUpdateQueue myFilterTypingMergeQueue;
    private volatile List<TypeInfo> myItems;
    private boolean myIsShowCounts;
    private MouseListener myMouseListener;

    public ClassesTable(@NotNull Project project, @NotNull ClassesFilteredViewBase parent, boolean onlyWithDiff, boolean onlyWithInstances, boolean onlyTracked) {
        if (project == null) {
            ClassesTable.$$$reportNull$$$0(0);
        }
        if (parent == null) {
            ClassesTable.$$$reportNull$$$0(1);
        }
        this.myCounts = new ConcurrentHashMap<TypeInfo, DiffValue>();
        this.myMatcher = NameUtil.buildMatcher((String)"*").build();
        this.myFilteringPattern = "";
        this.myFilterTypingMergeQueue = new MergingUpdateQueue("Classes table typing merging queue", 500, true, (JComponent)((Object)this), (Disposable)this, (JComponent)((Object)this), true).setRestartTimerOnAdd(true);
        this.myItems = Collections.unmodifiableList(new ArrayList());
        this.myIsShowCounts = true;
        this.myMouseListener = null;
        this.myModel = this.getTableModel();
        this.setModel(this.myModel);
        this.myOnlyWithDiff = onlyWithDiff;
        this.myOnlyWithInstances = onlyWithInstances;
        this.myOnlyTracked = onlyTracked;
        this.myInstancesTracker = InstancesTracker.getInstance(project);
        this.myParent = parent;
        this.customizeColumns();
        this.setShowGrid(false);
        this.setIntercellSpacing((Dimension)new JBDimension(0, 0));
        this.setDefaultRenderer(TypeInfo.class, (TableCellRenderer)((Object)new MyClassColumnRenderer()));
        this.setDefaultRenderer(Long.class, (TableCellRenderer)((Object)new MyCountColumnRenderer()));
        this.setDefaultRenderer(DiffValue.class, (TableCellRenderer)((Object)new MyDiffColumnRenderer()));
        this.setSelectionMode(0);
        this.myCountProvider = new ReferenceCountProvider(){

            @Override
            public int getTotalCount(@NotNull TypeInfo ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(0);
                }
                return (int)ClassesTable.this.myCounts.get((Object)ref).myCurrentCount;
            }

            @Override
            public int getDiffCount(@NotNull TypeInfo ref) {
                if (ref == null) {
                    1.$$$reportNull$$$0(1);
                }
                return (int)ClassesTable.this.myCounts.get(ref).diff();
            }

            @Override
            public int getNewInstancesCount(@NotNull TypeInfo ref) {
                TrackerForNewInstancesBase strategy;
                if (ref == null) {
                    1.$$$reportNull$$$0(2);
                }
                return (strategy = ClassesTable.this.myParent.getStrategy(ref)) == null || !strategy.isReady() ? -1 : strategy.getCount();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "ref";
                objectArray2[1] = "com/intellij/xdebugger/memory/ui/ClassesTable$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getTotalCount";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getDiffCount";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "getNewInstancesCount";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected DiffViewTableModel getTableModel() {
        return new DiffViewTableModel();
    }

    protected void customizeColumns() {
        TableColumnModel columnModel = this.getColumnModel();
        TableColumn classesColumn = columnModel.getColumn(0);
        TableColumn countColumn = columnModel.getColumn(1);
        TableColumn diffColumn = columnModel.getColumn(2);
        this.setAutoResizeMode(2);
        classesColumn.setPreferredWidth(JBUIScale.scale((int)250));
        countColumn.setMinWidth(JBUIScale.scale((int)80));
        diffColumn.setMinWidth(JBUIScale.scale((int)80));
        TableRowSorter<DiffViewTableModel> sorter = new TableRowSorter<DiffViewTableModel>(this.myModel);
        sorter.setRowFilter(new RowFilter<DiffViewTableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends DiffViewTableModel, ? extends Integer> entry) {
                int ix = entry.getIdentifier();
                TypeInfo ref = ClassesTable.this.getTypeInfoAt(ix);
                DiffValue diff = ClassesTable.this.myCounts.getOrDefault(ref, UNKNOWN_VALUE);
                boolean isFilteringOptionsRefused = ClassesTable.this.myOnlyWithDiff && diff.diff() == 0L || ClassesTable.this.myOnlyWithInstances && !diff.hasInstance() || ClassesTable.this.myOnlyTracked && ClassesTable.this.myParent.getStrategy(ref) == null;
                return !isFilteringOptionsRefused && ClassesTable.this.myMatcher.matches(ref.name());
            }
        });
        List<RowSorter.SortKey> myDefaultSortingKeys = this.getTableSortingKeys();
        sorter.setSortKeys(myDefaultSortingKeys);
        this.setRowSorter(sorter);
    }

    @NotNull
    protected List<RowSorter.SortKey> getTableSortingKeys() {
        List<RowSorter.SortKey> list = Arrays.asList(new RowSorter.SortKey(2, SortOrder.DESCENDING), new RowSorter.SortKey(1, SortOrder.DESCENDING), new RowSorter.SortKey(0, SortOrder.ASCENDING));
        if (list == null) {
            ClassesTable.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public TypeInfo getSelectedClass() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            int ix = this.convertRowIndexToModel(selectedRow);
            return this.getTypeInfoAt(ix);
        }
        return null;
    }

    @Nullable
    public TypeInfo getClassByName(@NotNull String name) {
        if (name == null) {
            ClassesTable.$$$reportNull$$$0(3);
        }
        for (TypeInfo ref : this.myItems) {
            if (!name.equals(ref.name())) continue;
            return ref;
        }
        return null;
    }

    public boolean isInClickableMode() {
        return this.myMouseListener != null;
    }

    public void makeClickable(final @NotNull Runnable onClick) {
        if (onClick == null) {
            ClassesTable.$$$reportNull$$$0(4);
        }
        this.releaseMouseListener();
        AnAction action = new AnAction(){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                onClick.run();
                ClassesTable.this.releaseMouseListener();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/memory/ui/ClassesTable$3", "actionPerformed"));
            }
        };
        KeyboardShortcut shortcut = new KeyboardShortcut(KeyStroke.getKeyStroke(108, 64), null);
        action.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{shortcut}), null);
        MyMouseAdapter listener = new MyMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                onClick.run();
                ClassesTable.this.releaseMouseListener();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.updateTable(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.updateTable(false);
            }

            @Override
            void updateTable(boolean mouseOnTable) {
                ClassesTable.this.setBackground((Color)(mouseOnTable ? CLICKABLE_COLOR : JBColor.background()));
                SimpleTextAttributes linkAttributes = mouseOnTable ? UNDERLINE_LINK_ATTRIBUTES : LINK_ATTRIBUTES;
                ClassesTable.this.getEmptyText().clear().appendText(XDebuggerBundle.message((String)"memory.view.no.classes.loaded", (Object[])new Object[0])).appendText(" ").appendText(XDebuggerBundle.message((String)"memory.view.load.classes", (Object[])new Object[0]), linkAttributes).appendText(" ");
            }
        };
        listener.updateTable(this.isUnderMouseCursor());
        this.myMouseListener = listener;
        this.addMouseListener(this.myMouseListener);
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    void exitClickableMode() {
        this.releaseMouseListener();
        this.getEmptyText().setText(StatusText.getDefaultEmptyText());
    }

    private void releaseMouseListener() {
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isInClickableMode()) {
            this.removeMouseListener(this.myMouseListener);
            this.myMouseListener = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.setBackground(JBColor.background());
        }
    }

    public void setBusy(boolean value) {
        this.setPaintBusy(value);
    }

    void setFilterPattern(String pattern) {
        if (!this.myFilteringPattern.equals(pattern)) {
            this.myFilteringPattern = pattern;
            this.myFilterTypingMergeQueue.queue(new Update(this.myMatcher, true){

                public void run() {
                    String newPattern = "*" + ClassesTable.this.myFilteringPattern;
                    if (ClassesTable.this.myMatcher.getPattern().equals(newPattern)) {
                        return;
                    }
                    ClassesTable.this.myMatcher = NameUtil.buildMatcher((String)newPattern).build();
                    ClassesTable.this.fireTableDataChanged();
                    if (ClassesTable.this.getSelectedClass() == null && ClassesTable.this.getRowCount() > 0) {
                        ClassesTable.this.getSelectionModel().setSelectionInterval(0, 0);
                    }
                }
            });
        }
    }

    void setFilteringByInstanceExists(boolean value) {
        if (value != this.myOnlyWithInstances) {
            this.myOnlyWithInstances = value;
            this.fireTableDataChanged();
        }
    }

    void setFilteringByDiffNonZero(boolean value) {
        if (this.myOnlyWithDiff != value) {
            this.myOnlyWithDiff = value;
            this.fireTableDataChanged();
        }
    }

    void setFilteringByTrackingState(boolean value) {
        if (this.myOnlyTracked != value) {
            this.myOnlyTracked = value;
            this.fireTableDataChanged();
        }
    }

    public void updateClassesOnly(@NotNull List<? extends TypeInfo> classes) {
        if (classes == null) {
            ClassesTable.$$$reportNull$$$0(5);
        }
        this.myIsShowCounts = false;
        LinkedHashMap<TypeInfo, Long> class2Count = new LinkedHashMap<TypeInfo, Long>();
        classes.forEach(x -> class2Count.put((TypeInfo)x, 0L));
        this.updateCountsInternal(class2Count);
    }

    public void updateContent(@NotNull Map<TypeInfo, Long> class2Count) {
        if (class2Count == null) {
            ClassesTable.$$$reportNull$$$0(6);
        }
        this.myIsShowCounts = true;
        this.updateCountsInternal(class2Count);
    }

    void hideContent(@NlsContexts.StatusText @NotNull String emptyText) {
        if (emptyText == null) {
            ClassesTable.$$$reportNull$$$0(7);
        }
        this.releaseMouseListener();
        this.getEmptyText().setText(emptyText);
        this.myModel.hide();
    }

    private void showContent() {
        this.myModel.show();
    }

    private void updateCountsInternal(@NotNull Map<TypeInfo, Long> class2Count) {
        if (class2Count == null) {
            ClassesTable.$$$reportNull$$$0(8);
        }
        this.releaseMouseListener();
        this.getEmptyText().setText(StatusText.getDefaultEmptyText());
        TypeInfo selectedClass = this.myModel.getSelectedClassBeforeHide();
        int newSelectedIndex = -1;
        boolean isInitialized = !this.myItems.isEmpty();
        this.myItems = List.copyOf(class2Count.keySet());
        int i = 0;
        for (TypeInfo ref : class2Count.keySet()) {
            if (ref.equals(selectedClass)) {
                newSelectedIndex = i;
            }
            DiffValue oldValue = isInitialized && !this.myCounts.containsKey(ref) ? new DiffValue(0L, 0L) : this.myCounts.getOrDefault(ref, UNKNOWN_VALUE);
            this.myCounts.put(ref, oldValue.update(class2Count.get(ref)));
            ++i;
        }
        this.showContent();
        if (newSelectedIndex != -1 && !this.myModel.isHidden()) {
            int ix = this.convertRowIndexToView(newSelectedIndex);
            this.changeSelection(ix, 0, false, false);
        }
        this.fireTableDataChanged();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            ClassesTable.$$$reportNull$$$0(9);
        }
        sink.set(SELECTED_CLASS_KEY, (Object)this.getSelectedClass());
        sink.set(REF_COUNT_PROVIDER_KEY, (Object)this.myCountProvider);
        DataSink.uiDataSnapshot((DataSink)sink, (Object)((Object)this.myParent));
    }

    public void clean(@NlsContexts.StatusText @NotNull String emptyText) {
        if (emptyText == null) {
            ClassesTable.$$$reportNull$$$0(10);
        }
        this.clearSelection();
        this.releaseMouseListener();
        this.getEmptyText().setText(emptyText);
        this.myItems = Collections.emptyList();
        this.myCounts.clear();
        this.myModel.mySelectedClassWhenHidden = null;
        this.fireTableDataChanged();
    }

    public void dispose() {
        ApplicationManager.getApplication().invokeLater(() -> this.clean(""));
    }

    private boolean isUnderMouseCursor() {
        if (ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return false;
        }
        try {
            return this.getMousePosition() != null;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Nullable
    private TrackingType getTrackingType(int row) {
        TypeInfo ref = (TypeInfo)this.getValueAt(row, this.convertColumnIndexToView(0));
        return this.myInstancesTracker.getTrackingType(ref.name());
    }

    private void fireTableDataChanged() {
        this.myModel.fireTableDataChanged();
    }

    protected AbstractTableColumnDescriptor @NotNull [] getColumnDescriptors() {
        AbstractTableColumnDescriptor[] abstractTableColumnDescriptorArray = new AbstractTableColumnDescriptor[]{new AbstractTableColumnDescriptor(XDebuggerBundle.message((String)"memory.view.table.column.name.class", (Object[])new Object[0]), TypeInfo.class){

            @Override
            public Object getValue(int ix) {
                return ClassesTable.this.getTypeInfoAt(ix);
            }
        }, new AbstractTableColumnDescriptor(XDebuggerBundle.message((String)"memory.view.table.column.name.count", (Object[])new Object[0]), Long.class){

            @Override
            public Object getValue(int ix) {
                return ClassesTable.this.myCounts.getOrDefault((Object)ClassesTable.this.getTypeInfoAt((int)ix), (DiffValue)ClassesTable.UNKNOWN_VALUE).myCurrentCount;
            }
        }, new AbstractTableColumnDescriptor(XDebuggerBundle.message((String)"memory.view.table.column.name.diff", (Object[])new Object[0]), DiffValue.class){

            @Override
            public Object getValue(int ix) {
                return ClassesTable.this.myCounts.getOrDefault(ClassesTable.this.getTypeInfoAt(ix), UNKNOWN_VALUE);
            }
        }};
        if (abstractTableColumnDescriptorArray == null) {
            ClassesTable.$$$reportNull$$$0(11);
        }
        return abstractTableColumnDescriptorArray;
    }

    protected TypeInfo getTypeInfoAt(int ix) {
        return this.myItems.get(ix);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/memory/ui/ClassesTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onClick";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "class2Count";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/memory/ui/ClassesTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTableSortingKeys";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassByName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "makeClickable";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateClassesOnly";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateContent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "hideContent";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateCountsInternal";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "clean";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 11 -> new IllegalStateException(string);
        };
    }

    public class DiffViewTableModel
    extends AbstractTableModelWithColumns {
        public static final int CLASSNAME_COLUMN_INDEX = 0;
        static final int COUNT_COLUMN_INDEX = 1;
        public static final int DIFF_COLUMN_INDEX = 2;
        private TypeInfo mySelectedClassWhenHidden;
        private boolean myIsWithContent;

        DiffViewTableModel() {
            super(ClassesTable.this.getColumnDescriptors());
            this.mySelectedClassWhenHidden = null;
            this.myIsWithContent = false;
        }

        TypeInfo getSelectedClassBeforeHide() {
            return this.mySelectedClassWhenHidden;
        }

        void hide() {
            if (this.myIsWithContent) {
                this.mySelectedClassWhenHidden = ClassesTable.this.getSelectedClass();
                this.myIsWithContent = false;
                ClassesTable.this.clearSelection();
                this.fireTableDataChanged();
            }
        }

        void show() {
            if (!this.myIsWithContent) {
                this.myIsWithContent = true;
                this.fireTableDataChanged();
            }
        }

        boolean isHidden() {
            return !this.myIsWithContent;
        }

        @Override
        public int getRowCount() {
            return this.myIsWithContent ? ClassesTable.this.myItems.size() : 0;
        }
    }

    private class MyClassColumnRenderer
    extends MyTableCellRenderer {
        private MyClassColumnRenderer() {
        }

        @Override
        protected void addText(@NotNull Object value, boolean isSelected, int row) {
            if (value == null) {
                MyClassColumnRenderer.$$$reportNull$$$0(0);
            }
            String presentation = ((TypeInfo)value).name();
            this.append(" ");
            if (isSelected) {
                FList textRanges = ClassesTable.this.myMatcher.matchingFragments(presentation);
                if (textRanges != null) {
                    SimpleTextAttributes attributes = new SimpleTextAttributes(this.getBackground(), this.getForeground(), null, 64);
                    SpeedSearchUtil.appendColoredFragments((SimpleColoredComponent)this, (String)presentation, (Iterable)textRanges, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (SimpleTextAttributes)attributes);
                }
            } else {
                this.append(String.format("%s", presentation), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/memory/ui/ClassesTable$MyClassColumnRenderer", "addText"));
        }
    }

    private class MyCountColumnRenderer
    extends MyNumericRenderer {
        private MyCountColumnRenderer() {
        }

        @Override
        void appendText(@NotNull Object value, int row) {
            if (value == null) {
                MyCountColumnRenderer.$$$reportNull$$$0(0);
            }
            this.append(value.toString());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/memory/ui/ClassesTable$MyCountColumnRenderer", "appendText"));
        }
    }

    private static class DiffValue
    implements Comparable<DiffValue> {
        private long myOldCount;
        private long myCurrentCount;

        DiffValue(long count) {
            this(count, count);
        }

        DiffValue(long old, long current) {
            this.myCurrentCount = current;
            this.myOldCount = old;
        }

        DiffValue update(long count) {
            this.myOldCount = this.myCurrentCount;
            this.myCurrentCount = count;
            return this;
        }

        boolean hasInstance() {
            return this.myCurrentCount > 0L;
        }

        long diff() {
            return this.myCurrentCount - this.myOldCount;
        }

        @Override
        public int compareTo(@NotNull DiffValue o) {
            if (o == null) {
                DiffValue.$$$reportNull$$$0(0);
            }
            return Long.compare(this.diff(), o.diff());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/xdebugger/memory/ui/ClassesTable$DiffValue", "compareTo"));
        }
    }

    private class MyDiffColumnRenderer
    extends MyNumericRenderer {
        private final SimpleTextAttributes myClickableCellAttributes;

        private MyDiffColumnRenderer() {
            this.myClickableCellAttributes = new SimpleTextAttributes(16, (Color)JBColor.BLUE);
        }

        @Override
        void appendText(@NotNull Object value, int row) {
            TrackingType trackingType;
            if (value == null) {
                MyDiffColumnRenderer.$$$reportNull$$$0(0);
            }
            if ((trackingType = ClassesTable.this.getTrackingType(row)) != null) {
                this.setIcon(AllIcons.Debugger.Db_watch);
                this.setTransparentIconBackground(true);
            }
            TypeInfo ref = ClassesTable.this.getTypeInfoAt(ClassesTable.this.convertRowIndexToModel(row));
            long diff = ClassesTable.this.myCountProvider.getDiffCount(ref);
            String text = String.format("%s%d", diff > 0L ? "+" : "", diff);
            int newInstancesCount = ClassesTable.this.myCountProvider.getNewInstancesCount(ref);
            if (newInstancesCount >= 0) {
                if ((long)newInstancesCount == diff) {
                    this.append(text, diff == 0L ? SimpleTextAttributes.REGULAR_ATTRIBUTES : this.myClickableCellAttributes);
                } else {
                    this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    if (newInstancesCount != 0) {
                        this.append(String.format(" (%d)", newInstancesCount), this.myClickableCellAttributes);
                    }
                }
            } else {
                this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/memory/ui/ClassesTable$MyDiffColumnRenderer", "appendText"));
        }
    }

    public static interface ReferenceCountProvider {
        public int getTotalCount(@NotNull TypeInfo var1);

        public int getDiffCount(@NotNull TypeInfo var1);

        public int getNewInstancesCount(@NotNull TypeInfo var1);
    }

    private static abstract class MyMouseAdapter
    extends MouseAdapter {
        private MyMouseAdapter() {
        }

        abstract void updateTable(boolean var1);
    }

    private static class UnknownDiffValue
    extends DiffValue {
        UnknownDiffValue() {
            super(-1L);
        }

        @Override
        boolean hasInstance() {
            return true;
        }

        @Override
        DiffValue update(long count) {
            return new DiffValue(count);
        }
    }

    private abstract class MyNumericRenderer
    extends MyTableCellRenderer {
        private MyNumericRenderer() {
        }

        @Override
        protected void addText(@NotNull Object value, boolean isSelected, int row) {
            if (value == null) {
                MyNumericRenderer.$$$reportNull$$$0(0);
            }
            if (ClassesTable.this.myIsShowCounts) {
                this.setTextAlign(4);
                this.appendText(value, row);
            }
        }

        abstract void appendText(@NotNull Object var1, int var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/memory/ui/ClassesTable$MyNumericRenderer", "addText"));
        }
    }

    public static abstract class MyTableCellRenderer
    extends ColoredTableCellRenderer {
        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (table == null) {
                MyTableCellRenderer.$$$reportNull$$$0(0);
            }
            if (hasFocus) {
                this.setBorder(new EmptyBorder(this.getBorder().getBorderInsets((Component)((Object)this))));
            }
            if (value != null) {
                this.addText(value, isSelected, row);
            }
        }

        protected abstract void addText(@NotNull Object var1, boolean var2, int var3);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/xdebugger/memory/ui/ClassesTable$MyTableCellRenderer", "customizeCellRenderer"));
        }
    }
}

