/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.XDebuggerWatchesManager;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.ui.InplaceEditor;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionComboBox;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class InlineWatchInplaceEditor
extends InplaceEditor {
    private final XSourcePosition myPresentationPosition;
    private final XDebugSessionProxy mySession;
    private final Editor myHostEditor;
    private final XExpression myInitialExpression;
    private XDebuggerExpressionComboBox myInplaceEditor;

    public InlineWatchInplaceEditor(XSourcePosition presentationPosition, @NotNull XDebugSessionProxy session, @NotNull Editor editor) {
        if (session == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(1);
        }
        this(presentationPosition, session, editor, null);
    }

    public InlineWatchInplaceEditor(XSourcePosition presentationPosition, @NotNull XDebugSessionProxy session, @NotNull Editor editor, XExpression expression) {
        if (session == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            InlineWatchInplaceEditor.$$$reportNull$$$0(3);
        }
        this.myPresentationPosition = presentationPosition;
        this.mySession = session;
        this.myHostEditor = editor;
        this.myInitialExpression = expression;
    }

    @Override
    protected void beforeShow() {
    }

    @Override
    protected JComponent createInplaceEditorComponent() {
        this.myInplaceEditor = new XDebuggerExpressionComboBox(this.mySession.getProject(), this.mySession.getEditorsProvider(), "inlineWatch", this.mySession.getCurrentPosition(), false, true);
        if (this.myInitialExpression != null) {
            this.myInplaceEditor.setExpression(this.myInitialExpression);
        }
        return this.myInplaceEditor.getComponent();
    }

    @Override
    protected JComponent getPreferredFocusedComponent() {
        return this.myInplaceEditor.getPreferredFocusedComponent();
    }

    @Override
    public Editor getEditor() {
        return this.myInplaceEditor.getEditor();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myInplaceEditor.getEditorComponent();
    }

    protected XExpression getExpression() {
        return this.myInplaceEditor.getExpression();
    }

    @Override
    public void doOKAction() {
        XExpression expression = this.getExpression();
        this.myInplaceEditor.saveTextInHistory();
        super.doOKAction();
        if (!XDebuggerUtilImpl.isEmptyExpression(expression)) {
            XDebuggerWatchesManager watchesManager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.mySession.getProject())).getWatchesManager();
            watchesManager.addInlineWatchExpression(expression, -1, this.myPresentationPosition, false);
        }
    }

    @Override
    public void cancelEditing() {
        super.cancelEditing();
        if (this.myInitialExpression != null) {
            XDebuggerWatchesManager watchesManager = ((XDebuggerManagerImpl)XDebuggerManager.getInstance((Project)this.mySession.getProject())).getWatchesManager();
            watchesManager.addInlineWatchExpression(this.myInitialExpression, -1, this.myPresentationPosition, false);
        }
    }

    @Override
    protected JComponent getHostComponent() {
        return this.myHostEditor.getContentComponent();
    }

    @Override
    protected Project getProject() {
        return this.mySession.getProject();
    }

    @Override
    protected Rectangle getEditorBounds() {
        int caretOffset = this.myHostEditor.getCaretModel().getOffset();
        Point caretPoint = this.myHostEditor.offsetToXY(caretOffset);
        int width = this.myHostEditor.getContentComponent().getWidth() - (caretPoint.x - this.myHostEditor.getContentComponent().getX());
        int height = this.myHostEditor.getLineHeight();
        Rectangle bounds = this.myHostEditor.getContentComponent().getVisibleRect();
        Rectangle lineBounds = new Rectangle(caretPoint.x, caretPoint.y, width, height);
        if (bounds == null) {
            return null;
        }
        if (bounds.y > lineBounds.y || bounds.y + bounds.height < lineBounds.y + lineBounds.height) {
            return null;
        }
        bounds.y = lineBounds.y;
        bounds.height = lineBounds.height;
        if (lineBounds.x > bounds.x) {
            bounds.width = bounds.width - lineBounds.x + bounds.x - UIUtil.getScrollBarWidth();
            bounds.x = lineBounds.x;
        }
        return bounds;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/inline/InlineWatchInplaceEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

