/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.attach.dialog.items.separators;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.impl.ui.attach.dialog.AttachDialogState;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H$J\n\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/separators/TableGroupHeaderSeparator;", "Lcom/intellij/ui/SeparatorWithText;", "hideLine", "", "<init>", "(Z)V", "myLabelInsets", "Ljava/awt/Insets;", "baseLineInsets", "getInsets", "getModifiedLineInsets", "getPreferredElementSize", "Ljava/awt/Dimension;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "paintLine", "bounds", "Ljava/awt/Rectangle;", "Companion", "intellij.platform.debugger.impl"})
public abstract class TableGroupHeaderSeparator
extends SeparatorWithText {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean hideLine;
    @NotNull
    private Insets myLabelInsets;
    @NotNull
    private Insets baseLineInsets;

    public TableGroupHeaderSeparator(boolean hideLine) {
        this.hideLine = hideLine;
        JBInsets jBInsets = JBUI.insets((int)TableGroupHeaderSeparator.Companion.getLABEL_TOP_BOTTOM_INSETS(), (int)8);
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"insets(...)");
        this.myLabelInsets = (Insets)jBInsets;
        if (ExperimentalUI.Companion.isNewUI()) {
            Insets insets = JBUI.CurrentTheme.Popup.separatorInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"separatorInsets(...)");
            this.baseLineInsets = insets;
            this.setBorder((Border)JBUI.Borders.empty());
            this.setFont(RelativeFont.BOLD.derive((Font)JBFont.small()));
        } else {
            JBInsets jBInsets2 = JBUI.insets((int)SeparatorWithText.getVgap(), (int)SeparatorWithText.getHgap(), (int)SeparatorWithText.getVgap(), (int)SeparatorWithText.getHgap());
            Intrinsics.checkNotNullExpressionValue((Object)jBInsets2, (String)"insets(...)");
            this.baseLineInsets = (Insets)jBInsets2;
        }
        this.baseLineInsets.set(TableGroupHeaderSeparator.Companion.getLINE_TOP_BOTTOM_INSETS(), this.baseLineInsets.left, TableGroupHeaderSeparator.Companion.getLINE_TOP_BOTTOM_INSETS(), this.baseLineInsets.right);
    }

    @NotNull
    public Insets getInsets() {
        JBInsets jBInsets = JBInsets.emptyInsets();
        Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
        return (Insets)jBInsets;
    }

    @NotNull
    protected abstract Insets getModifiedLineInsets(@NotNull Insets var1);

    @Nullable
    protected Dimension getPreferredElementSize() {
        Dimension dimension;
        if (this.getCaption() == null) {
            dimension = new Dimension(Math.max(this.myPrefWidth, 0), 0);
        } else {
            Dimension dimension2 = this.getLabelSize(this.myLabelInsets);
            Intrinsics.checkNotNull((Object)dimension2);
            dimension = dimension2;
        }
        Dimension size = dimension;
        Insets lineInsets = this.getModifiedLineInsets(this.baseLineInsets);
        if (!this.hideLine) {
            size.height += lineInsets.top + lineInsets.bottom + 1;
        }
        JBInsets.addTo((Dimension)size, (Insets)this.getInsets());
        return size;
    }

    protected void paintComponent(@NotNull Graphics g) {
        String caption;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.getForeground());
        Rectangle bounds = new Rectangle(this.getWidth(), this.getHeight());
        Insets lineInsets = this.getModifiedLineInsets(this.baseLineInsets);
        if (!this.hideLine) {
            this.paintLine(g, bounds);
            int lineHeight = lineInsets.top + lineInsets.bottom + TableGroupHeaderSeparator.Companion.getLINE_HEIGHT();
            bounds.y += lineHeight;
            bounds.height -= lineHeight;
        }
        if ((caption = this.getCaption()) != null) {
            bounds.x += this.myLabelInsets.left;
            bounds.width -= this.myLabelInsets.left + this.myLabelInsets.right;
            bounds.y += this.myLabelInsets.top;
            bounds.height -= this.myLabelInsets.top + this.myLabelInsets.bottom;
            Rectangle iconR = new Rectangle();
            Rectangle textR = new Rectangle();
            FontMetrics fm = g.getFontMetrics();
            String label = SwingUtilities.layoutCompoundLabel(fm, caption, null, 0, 2, 0, 2, bounds, iconR, textR, 0);
            UISettings.Companion.setupAntialiasing(g);
            g.setColor(this.getTextForeground());
            g.drawString(label, textR.x, textR.y + fm.getAscent());
        }
    }

    private final void paintLine(Graphics g, Rectangle bounds) {
        Insets lineInsets = this.getModifiedLineInsets(this.baseLineInsets);
        int x = bounds.x + lineInsets.left;
        int width = bounds.width - lineInsets.left - lineInsets.right;
        int y = bounds.y + lineInsets.top;
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        RectanglePainter.FILL.paint((Graphics2D)g, x, y, width, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/xdebugger/impl/ui/attach/dialog/items/separators/TableGroupHeaderSeparator$Companion;", "", "<init>", "()V", "LINE_HEIGHT", "", "getLINE_HEIGHT", "()I", "LABEL_TOP_BOTTOM_INSETS", "getLABEL_TOP_BOTTOM_INSETS", "LINE_TOP_BOTTOM_INSETS", "getLINE_TOP_BOTTOM_INSETS", "getExpectedHeight", "hideLine", "", "hasMessage", "intellij.platform.debugger.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final int getLINE_HEIGHT() {
            return JBUI.scale((int)1);
        }

        private final int getLABEL_TOP_BOTTOM_INSETS() {
            return JBUI.scale((int)3);
        }

        private final int getLINE_TOP_BOTTOM_INSETS() {
            return JBUI.scale((int)6);
        }

        public final int getExpectedHeight(boolean hideLine, boolean hasMessage) {
            return hasMessage ? this.getLABEL_TOP_BOTTOM_INSETS() * 2 + AttachDialogState.Companion.getDEFAULT_ROW_HEIGHT() + (hideLine ? 0 : this.getLINE_HEIGHT() + this.getLINE_TOP_BOTTOM_INSETS() * 2) : AttachDialogState.Companion.getDEFAULT_ROW_HEIGHT();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

