/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerExecutionPointManager;
import com.intellij.xdebugger.impl.XSourceKind;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.util.MonolithUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u001a\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001c\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001c\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002\u001a\u001a\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002\u00a8\u0006\u0011"}, d2={"updateAfterActiveSessionChanged", "", "currentSession", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "project", "Lcom/intellij/openapi/project/Project;", "updateGutterRendererIcon", "updateExecutionPosition", "navigationSourceKind", "Lcom/intellij/xdebugger/impl/XSourceKind;", "getGutterRenderer", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "breakpoint", "Lcom/intellij/xdebugger/impl/breakpoints/XBreakpointProxy;", "session", "setGutterRenderer", "renderer", "intellij.platform.debugger.impl"})
@SourceDebugExtension(value={"SMAP\nExecutionPointManagerChangeListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecutionPointManagerChangeListener.kt\ncom/intellij/xdebugger/impl/ExecutionPointManagerChangeListenerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class ExecutionPointManagerChangeListenerKt {
    private static final void updateAfterActiveSessionChanged(XDebugSessionProxy currentSession, Project project) {
        XDebuggerExecutionPointManager xDebuggerExecutionPointManager = XDebugManagerProxy.Companion.getInstance().getDebuggerExecutionPointManager(project);
        if (xDebuggerExecutionPointManager == null) {
            return;
        }
        XDebuggerExecutionPointManager executionPointManager = xDebuggerExecutionPointManager;
        if (currentSession != null) {
            XDebugSessionImpl xDebugSession = MonolithUtils.findSessionById(currentSession.getId());
            if (xDebugSession != null) {
                executionPointManager.setAlternativeSourceKindFlow((Flow<Boolean>)((Flow)xDebugSession.getAlternativeSourceKindState()));
                ExecutionPointManagerChangeListenerKt.updateExecutionPosition(project, xDebugSession.getCurrentSourceKind());
            } else {
                ExecutionPointManagerChangeListenerKt.updateExecutionPosition$default(project, null, 2, null);
            }
        } else {
            executionPointManager.clearExecutionPoint();
        }
    }

    private static final void updateGutterRendererIcon(Project project) {
        XDebugSessionProxy session = XDebugManagerProxy.Companion.getInstance().getCurrentSessionProxy(project);
        if (session != null && session.isTopFrameSelected()) {
            GutterIconRenderer renderer = ExecutionPointManagerChangeListenerKt.getGutterRenderer(session.getActiveNonLineBreakpoint(), session);
            ExecutionPointManagerChangeListenerKt.setGutterRenderer(project, renderer);
        } else {
            ExecutionPointManagerChangeListenerKt.setGutterRenderer(project, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static final void updateExecutionPosition(@NotNull Project project, @Nullable XSourceKind navigationSourceKind) {
        block9: {
            block8: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                v0 = XDebugManagerProxy.Companion.getInstance().getCurrentSessionProxy(project);
                if (v0 == null) {
                    return;
                }
                session = v0;
                isTopFrame = session.isTopFrameSelected();
                currentStackFrame = session.getCurrentStackFrame();
                xDebugSession = MonolithUtils.findSessionById(session.getId());
                if (navigationSourceKind != null || xDebugSession == null) break block8;
                v1 = xDebugSession.getSuspendContext();
                if (v1 == null) ** GOTO lbl-1000
                it = v1;
                $i$a$-let-ExecutionPointManagerChangeListenerKt$updateExecutionPosition$adjustedKind$forceUseAlternative$1 = false;
                v2 = xDebugSession.getDebugProcess().getAlternativeSourceHandler();
                v3 = v2 != null ? Boolean.valueOf(v2.isAlternativeSourceKindPreferred(it)) : null;
                v1 = v3;
                if (v3 != null) {
                    v4 = v1.booleanValue();
                } else lbl-1000:
                // 2 sources

                {
                    v4 = forceUseAlternative = false;
                }
                v5 = forceUseAlternative || ((Boolean)xDebugSession.getAlternativeSourceKindState().getValue()).booleanValue() ? XSourceKind.ALTERNATIVE : XSourceKind.MAIN;
                break block9;
            }
            v5 = XSourceKind.MAIN;
        }
        adjustedKind = v5;
        v6 = currentStackFrame;
        if (v6 != null) {
            it = v6;
            $i$a$-let-ExecutionPointManagerChangeListenerKt$updateExecutionPosition$mainSourcePosition$1 = false;
            v7 = session.getFrameSourcePosition(it, XSourceKind.MAIN);
        } else {
            v7 = null;
        }
        mainSourcePosition = v7;
        v8 = currentStackFrame;
        if (v8 != null) {
            it = v8;
            $i$a$-let-ExecutionPointManagerChangeListenerKt$updateExecutionPosition$alternativeSourcePosition$1 = false;
            v9 = session.getFrameSourcePosition(it, XSourceKind.ALTERNATIVE);
        } else {
            v9 = null;
        }
        alternativeSourcePosition = v9;
        v10 = XDebugManagerProxy.Companion.getInstance().getDebuggerExecutionPointManager(project);
        if (v10 != null) {
            v10.setExecutionPoint(mainSourcePosition, alternativeSourcePosition, isTopFrame, adjustedKind);
        }
        ExecutionPointManagerChangeListenerKt.updateGutterRendererIcon(project);
    }

    public static /* synthetic */ void updateExecutionPosition$default(Project project, XSourceKind xSourceKind, int n, Object object) {
        if ((n & 2) != 0) {
            xSourceKind = null;
        }
        ExecutionPointManagerChangeListenerKt.updateExecutionPosition(project, xSourceKind);
    }

    private static final GutterIconRenderer getGutterRenderer(XBreakpointProxy breakpoint2, XDebugSessionProxy session) {
        XBreakpointProxy xBreakpointProxy = breakpoint2;
        if (xBreakpointProxy == null || (xBreakpointProxy = xBreakpointProxy.createGutterIconRenderer()) == null) {
            XExecutionStack xExecutionStack = session.getCurrentExecutionStack();
            xBreakpointProxy = xExecutionStack != null ? xExecutionStack.getExecutionLineIconRenderer() : null;
        }
        return xBreakpointProxy;
    }

    private static final void setGutterRenderer(Project project, GutterIconRenderer renderer) {
        block0: {
            XDebuggerExecutionPointManager xDebuggerExecutionPointManager = XDebugManagerProxy.Companion.getInstance().getDebuggerExecutionPointManager(project);
            if (xDebuggerExecutionPointManager == null) break block0;
            xDebuggerExecutionPointManager.setGutterIconRenderer(renderer);
        }
    }

    public static final /* synthetic */ void access$updateGutterRendererIcon(Project project) {
        ExecutionPointManagerChangeListenerKt.updateGutterRendererIcon(project);
    }

    public static final /* synthetic */ void access$updateAfterActiveSessionChanged(XDebugSessionProxy currentSession, Project project) {
        ExecutionPointManagerChangeListenerKt.updateAfterActiveSessionChanged(currentSession, project);
    }
}

