/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.dfaassist;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MenuOnClickPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.PresentationRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.InlayModelImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.impl.dfaassist.DfaHint;
import com.intellij.xdebugger.impl.dfaassist.DfaResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DfaAssistBase
implements Disposable {
    protected final Project myProject;
    protected volatile AssistMode myMode;
    private DfaAssistMarkup myMarkup = new DfaAssistMarkup(null, Collections.emptyList(), Collections.emptyList());

    public DfaAssistBase(Project project) {
        this.myProject = project;
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    protected void displayInlays(DfaResult dfaResult) {
        InlayModelImpl model;
        void result2;
        ThreadingAssertions.assertEventDispatchThread();
        this.cleanUp();
        Map<PsiElement, DfaHint> hints = result2.hints;
        Collection<TextRange> unreachable = result2.unreachable;
        if (result2.file == null) {
            return;
        }
        EditorImpl editor = (EditorImpl)ObjectUtils.tryCast((Object)FileEditorManager.getInstance((Project)this.myProject).getSelectedTextEditor(), EditorImpl.class);
        if (editor == null) {
            return;
        }
        VirtualFile expectedFile = result2.file.getVirtualFile();
        if (expectedFile == null || !expectedFile.equals(editor.getVirtualFile())) {
            return;
        }
        ArrayList newInlays = new ArrayList();
        ArrayList<RangeHighlighter> ranges = new ArrayList<RangeHighlighter>();
        AssistMode mode = this.myMode;
        if (!hints.isEmpty() && mode.displayInlays()) {
            model = editor.getInlayModel();
            hints.forEach((arg_0, arg_1) -> this.lambda$displayInlays$1(editor, newInlays, (InlayModel)model, arg_0, arg_1));
        }
        if (!unreachable.isEmpty() && mode.displayGrayOut()) {
            model = editor.getMarkupModel();
            for (TextRange range : unreachable) {
                RangeHighlighter highlighter = model.addRangeHighlighter(HighlightInfoType.UNUSED_SYMBOL.getAttributesKey(), range.getStartOffset(), range.getEndOffset(), 5001, HighlighterTargetArea.EXACT_RANGE);
                ranges.add(highlighter);
            }
        }
        if (!newInlays.isEmpty() || !ranges.isEmpty()) {
            this.myMarkup = new DfaAssistMarkup((Editor)editor, newInlays, ranges);
        }
    }

    @NotNull
    protected @NotNull List<@NotNull AnAction> getInlayHintActions() {
        List<AnAction> list = Collections.singletonList(new TurnOffDfaProcessorAction());
        if (list == null) {
            DfaAssistBase.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void dispose() {
        this.cleanUp();
    }

    protected void cleanUp() {
        UIUtil.invokeLaterIfNeeded(() -> ReadAction.run(() -> Disposer.dispose((Disposable)this.myMarkup)));
    }

    private /* synthetic */ void lambda$displayInlays$1(EditorImpl editor, List newInlays, InlayModel model, PsiElement expr, DfaHint hint) {
        TextRange range = expr.getTextRange();
        if (range == null) {
            return;
        }
        PresentationFactory factory = new PresentationFactory((Editor)editor);
        MenuOnClickPresentation presentation = new MenuOnClickPresentation(factory.roundWithBackground(factory.smallText(hint.getTitle())), this.myProject, () -> this.getInlayHintActions());
        newInlays.add(model.addInlineElement(range.getEndOffset(), (EditorCustomElementRenderer)new PresentationRenderer((InlayPresentation)presentation)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/dfaassist/DfaAssistBase", "getInlayHintActions"));
    }

    private static final class DfaAssistMarkup
    implements Disposable {
        @NotNull
        private final List<Inlay<?>> myInlays;
        @NotNull
        private final List<RangeHighlighter> myRanges;

        private DfaAssistMarkup(@Nullable Editor editor, @NotNull List<Inlay<?>> inlays, @NotNull List<RangeHighlighter> ranges) {
            if (inlays == null) {
                DfaAssistMarkup.$$$reportNull$$$0(0);
            }
            if (ranges == null) {
                DfaAssistMarkup.$$$reportNull$$$0(1);
            }
            this.myInlays = inlays;
            this.myRanges = ranges;
            if (editor != null) {
                editor.getDocument().addDocumentListener(new DocumentListener(){

                    public void beforeDocumentChange(@NotNull DocumentEvent event) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeLater(() -> Disposer.dispose((Disposable)this));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/dfaassist/DfaAssistBase$DfaAssistMarkup$1", "beforeDocumentChange"));
                    }
                }, (Disposable)this);
            }
        }

        public void dispose() {
            ThreadingAssertions.assertEventDispatchThread();
            this.myInlays.forEach(Disposer::dispose);
            this.myInlays.clear();
            this.myRanges.forEach(RangeMarker::dispose);
            this.myRanges.clear();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inlays";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "ranges";
                    break;
                }
            }
            objectArray[1] = "com/intellij/xdebugger/impl/dfaassist/DfaAssistBase$DfaAssistMarkup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum AssistMode {
        NONE,
        INLAYS,
        GRAY_OUT,
        BOTH;


        boolean displayInlays() {
            return this == INLAYS || this == BOTH;
        }

        public boolean displayGrayOut() {
            return this == GRAY_OUT || this == BOTH;
        }
    }

    private final class TurnOffDfaProcessorAction
    extends AnAction {
        private TurnOffDfaProcessorAction() {
            super(XDebuggerBundle.message((String)"action.TurnOffDfaAssist.text", (Object[])new Object[0]), XDebuggerBundle.message((String)"action.TurnOffDfaAssist.description", (Object[])new Object[0]), AllIcons.Actions.Cancel);
        }

        public void actionPerformed(@NotNull AnActionEvent evt) {
            if (evt == null) {
                TurnOffDfaProcessorAction.$$$reportNull$$$0(0);
            }
            Disposer.dispose((Disposable)DfaAssistBase.this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evt", "com/intellij/xdebugger/impl/dfaassist/DfaAssistBase$TurnOffDfaProcessorAction", "actionPerformed"));
        }
    }
}

