/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxyKeeperKt;
import com.intellij.xdebugger.impl.frame.XDebugView;
import com.intellij.xdebugger.impl.frame.XVariablesViewBase;
import com.intellij.xdebugger.impl.inline.InlineDebugRenderer;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import java.awt.Component;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class XVariablesView
extends XVariablesViewBase {
    protected final JComponent myComponent;
    private final WeakReference<XDebugSessionProxy> myProxy;

    @Deprecated
    public XVariablesView(@NotNull XDebugSessionImpl session) {
        if (session == null) {
            XVariablesView.$$$reportNull$$$0(0);
        }
        this(XDebugSessionProxyKeeperKt.asProxy(session));
    }

    public XVariablesView(@NotNull XDebugSessionProxy proxy) {
        if (proxy == null) {
            XVariablesView.$$$reportNull$$$0(1);
        }
        super(proxy.getProject(), proxy.getEditorsProvider(), proxy.getValueMarkers());
        this.myProxy = new WeakReference<XDebugSessionProxy>(proxy);
        this.myComponent = UiDataProvider.wrapComponent((JComponent)this.createMainPanel(super.getPanel()), sink -> this.uiDataSnapshot(sink));
    }

    protected JPanel createMainPanel(JComponent localsPanel) {
        return new BorderLayoutPanel().addToCenter((Component)localsPanel);
    }

    @Override
    public JComponent getPanel() {
        return this.myComponent;
    }

    @Override
    public JComponent getMainComponent() {
        return this.getPanel();
    }

    protected void beforeTreeBuild(@NotNull XDebugView.SessionEvent event) {
        if (event == null) {
            XVariablesView.$$$reportNull$$$0(2);
        }
    }

    @Override
    @ApiStatus.Internal
    public void processSessionEvent(@NotNull XDebugView.SessionEvent event, @NotNull XDebugSessionProxy session) {
        if (event == null) {
            XVariablesView.$$$reportNull$$$0(3);
        }
        if (session == null) {
            XVariablesView.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.getTree().markNodesObsolete();
        }
        if (event == XDebugView.SessionEvent.STOPPED) {
            this.sessionStopped();
            this.myProxy.clear();
        }
        if (event == XDebugView.SessionEvent.BEFORE_RESUME) {
            return;
        }
        XStackFrame stackFrame = session.getCurrentStackFrame();
        ApplicationManager.getApplication().invokeLater(() -> {
            this.getTree().markNodesObsolete();
            if (stackFrame != null) {
                this.cancelClear();
                this.beforeTreeBuild(event);
                this.buildTreeAndRestoreState(stackFrame);
            } else {
                this.requestClear();
            }
        }, session.getProject().getDisposed());
    }

    @Override
    public void dispose() {
        this.clearInlineData(this.getTree());
        super.dispose();
    }

    @Deprecated
    @ApiStatus.Internal
    @Nullable
    public final XDebugSessionImpl getSession() {
        XDebugSessionProxy proxy = this.getSessionProxy();
        if (proxy == null) {
            return null;
        }
        if (!(proxy instanceof XDebugSessionProxy.Monolith)) {
            Logger.getInstance(XVariablesView.class).error("This method can be used only with monolith session proxies, got: " + String.valueOf(proxy) + " of type " + String.valueOf(proxy.getClass()) + " instead");
            return null;
        }
        XDebugSessionProxy.Monolith monolith = (XDebugSessionProxy.Monolith)proxy;
        return (XDebugSessionImpl)monolith.getSession();
    }

    @ApiStatus.Internal
    @Nullable
    public final XDebugSessionProxy getSessionProxy() {
        return (XDebugSessionProxy)this.myProxy.get();
    }

    private void clearInlineData(XDebuggerTree tree) {
        InlineVariablesInfo.set(this.getSessionProxy(), null);
        tree.updateEditor();
        XVariablesView.clearInlays(tree);
    }

    protected void addEmptyMessage(XValueContainerNode<?> root) {
        XDebugSessionProxy session = this.getSessionProxy();
        if (session == null) {
            return;
        }
        if (!session.isStopped() && session.isPaused()) {
            root.setInfoMessage(XDebuggerBundle.message((String)"message.frame.is.not.available", (Object[])new Object[0]), null);
        } else {
            root.setInfoMessage(session.getCurrentStateMessage(), session.getCurrentStateHyperlinkListener());
        }
    }

    @Override
    protected void clear() {
        XDebuggerTree tree = this.getTree();
        tree.setSourcePosition(null);
        this.clearInlineData(tree);
        XValueContainerNode root = this.createNewRootNode(null);
        this.addEmptyMessage(root);
        super.clear();
    }

    protected void uiDataSnapshot(@NotNull DataSink sink) {
        XDebugSessionProxy session;
        XSourcePosition position;
        if (sink == null) {
            XVariablesView.$$$reportNull$$$0(5);
        }
        XSourcePosition xSourcePosition = position = (session = this.getSessionProxy()) == null ? null : session.getCurrentPosition();
        if (position != null) {
            sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> position.getFile());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxy";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/frame/XVariablesView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeTreeBuild";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processSessionEvent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class InlineVariablesInfo {
        private static final Key<InlineVariablesInfo> DEBUG_VARIABLES = Key.create((String)"debug.variables");
        private List<InlineDebugRenderer> myInlays = null;

        @ApiStatus.Obsolete
        @Nullable
        public static InlineVariablesInfo get(@Nullable XDebugSession session) {
            if (session == null) {
                return null;
            }
            return InlineVariablesInfo.get(XDebugSessionProxyKeeperKt.asProxy(session));
        }

        @ApiStatus.Internal
        @Nullable
        public static InlineVariablesInfo get(@Nullable XDebugSessionProxy session) {
            if (session != null) {
                return (InlineVariablesInfo)DEBUG_VARIABLES.get((UserDataHolder)session.getSessionData());
            }
            return null;
        }

        @ApiStatus.Obsolete
        public static void set(@Nullable XDebugSession session, InlineVariablesInfo info) {
            if (session != null) {
                InlineVariablesInfo.set(XDebugSessionProxyKeeperKt.asProxy(session), info);
            }
        }

        @ApiStatus.Internal
        public static void set(@Nullable XDebugSessionProxy session, InlineVariablesInfo info) {
            if (session != null) {
                DEBUG_VARIABLES.set((UserDataHolder)session.getSessionData(), (Object)info);
            }
        }

        public void setInlays(List<InlineDebugRenderer> inlays) {
            this.myInlays = inlays;
        }

        @NotNull
        public List<InlineDebugRenderer> getInlays() {
            List list = (List)ObjectUtils.notNull(this.myInlays, Collections::emptyList);
            if (list == null) {
                InlineVariablesInfo.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/frame/XVariablesView$InlineVariablesInfo", "getInlays"));
        }
    }
}

