/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.inline;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.impl.inline.InlineDebugRendererBase;
import org.jetbrains.annotations.NotNull;

public class DebuggerInlayListener
implements EditorMouseMotionListener,
EditorMouseListener {
    private final Project myProject;
    private Inlay lastHoveredInlay;
    private boolean myListening;

    public DebuggerInlayListener(@NotNull Project project) {
        if (project == null) {
            DebuggerInlayListener.$$$reportNull$$$0(0);
        }
        this.lastHoveredInlay = null;
        this.myProject = project;
    }

    public void startListening() {
        if (!this.myListening) {
            this.myListening = true;
            EditorEventMulticaster multicaster = EditorFactory.getInstance().getEventMulticaster();
            multicaster.addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this.myProject);
            multicaster.addEditorMouseListener((EditorMouseListener)this, (Disposable)this.myProject);
        }
    }

    public void mouseMoved(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DebuggerInlayListener.$$$reportNull$$$0(1);
        }
        Inlay inlay = event.getInlay();
        if (this.lastHoveredInlay != null) {
            InlineDebugRendererBase renderer = (InlineDebugRendererBase)this.lastHoveredInlay.getRenderer();
            if (this.lastHoveredInlay != event.getInlay()) {
                renderer.onMouseExit(this.lastHoveredInlay);
            }
            this.lastHoveredInlay = null;
        }
        if (inlay != null) {
            if (inlay.getRenderer() instanceof InlineDebugRendererBase) {
                ((InlineDebugRendererBase)inlay.getRenderer()).onMouseMove(inlay, event);
                this.lastHoveredInlay = inlay;
            } else {
                this.lastHoveredInlay = null;
            }
        }
    }

    public void mouseClicked(@NotNull EditorMouseEvent event) {
        if (event == null) {
            DebuggerInlayListener.$$$reportNull$$$0(2);
        }
        if (event.isConsumed()) {
            return;
        }
        Inlay inlay = event.getInlay();
        if (inlay != null && inlay.getRenderer() instanceof InlineDebugRendererBase) {
            ((InlineDebugRendererBase)inlay.getRenderer()).onClick(inlay, event);
            event.consume();
        }
    }

    public static DebuggerInlayListener getInstance(Project project) {
        return (DebuggerInlayListener)project.getService(DebuggerInlayListener.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/inline/DebuggerInlayListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseMoved";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "mouseClicked";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

