/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.settings;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.xdebugger.impl.settings.DataViewsConfigurableUi;
import com.intellij.xdebugger.impl.settings.DebuggerConfigurable;
import com.intellij.xdebugger.impl.settings.MergedCompositeConfigurable;
import com.intellij.xdebugger.settings.DebuggerConfigurableProvider;
import com.intellij.xdebugger.settings.DebuggerSettingsCategory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class SubCompositeConfigurable
implements SearchableConfigurable.Parent,
SearchableConfigurable.Merged {
    protected DataViewsConfigurableUi root;
    @NotNull
    protected Configurable[] children;
    protected JComponent rootComponent;

    SubCompositeConfigurable() {
    }

    public boolean hasOwnContent() {
        return true;
    }

    @Nullable
    public String getHelpTopic() {
        this.buildConfigurables();
        return this.children != null && this.children.length == 1 ? this.children[0].getHelpTopic() : null;
    }

    public final void disposeUIResources() {
        this.root = null;
        this.rootComponent = null;
        if (this.isChildrenMerged()) {
            for (Configurable child : this.children) {
                child.disposeUIResources();
            }
        }
        this.children = null;
    }

    @Nullable
    protected abstract DataViewsConfigurableUi createRootUi();

    @NotNull
    protected abstract DebuggerSettingsCategory getCategory();

    private boolean isChildrenMerged() {
        return this.children != null && this.children.length == 1;
    }

    public final Configurable @NotNull [] getConfigurables() {
        this.buildConfigurables();
        Configurable[] configurableArray = this.isChildrenMerged() ? DebuggerConfigurable.EMPTY_CONFIGURABLES : this.children;
        if (configurableArray == null) {
            SubCompositeConfigurable.$$$reportNull$$$0(0);
        }
        return configurableArray;
    }

    @NotNull
    public final List<Configurable> getMergedConfigurables() {
        this.buildConfigurables();
        List<Configurable> list = this.isChildrenMerged() ? Arrays.asList(this.children) : Arrays.asList(DebuggerConfigurable.EMPTY_CONFIGURABLES);
        if (list == null) {
            SubCompositeConfigurable.$$$reportNull$$$0(1);
        }
        return list;
    }

    private void buildConfigurables() {
        if (this.children != null) {
            return;
        }
        List<Configurable> configurables = DebuggerConfigurable.getConfigurables(this.getCategory());
        this.children = configurables.toArray(new Configurable[0]);
    }

    @Nullable
    public final JComponent createComponent() {
        if (this.rootComponent == null) {
            if (this.root == null) {
                this.root = this.createRootUi();
            }
            this.buildConfigurables();
            if (this.isChildrenMerged()) {
                if (this.root == null) {
                    this.rootComponent = this.children[0].createComponent();
                } else {
                    JPanel panel2 = new JPanel((LayoutManager)new VerticalFlowLayout(0, 0));
                    if (this.root != null) {
                        DialogPanel c = this.root.getComponent();
                        c.setBorder(MergedCompositeConfigurable.BOTTOM_INSETS);
                        panel2.add((Component)c);
                    }
                    for (Configurable configurable : this.children) {
                        JComponent component = configurable.createComponent();
                        if (component == null) continue;
                        if (this.children[0] != configurable || !MergedCompositeConfigurable.isTargetedToProduct(configurable)) {
                            component.setBorder((Border)IdeBorderFactory.createTitledBorder((String)configurable.getDisplayName(), (boolean)false));
                        }
                        panel2.add(component);
                    }
                    this.rootComponent = panel2;
                }
            } else {
                this.rootComponent = this.root == null ? null : this.root.getComponent();
            }
        }
        return this.rootComponent;
    }

    public final void reset() {
        if (this.root != null) {
            this.root.getComponent().reset();
        }
        if (this.isChildrenMerged()) {
            for (Configurable child : this.children) {
                child.reset();
            }
        }
    }

    public final boolean isModified() {
        if (this.root != null && this.root.getComponent().isModified()) {
            return true;
        }
        if (this.isChildrenMerged()) {
            for (Configurable child : this.children) {
                if (!child.isModified()) continue;
                return true;
            }
        }
        return false;
    }

    public final void apply() throws ConfigurationException {
        if (this.root != null) {
            this.root.getComponent().apply();
            DebuggerConfigurableProvider.EXTENSION_POINT.getExtensionList().forEach(provider -> provider.generalApplied(this.getCategory()));
        }
        if (this.isChildrenMerged()) {
            for (Configurable child : this.children) {
                if (!child.isModified()) continue;
                child.apply();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xdebugger/impl/settings/SubCompositeConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurables";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergedConfigurables";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

