/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.runners.RunTab;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.layout.LayoutAttractionPolicy;
import com.intellij.execution.ui.layout.LayoutStateDefaults;
import com.intellij.ide.ui.customization.CustomActionsSchema;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.content.Content;
import com.intellij.util.ModalityUiUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerSessionTabBase
extends RunTab {
    protected ExecutionConsole myConsole;

    public DebuggerSessionTabBase(@NotNull Project project, @NotNull String runnerId, @NotNull String sessionName, @NotNull GlobalSearchScope searchScope, boolean shouldInitTabDefaults) {
        if (project == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(0);
        }
        if (runnerId == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(1);
        }
        if (sessionName == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(2);
        }
        if (searchScope == null) {
            DebuggerSessionTabBase.$$$reportNull$$$0(3);
        }
        super(project, searchScope, runnerId, XDebuggerBundle.message((String)"xdebugger.default.content.title", (Object[])new Object[0]), sessionName);
        LayoutStateDefaults defaults = this.myUi.getDefaults();
        if (shouldInitTabDefaults) {
            defaults.initTabDefaults(0, XDebuggerBundle.message((String)"xdebugger.debugger.tab.title", (Object[])new Object[0]), null);
        }
        defaults.initContentAttraction("FrameContent", "breakpoint").initContentAttraction("ConsoleContent", "startup", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce(false)).initContentAttraction("ConsoleContent", "finish", (LayoutAttractionPolicy)new LayoutAttractionPolicy.FocusOnce());
    }

    public static ActionGroup getCustomizedActionGroup(String id) {
        return (ActionGroup)CustomActionsSchema.getInstance().getCorrectedAction(id);
    }

    protected void attachNotificationTo(final Content content) {
        ExecutionConsole executionConsole = this.myConsole;
        if (executionConsole instanceof ObservableConsoleView) {
            ObservableConsoleView observable = (ObservableConsoleView)executionConsole;
            final AtomicBoolean alertFired = new AtomicBoolean();
            observable.addChangeListener(new ObservableConsoleView.ChangeListener(){

                public void textAdded(@NotNull String text, @NotNull ConsoleViewContentType type) {
                    if (text == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (type == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if ((type.equals(ConsoleViewContentType.ERROR_OUTPUT) || type.equals(ConsoleViewContentType.NORMAL_OUTPUT)) && alertFired.compareAndSet(false, true)) {
                        content.fireAlert();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "text";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "type";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase$1";
                    objectArray[2] = "textAdded";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }, (Disposable)content);
            RunProfile profile = this.getRunProfile();
            if (profile instanceof RunConfigurationBase && !ApplicationManager.getApplication().isUnitTestMode()) {
                observable.addChangeListener((ObservableConsoleView.ChangeListener)new RunContentBuilder.ConsoleToFrontListener((RunConfigurationBase)profile, this.myProject, DefaultDebugExecutor.getDebugExecutorInstance(), this.myRunContentDescriptor, this.myUi), (Disposable)content);
            }
        }
    }

    @Nullable
    protected RunProfile getRunProfile() {
        return this.myEnvironment != null ? this.myEnvironment.getRunProfile() : null;
    }

    public void select() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
            if (this.myRunContentDescriptor != null) {
                RunContentManager manager = RunContentManager.getInstance((Project)this.myProject);
                ToolWindow toolWindow = manager.getToolWindowByDescriptor(this.myRunContentDescriptor);
                Content content = this.myRunContentDescriptor.getAttachedContent();
                if (toolWindow == null || content == null) {
                    return;
                }
                manager.selectRunContent(this.myRunContentDescriptor);
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "runnerId";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "sessionName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "searchScope";
                break;
            }
        }
        objectArray[1] = "com/intellij/xdebugger/impl/ui/DebuggerSessionTabBase";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

