/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.ide.ui.AntiFlickeringPanel;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ClientEditorManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.Consumer;
import com.intellij.util.ui.JBUI;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxy;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointProxyKt;
import com.intellij.xdebugger.impl.breakpoints.ui.BreakpointsDialogFactory;
import com.intellij.xdebugger.impl.breakpoints.ui.XLightBreakpointPropertiesPanel;
import com.intellij.xdebugger.impl.frame.XDebugManagerProxy;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.frame.XWatchesView;
import com.intellij.xdebugger.impl.ui.BreakpointEditor;
import com.intellij.xdebugger.impl.ui.TextViewer;
import com.intellij.xdebugger.impl.ui.XDebugSessionData;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.XValueTextProvider;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.visualizedtext.VisualizedTextPopupUtil;
import com.intellij.xdebugger.impl.util.MonolithUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DebuggerUIUtil {
    @NonNls
    public static final String FULL_VALUE_POPUP_DIMENSION_KEY = "XDebugger.FullValuePopup";
    private static final Logger LOG = Logger.getInstance(DebuggerUIUtil.class);

    private DebuggerUIUtil() {
    }

    public static void enableEditorOnCheck(JCheckBox checkbox, JComponent textfield) {
        checkbox.addActionListener(e -> {
            boolean selected = checkbox.isSelected();
            textfield.setEnabled(selected);
        });
        textfield.setEnabled(checkbox.isSelected());
    }

    public static void focusEditorOnCheck(JCheckBox checkbox, JComponent component) {
        Runnable runnable = () -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)component, true));
        checkbox.addActionListener(e -> {
            if (checkbox.isSelected()) {
                SwingUtilities.invokeLater(runnable);
            }
        });
    }

    public static void invokeLater(Runnable runnable) {
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    @ApiStatus.Internal
    public static void invokeLaterIfNeeded(Runnable runnable) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            runnable.run();
        } else {
            ApplicationManager.getApplication().invokeLater(runnable, ModalityState.any());
        }
    }

    @Nullable
    public static RelativePoint getPositionForPopup(@NotNull Editor editor, int line) {
        if (editor == null) {
            DebuggerUIUtil.$$$reportNull$$$0(0);
        }
        if (line > -1) {
            boolean isRemoteEditor;
            Point p = editor.logicalPositionToXY(new LogicalPosition(line + 1, 0));
            boolean bl = isRemoteEditor = !ClientId.isLocal((ClientId)ClientEditorManager.getClientId((Editor)editor));
            if (isRemoteEditor || editor.getScrollingModel().getVisibleArea().contains(p)) {
                return new RelativePoint((Component)editor.getContentComponent(), p);
            }
        }
        return null;
    }

    public static void showPopupForEditorLine(final @NotNull JBPopup popup2, final @NotNull Editor editor, int line) {
        RelativePoint point;
        if (popup2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DebuggerUIUtil.$$$reportNull$$$0(2);
        }
        if ((point = DebuggerUIUtil.getPositionForPopup(editor, line)) != null) {
            popup2.addListener(new JBPopupListener(){

                public void beforeShown(@NotNull LightweightWindowEvent event) {
                    Window window;
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    Window window2 = window = popup2.isDisposed() ? null : ComponentUtil.getWindow((Component)popup2.getContent());
                    if (window != null) {
                        Point expected = point.getScreenPoint();
                        Rectangle screen = ScreenUtil.getScreenRectangle((Point)expected);
                        int y = expected.y - window.getHeight() - editor.getLineHeight();
                        if (screen.y < y) {
                            window.setLocation(window.getX(), y);
                        }
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$1", "beforeShown"));
                }
            });
            popup2.show(point);
        } else {
            Project project = editor.getProject();
            if (project != null) {
                popup2.showCenteredInCurrentWindow(project);
            } else {
                popup2.showInFocusCenter();
            }
        }
    }

    public static void showValuePopup(@NotNull XFullValueEvaluator evaluator, @NotNull MouseEvent event, @NotNull Project project, @Nullable Editor editor) {
        if (evaluator == null) {
            DebuggerUIUtil.$$$reportNull$$$0(3);
        }
        if (event == null) {
            DebuggerUIUtil.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DebuggerUIUtil.$$$reportNull$$$0(5);
        }
        WriteIntentReadAction.run(() -> VisualizedTextPopupUtil.evaluateAndShowValuePopup(evaluator, event, project, editor));
    }

    @ApiStatus.Experimental
    public static TextViewer createTextViewer(@NotNull String initialText, @NotNull Project project) {
        if (initialText == null) {
            DebuggerUIUtil.$$$reportNull$$$0(6);
        }
        if (project == null) {
            DebuggerUIUtil.$$$reportNull$$$0(7);
        }
        TextViewer textArea = new TextViewer(initialText, project);
        textArea.setBackground(HintUtil.getInformationColor());
        textArea.addSettingsProvider(e -> {
            e.getScrollPane().setBorder((Border)JBUI.Borders.empty());
            e.getScrollPane().setViewportBorder((Border)JBUI.Borders.empty());
        });
        return textArea;
    }

    @ApiStatus.Experimental
    public static Editor createFormattedTextEditor(@NotNull String initialText, @NotNull FileType type, @NotNull Project project, @NotNull Disposable parentDisposable, boolean isViewer) {
        if (initialText == null) {
            DebuggerUIUtil.$$$reportNull$$$0(8);
        }
        if (type == null) {
            DebuggerUIUtil.$$$reportNull$$$0(9);
        }
        if (project == null) {
            DebuggerUIUtil.$$$reportNull$$$0(10);
        }
        if (parentDisposable == null) {
            DebuggerUIUtil.$$$reportNull$$$0(11);
        }
        LightVirtualFile virtualFile = new LightVirtualFile("", type, (CharSequence)initialText);
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile((VirtualFile)virtualFile);
        assert (psiFile != null);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        assert (document != null);
        Editor editor = EditorFactory.getInstance().createEditor(document, project, (VirtualFile)virtualFile, isViewer);
        Disposer.register((Disposable)parentDisposable, () -> EditorFactory.getInstance().releaseEditor(editor));
        editor.getSettings().setLineNumbersShown(false);
        editor.getSettings().setUseSoftWraps(true);
        return editor;
    }

    @ApiStatus.Experimental
    public static Editor createFormattedTextViewer(@NotNull String initialText, @NotNull FileType type, @NotNull Project project, @NotNull Disposable parentDisposable) {
        if (initialText == null) {
            DebuggerUIUtil.$$$reportNull$$$0(12);
        }
        if (type == null) {
            DebuggerUIUtil.$$$reportNull$$$0(13);
        }
        if (project == null) {
            DebuggerUIUtil.$$$reportNull$$$0(14);
        }
        if (parentDisposable == null) {
            DebuggerUIUtil.$$$reportNull$$$0(15);
        }
        return DebuggerUIUtil.createFormattedTextEditor(initialText, type, project, parentDisposable, true);
    }

    public static JBPopup createValuePopup(Project project, JComponent component, @Nullable Runnable cancelCallback) {
        component.putClientProperty("EnableIMEForwardingInPopup", true);
        return DebuggerUIUtil.createCancelablePopupBuilder(project, component, null, cancelCallback, FULL_VALUE_POPUP_DIMENSION_KEY).createPopup();
    }

    @ApiStatus.Experimental
    public static ComponentPopupBuilder createCancelablePopupBuilder(Project project, JComponent component, JComponent preferableFocusComponent, @Nullable Runnable cancelCallback, @Nullable String dimensionKey) {
        ComponentPopupBuilder builder = JBPopupFactory.getInstance().createComponentPopupBuilder(component, preferableFocusComponent);
        builder.setResizable(true).setMovable(true).setRequestFocus(true);
        if (dimensionKey != null) {
            builder.setDimensionServiceKey(project, dimensionKey, false);
        }
        if (cancelCallback != null) {
            builder.setCancelCallback(() -> {
                cancelCallback.run();
                return true;
            });
        }
        return builder;
    }

    @ApiStatus.Obsolete
    public static void showXBreakpointEditorBalloon(Project project, @Nullable Point point, JComponent component, boolean showAllOptions, @NotNull XBreakpoint breakpoint2) {
        if (breakpoint2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(16);
        }
        if (breakpoint2 instanceof XBreakpointBase) {
            XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint2;
            DebuggerUIUtil.showXBreakpointEditorBalloon(project, point, component, showAllOptions, XBreakpointProxyKt.asProxy(breakpointBase));
        }
    }

    @ApiStatus.Internal
    public static void showXBreakpointEditorBalloon(Project project, @Nullable Point point, JComponent component, boolean showAllOptions, @NotNull XBreakpointProxy breakpoint2) {
        if (breakpoint2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(17);
        }
        DebuggerUIUtil.showXBreakpointEditorBalloon(project, point, component, showAllOptions, showAllOptions, breakpoint2);
    }

    @ApiStatus.Obsolete
    public static void showXBreakpointEditorBalloon(Project project, @Nullable Point point, JComponent component, boolean showActionOptions, boolean showAllOptions, @NotNull XBreakpoint breakpoint2) {
        if (breakpoint2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(18);
        }
        if (breakpoint2 instanceof XBreakpointBase) {
            XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint2;
            DebuggerUIUtil.showXBreakpointEditorBalloon(project, point, component, showActionOptions, showAllOptions, XBreakpointProxyKt.asProxy(breakpointBase));
        }
    }

    @ApiStatus.Internal
    public static void showXBreakpointEditorBalloon(Project project, @Nullable Point point, JComponent component, boolean showActionOptions, boolean showAllOptions, final @NotNull XBreakpointProxy breakpoint2) {
        if (breakpoint2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(19);
        }
        XBreakpointManagerProxy managerProxy = XDebugManagerProxy.getInstance().getBreakpointManagerProxy(project);
        final XLightBreakpointPropertiesPanel propertiesPanel = new XLightBreakpointPropertiesPanel(project, managerProxy, breakpoint2, showActionOptions, showAllOptions, true);
        Ref balloonRef = Ref.create(null);
        Ref isLoading = Ref.create((Object)Boolean.FALSE);
        Ref moreOptionsRequested = Ref.create((Object)Boolean.FALSE);
        propertiesPanel.setDelegate(() -> {
            if (!((Boolean)isLoading.get()).booleanValue()) {
                propertiesPanel.saveProperties();
            }
            if (!balloonRef.isNull()) {
                ((Balloon)balloonRef.get()).hide();
            }
            propertiesPanel.dispose();
            DebuggerUIUtil.showXBreakpointEditorBalloon(project, point, component, true, false, breakpoint2);
            moreOptionsRequested.set((Object)true);
        });
        isLoading.set((Object)Boolean.TRUE);
        propertiesPanel.loadProperties();
        isLoading.set((Object)Boolean.FALSE);
        if (((Boolean)moreOptionsRequested.get()).booleanValue()) {
            return;
        }
        Runnable showMoreOptions = () -> {
            propertiesPanel.saveProperties();
            propertiesPanel.dispose();
            BreakpointsDialogFactory.getInstance(project).showDialog(breakpoint2.getId());
        };
        JPanel mainPanel = propertiesPanel.getMainPanel();
        final Balloon balloon = DebuggerUIUtil.showBreakpointEditor(project, mainPanel, point, component, showMoreOptions, breakpoint2);
        balloonRef.set((Object)balloon);
        propertiesPanel.setBalloon(balloon);
        final Disposable disposable = Disposer.newDisposable();
        balloon.addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                Disposer.dispose((Disposable)disposable);
                propertiesPanel.saveProperties();
                propertiesPanel.dispose();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$2", "onClosed"));
            }
        });
        project.getMessageBus().connect(disposable).subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointRemoved(@NotNull XBreakpoint<?> removedBreakpoint) {
                XBreakpointBase breakpointBase;
                if (removedBreakpoint == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (removedBreakpoint instanceof XBreakpointBase && XBreakpointProxyKt.asProxy(breakpointBase = (XBreakpointBase)removedBreakpoint).equals(breakpoint2)) {
                    balloon.hide();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "removedBreakpoint", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$3", "breakpointRemoved"));
            }
        });
        ApplicationManager.getApplication().invokeLater(() -> IdeFocusManager.findInstance().requestFocus((Component)mainPanel, true));
    }

    public static Balloon showBreakpointEditor(Project project, JComponent mainPanel, Point whereToShow, JComponent component, final @Nullable Runnable showMoreOptions, Object breakpoint2) {
        BreakpointEditor editor = new BreakpointEditor();
        editor.setPropertiesPanel(mainPanel);
        editor.setShowMoreOptionsLink(true);
        JPanel panel2 = editor.getMainPanel();
        BalloonBuilder builder = JBPopupFactory.getInstance().createDialogBalloonBuilder((JComponent)panel2, null).setHideOnClickOutside(true).setCloseButtonEnabled(false).setAnimationCycle(0).setBlockClicksThroughBalloon(true);
        Color borderColor = UIManager.getColor("DebuggerPopup.borderColor");
        if (borderColor != null) {
            builder.setBorderColor(borderColor);
        }
        final Balloon balloon = builder.createBalloon();
        editor.setDelegate(new BreakpointEditor.Delegate(){

            @Override
            public void done() {
                balloon.hide();
            }

            @Override
            public void more() {
                assert (showMoreOptions != null);
                balloon.hide();
                showMoreOptions.run();
            }
        });
        ComponentAdapter moveListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                balloon.hide();
            }
        };
        component.addComponentListener(moveListener);
        Disposer.register((Disposable)balloon, () -> component.removeComponentListener(moveListener));
        HierarchyBoundsAdapter hierarchyBoundsListener = new HierarchyBoundsAdapter(){

            @Override
            public void ancestorMoved(HierarchyEvent e) {
                balloon.hide();
            }
        };
        component.addHierarchyBoundsListener(hierarchyBoundsListener);
        Disposer.register((Disposable)balloon, () -> component.removeHierarchyBoundsListener(hierarchyBoundsListener));
        if (whereToShow == null) {
            balloon.showInCenterOf(component);
        } else {
            Window window = SwingUtilities.windowForComponent(component);
            RelativePoint p = new RelativePoint((Component)component, whereToShow);
            if (window != null) {
                RelativePoint point = new RelativePoint((Component)window, new Point(0, 0));
                if (p.getScreenPoint().getX() - point.getScreenPoint().getX() < 40.0) {
                    p.getPoint().x += 40;
                }
            }
            balloon.show(p, Balloon.Position.below);
        }
        BreakpointsDialogFactory.getInstance(project).setBalloonToHide(balloon, breakpoint2);
        return balloon;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme() {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
        if (editorColorsScheme == null) {
            DebuggerUIUtil.$$$reportNull$$$0(20);
        }
        return editorColorsScheme;
    }

    @NotNull
    public static EditorColorsScheme getColorScheme(@Nullable JComponent component) {
        EditorColorsScheme editorColorsScheme = EditorColorsUtil.getColorSchemeForComponent((JComponent)component);
        if (editorColorsScheme == null) {
            DebuggerUIUtil.$$$reportNull$$$0(21);
        }
        return editorColorsScheme;
    }

    @Nullable
    public static String getNodeRawValue(@NotNull XValueNodeImpl valueNode2) {
        XValueTextProvider textValue;
        if (valueNode2 == null) {
            DebuggerUIUtil.$$$reportNull$$$0(22);
        }
        String res = null;
        Object ValueContainer = valueNode2.getValueContainer();
        if (ValueContainer instanceof XValueTextProvider && (textValue = (XValueTextProvider)ValueContainer).shouldShowTextValue()) {
            res = textValue.getValueText();
        }
        if (res == null) {
            res = valueNode2.getRawValue();
        }
        return res;
    }

    public static void addToWatches(@NotNull XWatchesView watchesView, @NotNull XValueNodeImpl node) {
        if (watchesView == null) {
            DebuggerUIUtil.$$$reportNull$$$0(23);
        }
        if (node == null) {
            DebuggerUIUtil.$$$reportNull$$$0(24);
        }
        DebuggerUIUtil.addToWatches(watchesView, (XValue)node.getValueContainer());
    }

    @ApiStatus.Internal
    public static void addToWatches(@NotNull XWatchesView watchesView, @NotNull XValue value) {
        if (watchesView == null) {
            DebuggerUIUtil.$$$reportNull$$$0(25);
        }
        if (value == null) {
            DebuggerUIUtil.$$$reportNull$$$0(26);
        }
        value.calculateEvaluationExpression().onSuccess(expression -> {
            if (expression != null) {
                DebuggerUIUtil.invokeLater(() -> watchesView.addWatchExpression((XExpression)expression, -1, false));
            }
        });
    }

    @Nullable
    public static XWatchesView getWatchesView(@NotNull AnActionEvent e) {
        XDebugSessionTab tab;
        XDebugSessionProxy proxy;
        if (e == null) {
            DebuggerUIUtil.$$$reportNull$$$0(27);
        }
        XWatchesView view = (XWatchesView)e.getData(XWatchesView.DATA_KEY);
        Project project = e.getProject();
        if (view == null && project != null && (proxy = DebuggerUIUtil.getSessionProxy(e)) != null && (tab = proxy.getSessionTab()) != null) {
            return tab.getWatchesView();
        }
        return view;
    }

    public static void registerActionOnComponent(String name, JComponent component, Disposable parentDisposable) {
        AnAction action = ActionManager.getInstance().getAction(name);
        action.registerCustomShortcutSet(action.getShortcutSet(), component, parentDisposable);
    }

    public static void registerExtraHandleShortcuts(final ListPopupImpl popup2, final Ref<Boolean> showAd, String ... actionNames) {
        for (String name : actionNames) {
            KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(name).getShortcutSet());
            if (stroke == null) continue;
            popup2.registerAction("handleSelection " + String.valueOf(stroke), stroke, (Action)new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    showAd.set((Object)false);
                    popup2.handleSelect(true);
                }
            });
        }
        if (((Boolean)showAd.get()).booleanValue()) {
            popup2.setAdText(DebuggerUIUtil.getSelectionShortcutsAdText(actionNames));
        }
    }

    @NlsContexts.PopupAdvertisement
    @NotNull
    public static String getSelectionShortcutsAdText(String ... actionNames) {
        String text = (String)StreamEx.of((Object[])actionNames).map(DebuggerUIUtil::getActionShortcutText).nonNull().collect(NlsMessages.joiningOr());
        String string = StringUtil.isEmpty((String)text) ? "" : XDebuggerBundle.message((String)"ad.extra.selection.shortcut", (Object[])new Object[]{text});
        if (string == null) {
            DebuggerUIUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    @Nullable
    public static String getActionShortcutText(String actionName) {
        KeyStroke stroke = KeymapUtil.getKeyStroke((ShortcutSet)ActionManager.getInstance().getAction(actionName).getShortcutSet());
        if (stroke != null) {
            return KeymapUtil.getKeystrokeText((KeyStroke)stroke);
        }
        return null;
    }

    public static boolean isObsolete(Object object) {
        return object instanceof Obsolescent && ((Obsolescent)object).isObsolete();
    }

    public static void setTreeNodeValue(XValueNodeImpl valueNode2, XExpression text, final Consumer<? super String> errorConsumer) {
        final XDebuggerTree tree = valueNode2.getTree();
        final Project project = tree.getProject();
        XValueModifier modifier = ((XValue)valueNode2.getValueContainer()).getModifier();
        if (modifier == null) {
            return;
        }
        final XDebuggerTreeState treeState = XDebuggerTreeState.saveState(tree);
        valueNode2.setValueModificationStarted();
        modifier.setValue(text, new XValueModifier.XModificationCallback(){

            public void valueModified() {
                AppUIUtil.invokeOnEdt(() -> {
                    if (tree.isDetached()) {
                        tree.rebuildAndRestore(treeState);
                    }
                });
                XDebuggerUtilImpl.rebuildAllSessionsViews(project);
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    8.$$$reportNull$$$0(0);
                }
                AppUIUtil.invokeOnEdt(() -> {
                    tree.rebuildAndRestore(treeState);
                    errorConsumer.consume((Object)errorMessage);
                });
                XDebuggerUtilImpl.rebuildAllSessionsViews(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/ui/DebuggerUIUtil$8", "errorOccurred"));
            }
        });
    }

    public static boolean isInDetachedTree(AnActionEvent event) {
        return event.getData(XDebugSessionTab.TAB_KEY) == null;
    }

    @Nullable
    public static XDebugSessionData getSessionData(AnActionEvent e) {
        XDebugSessionData data = (XDebugSessionData)((Object)e.getData(XDebugSessionData.DATA_KEY));
        if (data != null) {
            return data;
        }
        XDebugSessionProxy proxy = DebuggerUIUtil.getSessionProxy(e);
        if (proxy == null) {
            return null;
        }
        return proxy.getSessionData();
    }

    @Nullable
    public static XDebugSession getSession(@NotNull AnActionEvent e) {
        Project project;
        XDebugSession session;
        if (e == null) {
            DebuggerUIUtil.$$$reportNull$$$0(29);
        }
        if (XDebugSessionProxy.showFeWarnings() && XDebugSessionProxy.useFeProxy() && !MonolithUtils.isMonolith()) {
            LOG.error("In Split mode DebuggerUIUtil#getSession(AnActionEvent) should not be called from the frontend. Please use DebuggerUIUtil#getSessionProxy(AnActionEvent) instead.");
        }
        if ((session = (XDebugSession)e.getData(XDebugSession.DATA_KEY)) == null && (project = e.getProject()) != null) {
            session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        }
        return session;
    }

    @ApiStatus.Internal
    @Nullable
    public static XDebugSessionProxy getSessionProxy(@NotNull AnActionEvent e) {
        XDebugSessionProxy session;
        if (e == null) {
            DebuggerUIUtil.$$$reportNull$$$0(30);
        }
        if ((session = (XDebugSessionProxy)e.getData(XDebugSessionProxy.DEBUG_SESSION_PROXY_KEY)) != null) {
            return session;
        }
        Project project = e.getProject();
        if (project == null) {
            return null;
        }
        return XDebugManagerProxy.getInstance().getCurrentSessionProxy(project);
    }

    public static void repaintCurrentEditor(Project project) {
        Editor editor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (editor != null) {
            editor.getContentComponent().revalidate();
            editor.getContentComponent().repaint();
        }
    }

    public static void setActionEnabled(AnActionEvent e, boolean enable) {
        String place = e.getPlace();
        if (ActionPlaces.isMainMenuOrActionSearch((String)place) || "DebuggerToolbar".equals(place)) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }

    private static boolean shouldUseAntiFlickeringPanel() {
        return !ApplicationManager.getApplication().isUnitTestMode() && Registry.intValue((String)"debugger.anti.flickering.delay", (int)0) > 0;
    }

    @ApiStatus.Internal
    @NotNull
    public static JComponent wrapWithAntiFlickeringPanel(@NotNull JComponent component) {
        if (component == null) {
            DebuggerUIUtil.$$$reportNull$$$0(31);
        }
        JComponent jComponent = DebuggerUIUtil.shouldUseAntiFlickeringPanel() ? new AntiFlickeringPanel(component) : component;
        if (jComponent == null) {
            DebuggerUIUtil.$$$reportNull$$$0(32);
        }
        return jComponent;
    }

    @ApiStatus.Internal
    public static boolean freezePaintingToReduceFlickering(@Nullable Component component) {
        if (component instanceof AntiFlickeringPanel) {
            AntiFlickeringPanel antiFlickeringPanel = (AntiFlickeringPanel)component;
            int delay = Registry.intValue((String)"debugger.anti.flickering.delay", (int)0);
            if (delay > 0) {
                ApplicationManager.getApplication().invokeAndWait(() -> antiFlickeringPanel.freezePainting(delay), ModalityState.any());
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 20, 21, 28, 32 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialText";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakpoint";
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueNode";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchesView";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 27: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/ui/DebuggerUIUtil";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getColorScheme";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectionShortcutsAdText";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithAntiFlickeringPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPositionForPopup";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showPopupForEditorLine";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showValuePopup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTextViewer";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createFormattedTextEditor";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFormattedTextViewer";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showXBreakpointEditorBalloon";
                break;
            }
            case 20: 
            case 21: 
            case 28: 
            case 32: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getNodeRawValue";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addToWatches";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getWatchesView";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getSession";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSessionProxy";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithAntiFlickeringPanel";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 20, 21, 28, 32 -> new IllegalStateException(string);
        };
    }
}

