/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxBorder;
import com.intellij.ide.ui.laf.darcula.ui.DarculaComboBoxUI;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.jetbrains.annotations.NotNull;

class EmbeddedComboBoxUI
extends DarculaComboBoxUI {
    @NotNull
    protected final NonOpaquePanel myPanel = new NonOpaquePanel();

    EmbeddedComboBoxUI() {
        this.setPaintArrowButton(false);
    }

    public void setEmbeddedComponent(@NotNull JComponent panel2) {
        if (panel2 == null) {
            EmbeddedComboBoxUI.$$$reportNull$$$0(0);
        }
        this.myPanel.setContent(panel2);
    }

    protected void installDefaults() {
        super.installDefaults();
        if (this.padding == null) {
            this.padding = JBInsets.emptyInsets();
        }
        this.comboBox.setBorder((Border)new DarculaComboBoxBorder());
        this.comboBox.putClientProperty("JComboBox.isEmbedded", true);
    }

    protected boolean isNewBorderSupported(@NotNull JComboBox<?> comboBox) {
        if (comboBox == null) {
            EmbeddedComboBoxUI.$$$reportNull$$$0(1);
        }
        return true;
    }

    protected void installComponents() {
        super.installComponents();
        this.comboBox.add((Component)this.myPanel);
    }

    protected void uninstallDefaults() {
        this.comboBox.setBorder(null);
        super.uninstallDefaults();
    }

    protected LayoutManager createLayoutManager() {
        return new BasicComboBoxUI.ComboBoxLayoutManager(){
            final LayoutManager lm;
            {
                this.lm = EmbeddedComboBoxUI.super.createLayoutManager();
            }

            @Override
            public void layoutContainer(Container parent) {
                this.lm.layoutContainer(parent);
                JComboBox cb = (JComboBox)parent;
                Dimension aps = EmbeddedComboBoxUI.this.arrowButton.getPreferredSize();
                Dimension pps = EmbeddedComboBoxUI.this.myPanel.getPreferredSize();
                int availableWidth = cb.getWidth() - aps.width;
                if (EmbeddedComboBoxUI.this.comboBox.getComponentOrientation().isLeftToRight()) {
                    EmbeddedComboBoxUI.this.myPanel.setBounds(Math.max(availableWidth - pps.width, 0), (cb.getHeight() - pps.height) / 2, Math.min(pps.width, availableWidth), pps.height);
                } else {
                    EmbeddedComboBoxUI.this.myPanel.setBounds(EmbeddedComboBoxUI.this.arrowButton.getWidth(), (cb.getHeight() - pps.height) / 2, Math.min(pps.width, availableWidth), pps.height);
                }
            }
        };
    }

    protected Rectangle rectangleForCurrentValue() {
        Rectangle rectangle = super.rectangleForCurrentValue();
        rectangle.width -= this.myPanel.getWidth();
        if (!this.comboBox.getComponentOrientation().isLeftToRight()) {
            rectangle.x += this.arrowButton.getWidth() + this.myPanel.getWidth();
        }
        return rectangle;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/ui/EmbeddedComboBoxUI";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setEmbeddedComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isNewBorderSupported";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

